/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.SessionEvictionContext;

public class SessionEvictionCommand
implements Command<Void, SessionEvictionContext> {
    private static final long serialVersionUID = -4778211331615647237L;
    private final String id;

    SessionEvictionCommand(String id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Void execute(SessionEvictionContext context) throws Exception {
        TransactionBatch batch = (TransactionBatch)context.getBatcher().createBatch();
        boolean success = false;
        try {
            InfinispanWebLogger.ROOT_LOGGER.tracef("Passivating session %s", this.id);
            context.getEvictor().evict((Object)this.id);
            success = true;
        }
        finally {
            if (success) {
                batch.close();
            } else {
                batch.discard();
            }
        }
        return null;
    }
}

