/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Base64;
import javax.xml.bind.DatatypeConverter;
import org.wildfly.clustering.marshalling.spi.Serializer;

public enum IdentifierSerializer implements Serializer<String>
{
    UTF8{

        public void write(DataOutput output, String id) throws IOException {
            output.writeUTF(id);
        }

        public String read(DataInput input) throws IOException {
            return input.readUTF();
        }
    }
    ,
    BASE64{

        public void write(DataOutput output, String id) throws IOException {
            byte[] bytes = Base64.getUrlDecoder().decode(id);
            output.writeByte(bytes.length);
            output.write(bytes);
        }

        public String read(DataInput input) throws IOException {
            byte[] decoded = new byte[input.readUnsignedByte()];
            input.readFully(decoded);
            return Base64.getUrlEncoder().encodeToString(decoded);
        }
    }
    ,
    HEX{

        public void write(DataOutput output, String id) throws IOException {
            byte[] bytes = DatatypeConverter.parseHexBinary((String)id);
            output.writeByte(bytes.length);
            output.write(bytes);
        }

        public String read(DataInput input) throws IOException {
            byte[] decoded = new byte[input.readUnsignedByte()];
            input.readFully(decoded);
            return DatatypeConverter.printHexBinary((byte[])decoded);
        }
    };

}

