/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.routing;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.web.session.RoutingSupport;
import org.jboss.as.web.session.SessionIdentifierCodec;
import org.jboss.as.web.session.SimpleRoutingSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.web.WebDeploymentConfiguration;
import org.wildfly.clustering.web.routing.RouteLocator;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementProvider;
import org.wildfly.clustering.web.undertow.routing.DistributableSessionIdentifierCodec;

public class DistributableSessionIdentifierCodecServiceConfigurator
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
Function<RouteLocator, SessionIdentifierCodec> {
    private final CapabilityServiceConfigurator configurator;
    private final RoutingSupport routing = new SimpleRoutingSupport();

    public DistributableSessionIdentifierCodecServiceConfigurator(ServiceName name, WebDeploymentConfiguration configuration, DistributableSessionManagementProvider provider) {
        super(name);
        this.configurator = provider.getRouteLocatorServiceConfigurator(configuration);
    }

    @Override
    public SessionIdentifierCodec apply(RouteLocator locator) {
        return new DistributableSessionIdentifierCodec(locator, this.routing);
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.configurator.configure(support);
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        this.configurator.build(target).install();
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer codec = builder.provides(new ServiceName[]{this.getServiceName()});
        Supplier locator = builder.requires(this.configurator.getServiceName());
        FunctionalService service = new FunctionalService(codec, (Function)this, locator);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }
}

