/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.server.session.Session;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.wildfly.clustering.web.session.ActiveSessionStatistics;
import org.wildfly.clustering.web.session.InactiveSessionStatistics;
import org.wildfly.clustering.web.undertow.session.RecordableSessionManagerStatistics;

public class DistributableSessionManagerStatistics
implements RecordableSessionManagerStatistics {
    private final InactiveSessionStatistics inactiveSessionStatistics;
    private final ActiveSessionStatistics activeSessionStatistics;
    private volatile long startTime = System.currentTimeMillis();
    private final AtomicLong createdSessionCount = new AtomicLong();

    public DistributableSessionManagerStatistics(ActiveSessionStatistics activeSessionStatistics, InactiveSessionStatistics inactiveSessionStatistics) {
        this.activeSessionStatistics = activeSessionStatistics;
        this.inactiveSessionStatistics = inactiveSessionStatistics;
        this.reset();
    }

    public void record(Session object) {
        this.createdSessionCount.incrementAndGet();
    }

    public void reset() {
        this.createdSessionCount.set(0L);
        this.startTime = System.currentTimeMillis();
    }

    public long getCreatedSessionCount() {
        return this.createdSessionCount.get();
    }

    public long getMaxActiveSessions() {
        return this.activeSessionStatistics.getMaxActiveSessions();
    }

    public long getActiveSessionCount() {
        return this.activeSessionStatistics.getActiveSessionCount();
    }

    public long getExpiredSessionCount() {
        return this.inactiveSessionStatistics.getExpiredSessionCount();
    }

    public long getRejectedSessions() {
        return 0L;
    }

    public long getMaxSessionAliveTime() {
        return this.inactiveSessionStatistics.getMaxSessionLifetime(TimeUnit.MILLISECONDS);
    }

    public long getAverageSessionAliveTime() {
        return this.inactiveSessionStatistics.getMeanSessionLifetime(TimeUnit.MILLISECONDS);
    }

    public long getStartTime() {
        return this.startTime;
    }
}

