/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.security.idm.Account;
import io.undertow.security.impl.SingleSignOn;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.web.sso.SSO;
import org.wildfly.clustering.web.sso.Sessions;
import org.wildfly.clustering.web.undertow.sso.SessionManagerRegistry;

public class DistributableSingleSignOn
implements SingleSignOn {
    private final SSO<AuthenticatedSessionManager.AuthenticatedSession, String, Void> sso;
    private final SessionManagerRegistry registry;
    private final Batch batch;

    public DistributableSingleSignOn(SSO<AuthenticatedSessionManager.AuthenticatedSession, String, Void> sso, SessionManagerRegistry registry, Batch batch) {
        this.sso = sso;
        this.registry = registry;
        this.batch = batch;
    }

    public String getId() {
        return this.sso.getId();
    }

    public Account getAccount() {
        return ((AuthenticatedSessionManager.AuthenticatedSession)this.sso.getAuthentication()).getAccount();
    }

    public String getMechanismName() {
        return ((AuthenticatedSessionManager.AuthenticatedSession)this.sso.getAuthentication()).getMechanism();
    }

    public Iterator<Session> iterator() {
        Sessions sessions = this.sso.getSessions();
        Set deployments = sessions.getDeployments();
        ArrayList<InvalidatableSession> result = new ArrayList<InvalidatableSession>(deployments.size());
        for (String deployment : deployments) {
            Session session;
            String sessionId;
            SessionManager manager = this.registry.getSessionManager(deployment);
            if (manager == null || (sessionId = sessions.getSession((Object)deployment)) == null || (session = manager.getSession(sessions.getSession((Object)deployment))) == null) continue;
            result.add(new InvalidatableSession(session));
        }
        return result.iterator();
    }

    public boolean contains(Session session) {
        return this.sso.getSessions().getDeployments().contains(session.getSessionManager().getDeploymentName());
    }

    public void add(Session session) {
        this.sso.getSessions().addSession((Object)session.getSessionManager().getDeploymentName(), session.getId());
    }

    public void remove(Session session) {
        this.sso.getSessions().removeSession((Object)session.getSessionManager().getDeploymentName());
    }

    public Session getSession(SessionManager manager) {
        String sessionId = this.sso.getSessions().getSession((Object)manager.getDeploymentName());
        return sessionId != null ? manager.getSession(sessionId) : null;
    }

    public void close() {
        this.batch.close();
    }

    private static class SimpleSessionConfig
    implements SessionConfig {
        private final String id;

        SimpleSessionConfig(String id) {
            this.id = id;
        }

        public String findSessionId(HttpServerExchange exchange) {
            return this.id;
        }

        public void setSessionId(HttpServerExchange exchange, String sessionId) {
            throw new UnsupportedOperationException();
        }

        public void clearSession(HttpServerExchange exchange, String sessionId) {
            throw new UnsupportedOperationException();
        }

        public SessionConfig.SessionCookieSource sessionCookieSource(HttpServerExchange exchange) {
            throw new UnsupportedOperationException();
        }

        public String rewriteUrl(String originalUrl, String sessionId) {
            throw new UnsupportedOperationException();
        }
    }

    private static class InvalidatableSession
    implements Session {
        private final Session session;

        InvalidatableSession(Session session) {
            this.session = session;
        }

        public void invalidate(HttpServerExchange exchange) {
            Session session = this.session.getSessionManager().getSession(exchange, (SessionConfig)new SimpleSessionConfig(this.session.getId()));
            if (session != null) {
                session.invalidate(exchange);
            }
        }

        public String changeSessionId(HttpServerExchange exchange, SessionConfig config) {
            return this.session.changeSessionId(exchange, config);
        }

        public Object getAttribute(String name) {
            return this.session.getAttribute(name);
        }

        public Set<String> getAttributeNames() {
            return this.session.getAttributeNames();
        }

        public long getCreationTime() {
            return this.session.getCreationTime();
        }

        public String getId() {
            return this.session.getId();
        }

        public long getLastAccessedTime() {
            return this.session.getLastAccessedTime();
        }

        public int getMaxInactiveInterval() {
            return this.session.getMaxInactiveInterval();
        }

        public SessionManager getSessionManager() {
            return this.session.getSessionManager();
        }

        public Object removeAttribute(String name) {
            return this.session.removeAttribute(name);
        }

        public void requestDone(HttpServerExchange exchange) {
            this.session.requestDone(exchange);
        }

        public Object setAttribute(String name, Object value) {
            return this.session.setAttribute(name, value);
        }

        public void setMaxInactiveInterval(int interval) {
            this.session.setMaxInactiveInterval(interval);
        }
    }
}

