/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.marshalling.jboss.ExternalizerObjectTable;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.marshalling.jboss.SimpleClassTable;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshalledValueFactory;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingContext;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingContextFactory;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SessionManagerFactoryBuilderProvider;
import org.wildfly.clustering.web.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManagerFactory;
import org.wildfly.extension.undertow.session.DistributableSessionManagerConfiguration;

public class DistributableSessionManagerFactoryBuilder
implements org.wildfly.extension.undertow.session.DistributableSessionManagerFactoryBuilder,
Value<io.undertow.servlet.api.SessionManagerFactory> {
    static final Map<ReplicationGranularity, SessionManagerFactoryConfiguration.SessionAttributePersistenceStrategy> strategies = new EnumMap<ReplicationGranularity, SessionManagerFactoryConfiguration.SessionAttributePersistenceStrategy>(ReplicationGranularity.class);
    private final SessionManagerFactoryBuilderProvider<Batch> provider;
    private final InjectedValue<SessionManagerFactory> factory = new InjectedValue();

    private static SessionManagerFactoryBuilderProvider<Batch> load() {
        Iterator<SessionManagerFactoryBuilderProvider> iterator = ServiceLoader.load(SessionManagerFactoryBuilderProvider.class, SessionManagerFactoryBuilderProvider.class.getClassLoader()).iterator();
        if (iterator.hasNext()) {
            SessionManagerFactoryBuilderProvider provider = iterator.next();
            return provider;
        }
        return null;
    }

    public DistributableSessionManagerFactoryBuilder() {
        this(DistributableSessionManagerFactoryBuilder.load());
    }

    public DistributableSessionManagerFactoryBuilder(SessionManagerFactoryBuilderProvider<Batch> provider) {
        this.provider = provider;
    }

    public ServiceBuilder<io.undertow.servlet.api.SessionManagerFactory> build(CapabilityServiceSupport support, ServiceTarget target, ServiceName name, final DistributableSessionManagerConfiguration config) {
        Module module = config.getModule();
        SimpleMarshallingContext context = new SimpleMarshallingContextFactory().createMarshallingContext((MarshallingConfigurationRepository)new SimpleMarshallingConfigurationRepository(MarshallingVersion.class, (Enum)MarshallingVersion.CURRENT, (Object)module), (ClassLoader)module.getClassLoader());
        SimpleMarshalledValueFactory factory = new SimpleMarshalledValueFactory((MarshallingContext)context);
        SessionManagerFactoryConfiguration<MarshallingContext> configuration = new SessionManagerFactoryConfiguration<MarshallingContext>((MarshalledValueFactory)factory, (MarshallingContext)context){
            final /* synthetic */ MarshalledValueFactory val$factory;
            final /* synthetic */ MarshallingContext val$context;
            {
                this.val$factory = marshalledValueFactory;
                this.val$context = marshallingContext;
            }

            public int getMaxActiveSessions() {
                return config.getMaxActiveSessions();
            }

            public SessionManagerFactoryConfiguration.SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
                return strategies.get(config.getGranularity());
            }

            public String getDeploymentName() {
                return config.getDeploymentName();
            }

            public String getCacheName() {
                return config.getCacheName();
            }

            public MarshalledValueFactory<MarshallingContext> getMarshalledValueFactory() {
                return this.val$factory;
            }

            public MarshallingContext getMarshallingContext() {
                return this.val$context;
            }
        };
        Builder builder = this.provider.getBuilder((SessionManagerFactoryConfiguration)configuration).configure(support);
        builder.build(target).install();
        return target.addService(name, (Service)new ValueService((Value)this)).addDependency(builder.getServiceName(), SessionManagerFactory.class, this.factory).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public io.undertow.servlet.api.SessionManagerFactory getValue() {
        return new DistributableSessionManagerFactory((SessionManagerFactory<Batch>)((SessionManagerFactory)this.factory.getValue()));
    }

    static {
        strategies.put(ReplicationGranularity.SESSION, SessionManagerFactoryConfiguration.SessionAttributePersistenceStrategy.COARSE);
        strategies.put(ReplicationGranularity.ATTRIBUTE, SessionManagerFactoryConfiguration.SessionAttributePersistenceStrategy.FINE);
    }

    static enum MarshallingVersion implements Function<Module, MarshallingConfiguration>
    {
        VERSION_1{

            @Override
            public MarshallingConfiguration apply(Module module) {
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)module.getModuleLoader()));
                config.setClassTable((ClassTable)new SimpleClassTable(new Class[]{Serializable.class, Externalizable.class}));
                return config;
            }
        }
        ,
        VERSION_2{

            @Override
            public MarshallingConfiguration apply(Module module) {
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)module.getModuleLoader()));
                config.setClassTable((ClassTable)new SimpleClassTable(new Class[]{Serializable.class, Externalizable.class}));
                config.setObjectTable((ObjectTable)new ExternalizerObjectTable((ClassLoader)module.getClassLoader()));
                return config;
            }
        };

        static final MarshallingVersion CURRENT;

        static {
            CURRENT = VERSION_2;
        }
    }
}

