/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.security.impl.SingleSignOnManager;
import java.util.Arrays;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.sso.SSOManagerFactoryBuilderProvider;
import org.wildfly.clustering.web.undertow.sso.DistributableSingleSignOnManager;
import org.wildfly.clustering.web.undertow.sso.SSOManagerBuilder;
import org.wildfly.clustering.web.undertow.sso.SessionIdGeneratorBuilder;
import org.wildfly.clustering.web.undertow.sso.SessionListenerBuilder;
import org.wildfly.clustering.web.undertow.sso.SessionManagerRegistry;
import org.wildfly.clustering.web.undertow.sso.SessionManagerRegistryBuilder;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.security.sso.DistributableHostSingleSignOnManagerBuilder;

public class DistributableSingleSignOnManagerBuilder
implements DistributableHostSingleSignOnManagerBuilder,
Value<SingleSignOnManager> {
    private static final SSOManagerFactoryBuilderProvider<Batch> PROVIDER = (SSOManagerFactoryBuilderProvider)StreamSupport.stream(ServiceLoader.load(SSOManagerFactoryBuilderProvider.class, SSOManagerFactoryBuilderProvider.class.getClassLoader()).spliterator(), false).findFirst().get();
    private final InjectedValue<SSOManager> manager = new InjectedValue();
    private final InjectedValue<SessionManagerRegistry> registry = new InjectedValue();

    public ServiceBuilder<SingleSignOnManager> build(ServiceTarget target, ServiceName name, CapabilityServiceSupport support, String serverName, String hostName) {
        ServiceName hostServiceName = UndertowService.virtualHostName((String)serverName, (String)hostName);
        Builder factoryBuilder = PROVIDER.getBuilder(hostName).configure(support);
        SessionIdGeneratorBuilder generatorBuilder = new SessionIdGeneratorBuilder(hostServiceName);
        SSOManagerBuilder managerBuilder = new SSOManagerBuilder(factoryBuilder.getServiceName(), generatorBuilder.getServiceName(), () -> null);
        SessionListenerBuilder listenerBuilder = new SessionListenerBuilder(managerBuilder.getServiceName());
        SessionManagerRegistryBuilder registryBuilder = new SessionManagerRegistryBuilder(hostServiceName, listenerBuilder.getServiceName());
        Arrays.asList(factoryBuilder, generatorBuilder, managerBuilder, listenerBuilder, registryBuilder).forEach(builder -> builder.build(target).setInitialMode(ServiceController.Mode.ON_DEMAND).install());
        return target.addService(name, (Service)new ValueService((Value)this)).addDependency(managerBuilder.getServiceName(), SSOManager.class, this.manager).addDependency(registryBuilder.getServiceName(), SessionManagerRegistry.class, this.registry).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public SingleSignOnManager getValue() {
        return new DistributableSingleSignOnManager((SSOManager<AuthenticatedSessionManager.AuthenticatedSession, String, String, Void, Batch>)((SSOManager)this.manager.getValue()), (SessionManagerRegistry)this.registry.getValue());
    }
}

