/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso.elytron;

import io.undertow.server.session.SessionIdGenerator;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.SimpleBuilder;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.sso.SSOManagerFactoryBuilderProvider;
import org.wildfly.clustering.web.undertow.sso.SSOManagerBuilder;
import org.wildfly.clustering.web.undertow.sso.elytron.DistributableSingleSignOnManager;
import org.wildfly.clustering.web.undertow.sso.elytron.ElytronAuthentication;
import org.wildfly.clustering.web.undertow.sso.elytron.LocalSSOContext;
import org.wildfly.clustering.web.undertow.sso.elytron.LocalSSOContextFactory;
import org.wildfly.extension.undertow.security.sso.DistributableApplicationSecurityDomainSingleSignOnManagerBuilder;
import org.wildfly.security.http.util.sso.SingleSignOnManager;

public class DistributableSingleSignOnManagerBuilder
implements DistributableApplicationSecurityDomainSingleSignOnManagerBuilder,
Value<SingleSignOnManager> {
    private static final SSOManagerFactoryBuilderProvider<Batch> PROVIDER = (SSOManagerFactoryBuilderProvider)StreamSupport.stream(ServiceLoader.load(SSOManagerFactoryBuilderProvider.class, SSOManagerFactoryBuilderProvider.class.getClassLoader()).spliterator(), false).findFirst().get();
    private final InjectedValue<SSOManager> manager = new InjectedValue();

    public ServiceBuilder<SingleSignOnManager> build(ServiceTarget target, ServiceName name, CapabilityServiceSupport support, String securityDomainName, SessionIdGenerator generator) {
        ServiceName securityDomainServiceName = support.getCapabilityServiceName("org.wildfly.extension.undertow.application-security-domain", new String[]{securityDomainName});
        Builder factoryBuilder = PROVIDER.getBuilder(securityDomainName).configure(support);
        SimpleBuilder generatorBuilder = new SimpleBuilder(securityDomainServiceName.append(new String[]{"generator"}), (Object)generator);
        SSOManagerBuilder managerBuilder = new SSOManagerBuilder(factoryBuilder.getServiceName(), generatorBuilder.getServiceName(), new LocalSSOContextFactory());
        Arrays.asList(factoryBuilder, generatorBuilder, managerBuilder).forEach(builder -> builder.build(target).setInitialMode(ServiceController.Mode.ON_DEMAND).install());
        return target.addService(name, (Service)new ValueService((Value)this)).addDependency(managerBuilder.getServiceName(), SSOManager.class, this.manager).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public SingleSignOnManager getValue() {
        return new DistributableSingleSignOnManager((SSOManager<ElytronAuthentication, String, Map.Entry<String, URI>, LocalSSOContext, Batch>)((SSOManager)this.manager.getValue()));
    }
}

