/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ServiceLoader;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.web.session.SessionIdentifierCodec;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.web.session.RouteLocatorBuilderProvider;
import org.wildfly.clustering.web.undertow.session.DistributableSessionIdentifierCodecBuilder;
import org.wildfly.clustering.web.undertow.session.RouteBuilder;
import org.wildfly.extension.undertow.session.SimpleSessionIdentifierCodecBuilder;

public class DistributableSessionIdentifierCodecBuilderProvider
implements org.wildfly.extension.undertow.session.DistributableSessionIdentifierCodecBuilderProvider {
    private static final RouteLocatorBuilderProvider PROVIDER = DistributableSessionIdentifierCodecBuilderProvider.loadProvider();

    private static RouteLocatorBuilderProvider loadProvider() {
        Iterator<RouteLocatorBuilderProvider> iterator = ServiceLoader.load(RouteLocatorBuilderProvider.class, RouteLocatorBuilderProvider.class.getClassLoader()).iterator();
        if (iterator.hasNext()) {
            RouteLocatorBuilderProvider provider = iterator.next();
            return provider;
        }
        return null;
    }

    public CapabilityServiceBuilder<SessionIdentifierCodec> getDeploymentBuilder(ServiceName name, String serverName, String deploymentName) {
        return PROVIDER != null ? new DistributableSessionIdentifierCodecBuilder(name, serverName, deploymentName, PROVIDER) : new SimpleSessionIdentifierCodecBuilder(name, serverName);
    }

    public Collection<CapabilityServiceBuilder<?>> getServerBuilders(String serverName) {
        LinkedList builders = new LinkedList();
        RouteBuilder routeBuilder = new RouteBuilder(serverName);
        builders.add(routeBuilder);
        InjectedValueDependency routeDependency = new InjectedValueDependency((ServiceNameProvider)routeBuilder, String.class);
        if (PROVIDER != null) {
            builders.addAll(PROVIDER.getRouteLocatorConfigurationBuilders(serverName, (ValueDependency)routeDependency));
        }
        return builders;
    }
}

