/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.server.protocol.http.HttpServerConnection;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionListeners;
import io.undertow.servlet.handlers.security.CachedAuthenticatedSessionHandler;
import io.undertow.util.Protocols;
import jakarta.servlet.http.HttpSessionActivationListener;
import java.lang.invoke.CallSite;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.BatchContext;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Recordable;
import org.wildfly.clustering.web.session.SessionAttributes;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionMetaData;
import org.wildfly.clustering.web.undertow.session.DistributableSession;
import org.wildfly.clustering.web.undertow.session.RecordableSessionManagerStatistics;
import org.wildfly.clustering.web.undertow.session.UndertowSessionManager;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;
import org.xnio.channels.Configurable;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

public class DistributableSessionTestCase {
    private final SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
    private final UndertowSessionManager manager = (UndertowSessionManager)Mockito.mock(UndertowSessionManager.class);
    private final SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
    private final org.wildfly.clustering.web.session.Session<Map<String, Object>> session = (org.wildfly.clustering.web.session.Session)Mockito.mock(org.wildfly.clustering.web.session.Session.class);
    private final Batch batch = (Batch)Mockito.mock(Batch.class);
    private final Consumer<HttpServerExchange> closeTask = (Consumer)Mockito.mock(Consumer.class);
    private final RecordableSessionManagerStatistics statistics = (RecordableSessionManagerStatistics)Mockito.mock(RecordableSessionManagerStatistics.class);

    @Test
    public void getId() {
        String id = "id";
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        Mockito.when((Object)this.session.getId()).thenReturn((Object)id);
        String result = session.getId();
        Assert.assertSame((Object)id, (Object)result);
    }

    @Test
    public void requestDone() {
        Instant creationTime = Instant.now();
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)true);
        Mockito.when((Object)this.metaData.getCreationTime()).thenReturn((Object)creationTime);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        HttpServerExchange exchange = new HttpServerExchange(null);
        ArgumentCaptor capturedLastAccessStartTime = ArgumentCaptor.forClass(Instant.class);
        ArgumentCaptor capturedLastAccessEndTime = ArgumentCaptor.forClass(Instant.class);
        Mockito.when((Object)this.session.isValid()).thenReturn((Object)true);
        Mockito.when((Object)this.manager.getSessionManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.resumeBatch(this.batch)).thenReturn((Object)context);
        ((SessionMetaData)Mockito.doNothing().when((Object)this.metaData)).setLastAccess((Instant)capturedLastAccessStartTime.capture(), (Instant)capturedLastAccessEndTime.capture());
        session.requestDone(exchange);
        Instant lastAccessStartTime = (Instant)capturedLastAccessStartTime.getValue();
        Instant lastAccessEndTime = (Instant)capturedLastAccessEndTime.getValue();
        Assert.assertSame((Object)creationTime, (Object)lastAccessStartTime);
        Assert.assertNotSame((Object)creationTime, (Object)lastAccessEndTime);
        Assert.assertFalse((boolean)lastAccessStartTime.isAfter(lastAccessEndTime));
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session)).close();
        ((Batch)Mockito.verify((Object)this.batch)).close();
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(exchange);
        Mockito.reset((Object[])new Object[]{this.batch, this.session, this.metaData, context, this.closeTask});
        capturedLastAccessStartTime = ArgumentCaptor.forClass(Instant.class);
        capturedLastAccessEndTime = ArgumentCaptor.forClass(Instant.class);
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        Mockito.when((Object)this.session.isValid()).thenReturn((Object)true);
        Mockito.when((Object)this.manager.getSessionManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.resumeBatch(this.batch)).thenReturn((Object)context);
        ((SessionMetaData)Mockito.doNothing().when((Object)this.metaData)).setLastAccess((Instant)capturedLastAccessStartTime.capture(), (Instant)capturedLastAccessEndTime.capture());
        session.requestDone(exchange);
        lastAccessStartTime = (Instant)capturedLastAccessStartTime.getValue();
        lastAccessEndTime = (Instant)capturedLastAccessEndTime.getValue();
        Assert.assertNotSame((Object)lastAccessStartTime, (Object)lastAccessEndTime);
        Assert.assertFalse((boolean)lastAccessStartTime.isAfter(lastAccessEndTime));
        ((SessionMetaData)Mockito.verify((Object)this.metaData)).setLastAccess((Instant)ArgumentMatchers.any(Instant.class), (Instant)ArgumentMatchers.any(Instant.class));
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session)).close();
        ((Batch)Mockito.verify((Object)this.batch)).close();
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(exchange);
        Mockito.reset((Object[])new Object[]{this.batch, this.session, this.metaData, context, this.closeTask});
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)true);
        session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        Mockito.when((Object)this.session.isValid()).thenReturn((Object)false);
        Mockito.when((Object)this.batch.getState()).thenReturn((Object)Batch.State.CLOSED);
        session.requestDone(exchange);
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session)).close();
        ((Batch)Mockito.verify((Object)this.batch)).close();
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(exchange);
        Mockito.reset((Object[])new Object[]{this.batch, this.session, this.metaData, context, this.closeTask});
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)true);
        session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        Mockito.when((Object)this.session.isValid()).thenReturn((Object)false);
        Mockito.when((Object)this.batch.getState()).thenReturn((Object)Batch.State.ACTIVE);
        session.requestDone(exchange);
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session)).close();
        ((Batch)Mockito.verify((Object)this.batch)).close();
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(exchange);
    }

    @Test
    public void getCreationTime() {
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        Instant now = Instant.now();
        Mockito.when((Object)this.manager.getSessionManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.resumeBatch(this.batch)).thenReturn((Object)context);
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getCreationTime()).thenReturn((Object)now);
        long result = session.getCreationTime();
        Assert.assertEquals((long)now.toEpochMilli(), (long)result);
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        Mockito.reset((Object[])new BatchContext[]{context});
        ((org.wildfly.clustering.web.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).getMetaData();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$getCreationTime$0((Session)session));
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(null);
    }

    @Test
    public void getLastAccessedTime() {
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        Instant now = Instant.now();
        Mockito.when((Object)this.manager.getSessionManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.resumeBatch(this.batch)).thenReturn((Object)context);
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getLastAccessStartTime()).thenReturn((Object)now);
        long result = session.getLastAccessedTime();
        Assert.assertEquals((long)now.toEpochMilli(), (long)result);
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        Mockito.reset((Object[])new BatchContext[]{context});
        ((org.wildfly.clustering.web.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).getMetaData();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$getLastAccessedTime$1((Session)session));
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(null);
    }

    @Test
    public void getMaxInactiveInterval() {
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        long expected = 3600L;
        Mockito.when((Object)this.manager.getSessionManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.resumeBatch(this.batch)).thenReturn((Object)context);
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getMaxInactiveInterval()).thenReturn((Object)Duration.ofSeconds(expected));
        long result = session.getMaxInactiveInterval();
        Assert.assertEquals((long)expected, (long)result);
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        Mockito.reset((Object[])new BatchContext[]{context});
        ((org.wildfly.clustering.web.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).getMetaData();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$getMaxInactiveInterval$2((Session)session));
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(null);
    }

    @Test
    public void setMaxInactiveInterval() {
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        int interval = 3600;
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        Mockito.when((Object)this.manager.getSessionManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.resumeBatch(this.batch)).thenReturn((Object)context);
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)metaData);
        session.setMaxInactiveInterval(interval);
        ((SessionMetaData)Mockito.verify((Object)metaData)).setMaxInactiveInterval(Duration.ofSeconds(interval));
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        Mockito.reset((Object[])new BatchContext[]{context});
        ((org.wildfly.clustering.web.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).getMetaData();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$setMaxInactiveInterval$3((Session)session, interval));
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(null);
    }

    @Test
    public void getAttributeNames() {
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        Set<String> expected = Collections.singleton("name");
        Mockito.when((Object)this.session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when((Object)attributes.getAttributeNames()).thenReturn(expected);
        Mockito.when((Object)this.manager.getSessionManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.resumeBatch(this.batch)).thenReturn((Object)context);
        Set result = session.getAttributeNames();
        Assert.assertSame(expected, (Object)result);
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        Mockito.reset((Object[])new BatchContext[]{context});
        ((org.wildfly.clustering.web.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).getAttributes();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$getAttributeNames$4((Session)session));
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(null);
    }

    @Test
    public void getAttribute() {
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        String name = "name";
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        Object expected = new Object();
        Mockito.when((Object)this.session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when((Object)attributes.getAttribute(name)).thenReturn(expected);
        Mockito.when((Object)this.manager.getSessionManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.resumeBatch(this.batch)).thenReturn((Object)context);
        Object result = session.getAttribute(name);
        Assert.assertSame((Object)expected, (Object)result);
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        Mockito.reset((Object[])new BatchContext[]{context});
        ((org.wildfly.clustering.web.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).getAttributes();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$getAttribute$5((Session)session, name));
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(null);
    }

    @Test
    public void getAuthenticatedSessionAttribute() {
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        String name = CachedAuthenticatedSessionHandler.class.getName() + ".AuthenticatedSession";
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        Account account = (Account)Mockito.mock(Account.class);
        AuthenticatedSessionManager.AuthenticatedSession auth = new AuthenticatedSessionManager.AuthenticatedSession(account, "FORM");
        Mockito.when((Object)this.manager.getSessionManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.resumeBatch(this.batch)).thenReturn((Object)context);
        Mockito.when((Object)this.session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when((Object)attributes.getAttribute(name)).thenReturn((Object)auth);
        AuthenticatedSessionManager.AuthenticatedSession result = (AuthenticatedSessionManager.AuthenticatedSession)session.getAttribute(name);
        Assert.assertSame((Object)account, (Object)result.getAccount());
        Assert.assertSame((Object)"FORM", (Object)result.getMechanism());
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        Mockito.reset((Object[])new BatchContext[]{context});
        AuthenticatedSessionManager.AuthenticatedSession expected = new AuthenticatedSessionManager.AuthenticatedSession(account, "BASIC");
        Map<CallSite, AuthenticatedSessionManager.AuthenticatedSession> localContext = Collections.singletonMap(name, expected);
        Mockito.when((Object)attributes.getAttribute(name)).thenReturn(null);
        Mockito.when((Object)((Map)this.session.getLocalContext())).thenReturn(localContext);
        result = (AuthenticatedSessionManager.AuthenticatedSession)session.getAttribute(name);
        Assert.assertSame((Object)expected, (Object)result);
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        Mockito.reset((Object[])new BatchContext[]{context});
        ((org.wildfly.clustering.web.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).getAttributes();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$getAuthenticatedSessionAttribute$6((Session)session, name));
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(null);
    }

    @Test
    public void getWebSocketChannelsSessionAttribute() {
        this.getLocalContextSessionAttribute("io.undertow.websocket.current-connections");
    }

    private void getLocalContextSessionAttribute(String name) {
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        Object expected = new Object();
        Map<String, Object> localContext = Collections.singletonMap(name, expected);
        Mockito.when((Object)this.manager.getSessionManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.resumeBatch(this.batch)).thenReturn((Object)context);
        Mockito.when((Object)((Map)this.session.getLocalContext())).thenReturn(localContext);
        Object result = session.getAttribute(name);
        Assert.assertSame((Object)expected, (Object)result);
        ((SessionAttributes)Mockito.verify((Object)attributes, (VerificationMode)Mockito.never())).getAttribute(name);
        ((BatchContext)Mockito.verify((Object)context)).close();
    }

    @Test
    public void setAttribute() {
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        String name = "name";
        Integer value = 1;
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        SessionListener listener = (SessionListener)Mockito.mock(SessionListener.class);
        SessionListeners listeners = new SessionListeners();
        listeners.addSessionListener(listener);
        Object expected = new Object();
        Mockito.when((Object)this.session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when((Object)attributes.setAttribute(name, (Object)value)).thenReturn(expected);
        Mockito.when((Object)this.manager.getSessionListeners()).thenReturn((Object)listeners);
        Mockito.when((Object)this.manager.getSessionManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.resumeBatch(this.batch)).thenReturn((Object)context);
        Object result = session.setAttribute(name, (Object)value);
        Assert.assertSame((Object)expected, (Object)result);
        ((SessionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).attributeAdded((Session)session, name, (Object)value);
        ((SessionListener)Mockito.verify((Object)listener)).attributeUpdated((Session)session, name, (Object)value, expected);
        ((SessionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).attributeRemoved((Session)ArgumentMatchers.same((Object)session), (String)ArgumentMatchers.same((Object)name), ArgumentMatchers.any());
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        Mockito.reset((Object[])new BatchContext[]{context});
        ((org.wildfly.clustering.web.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).getAttributes();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$setAttribute$7((Session)session, name, value));
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(null);
    }

    @Test
    public void setNewAttribute() {
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        String name = "name";
        Integer value = 1;
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        SessionListener listener = (SessionListener)Mockito.mock(SessionListener.class);
        SessionListeners listeners = new SessionListeners();
        listeners.addSessionListener(listener);
        Object expected = null;
        Mockito.when((Object)this.session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when((Object)attributes.setAttribute(name, (Object)value)).thenReturn(expected);
        Mockito.when((Object)this.manager.getSessionListeners()).thenReturn((Object)listeners);
        Mockito.when((Object)this.manager.getSessionManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.resumeBatch(this.batch)).thenReturn((Object)context);
        Object result = session.setAttribute(name, (Object)value);
        Assert.assertSame(expected, (Object)result);
        ((SessionListener)Mockito.verify((Object)listener)).attributeAdded((Session)session, name, (Object)value);
        ((SessionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).attributeUpdated((Session)ArgumentMatchers.same((Object)session), (String)ArgumentMatchers.same((Object)name), ArgumentMatchers.same((Object)value), ArgumentMatchers.any());
        ((SessionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).attributeRemoved((Session)ArgumentMatchers.same((Object)session), (String)ArgumentMatchers.same((Object)name), ArgumentMatchers.any());
        ((BatchContext)Mockito.verify((Object)context)).close();
    }

    @Test
    public void setNullAttribute() {
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        String name = "name";
        Object value = null;
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        SessionListener listener = (SessionListener)Mockito.mock(SessionListener.class);
        SessionListeners listeners = new SessionListeners();
        listeners.addSessionListener(listener);
        Object expected = new Object();
        Mockito.when((Object)this.session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when((Object)attributes.removeAttribute(name)).thenReturn(expected);
        Mockito.when((Object)this.manager.getSessionListeners()).thenReturn((Object)listeners);
        Mockito.when((Object)this.manager.getSessionManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.resumeBatch(this.batch)).thenReturn((Object)context);
        Object result = session.setAttribute(name, value);
        Assert.assertSame((Object)expected, (Object)result);
        ((SessionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).attributeAdded((Session)session, name, value);
        ((SessionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).attributeUpdated((Session)ArgumentMatchers.same((Object)session), (String)ArgumentMatchers.same((Object)name), ArgumentMatchers.same(value), ArgumentMatchers.any());
        ((SessionListener)Mockito.verify((Object)listener)).attributeRemoved((Session)session, name, expected);
        ((BatchContext)Mockito.verify((Object)context)).close();
    }

    @Test
    public void setSameAttribute() {
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        String name = "name";
        Integer value = 1;
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        SessionListener listener = (SessionListener)Mockito.mock(SessionListener.class);
        SessionListeners listeners = new SessionListeners();
        listeners.addSessionListener(listener);
        Integer expected = value;
        Mockito.when((Object)this.manager.getSessionManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.resumeBatch(this.batch)).thenReturn((Object)context);
        Mockito.when((Object)this.session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when((Object)attributes.setAttribute(name, (Object)value)).thenReturn((Object)expected);
        Mockito.when((Object)this.manager.getSessionListeners()).thenReturn((Object)listeners);
        Object result = session.setAttribute(name, (Object)value);
        Assert.assertSame((Object)expected, (Object)result);
        ((SessionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).attributeAdded((Session)session, name, (Object)value);
        ((SessionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).attributeUpdated((Session)ArgumentMatchers.same((Object)session), (String)ArgumentMatchers.same((Object)name), ArgumentMatchers.same((Object)value), ArgumentMatchers.any());
        ((SessionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).attributeRemoved((Session)ArgumentMatchers.same((Object)session), (String)ArgumentMatchers.same((Object)name), ArgumentMatchers.any());
        ((BatchContext)Mockito.verify((Object)context)).close();
    }

    @Test
    public void setAuthenticatedSessionAttribute() {
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        String name = CachedAuthenticatedSessionHandler.class.getName() + ".AuthenticatedSession";
        Account account = (Account)Mockito.mock(Account.class);
        AuthenticatedSessionManager.AuthenticatedSession auth = new AuthenticatedSessionManager.AuthenticatedSession(account, "FORM");
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        Account oldAccount = (Account)Mockito.mock(Account.class);
        AuthenticatedSessionManager.AuthenticatedSession oldAuth = new AuthenticatedSessionManager.AuthenticatedSession(oldAccount, "FORM");
        ArgumentCaptor capturedAuth = ArgumentCaptor.forClass(AuthenticatedSessionManager.AuthenticatedSession.class);
        Mockito.when((Object)this.manager.getSessionManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.resumeBatch(this.batch)).thenReturn((Object)context);
        Mockito.when((Object)this.session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when((Object)attributes.setAttribute((String)ArgumentMatchers.same((Object)name), capturedAuth.capture())).thenReturn((Object)oldAuth);
        AuthenticatedSessionManager.AuthenticatedSession result = (AuthenticatedSessionManager.AuthenticatedSession)session.setAttribute(name, (Object)auth);
        Assert.assertSame((Object)auth.getAccount(), (Object)((AuthenticatedSessionManager.AuthenticatedSession)capturedAuth.getValue()).getAccount());
        Assert.assertSame((Object)auth.getMechanism(), (Object)((AuthenticatedSessionManager.AuthenticatedSession)capturedAuth.getValue()).getMechanism());
        Assert.assertSame((Object)oldAccount, (Object)result.getAccount());
        Assert.assertSame((Object)"FORM", (Object)result.getMechanism());
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        Mockito.reset((Object[])new Object[]{context, attributes});
        capturedAuth = ArgumentCaptor.forClass(AuthenticatedSessionManager.AuthenticatedSession.class);
        Mockito.when((Object)attributes.setAttribute((String)ArgumentMatchers.same((Object)name), capturedAuth.capture())).thenReturn(null);
        result = (AuthenticatedSessionManager.AuthenticatedSession)session.setAttribute(name, (Object)auth);
        Assert.assertSame((Object)auth.getAccount(), (Object)((AuthenticatedSessionManager.AuthenticatedSession)capturedAuth.getValue()).getAccount());
        Assert.assertSame((Object)auth.getMechanism(), (Object)((AuthenticatedSessionManager.AuthenticatedSession)capturedAuth.getValue()).getMechanism());
        Assert.assertNull((Object)result);
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        Mockito.reset((Object[])new Object[]{context, attributes});
        auth = new AuthenticatedSessionManager.AuthenticatedSession(account, "BASIC");
        AuthenticatedSessionManager.AuthenticatedSession oldSession = new AuthenticatedSessionManager.AuthenticatedSession(oldAccount, "BASIC");
        HashMap<CallSite, AuthenticatedSessionManager.AuthenticatedSession> localContext = new HashMap<CallSite, AuthenticatedSessionManager.AuthenticatedSession>();
        localContext.put((CallSite)((Object)name), oldSession);
        Mockito.when((Object)((Map)this.session.getLocalContext())).thenReturn(localContext);
        result = (AuthenticatedSessionManager.AuthenticatedSession)session.setAttribute(name, (Object)auth);
        Assert.assertSame((Object)auth, localContext.get(name));
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        Mockito.reset((Object[])new BatchContext[]{context});
        ((org.wildfly.clustering.web.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).getAttributes();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$setAuthenticatedSessionAttribute$8((Session)session, name, oldAuth));
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(null);
    }

    @Test
    public void setWebSocketChannelsSessionAttribute() {
        this.setLocalContextSessionAttribute("io.undertow.websocket.current-connections");
    }

    private void setLocalContextSessionAttribute(String name) {
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        Object newValue = new Object();
        Object oldValue = new Object();
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        HashMap<String, Object> localContext = new HashMap<String, Object>();
        localContext.put(name, oldValue);
        Mockito.when((Object)this.manager.getSessionManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.resumeBatch(this.batch)).thenReturn((Object)context);
        Mockito.when((Object)((Map)this.session.getLocalContext())).thenReturn(localContext);
        Object result = session.setAttribute(name, newValue);
        Assert.assertSame((Object)oldValue, (Object)result);
        Assert.assertSame((Object)newValue, localContext.get(name));
        ((SessionAttributes)Mockito.verify((Object)attributes, (VerificationMode)Mockito.never())).setAttribute(name, newValue);
        ((BatchContext)Mockito.verify((Object)context)).close();
    }

    @Test
    public void removeAttribute() {
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        String name = "name";
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        SessionListener listener = (SessionListener)Mockito.mock(SessionListener.class);
        SessionListeners listeners = new SessionListeners();
        listeners.addSessionListener(listener);
        Object expected = new Object();
        Mockito.when((Object)this.session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when((Object)attributes.removeAttribute(name)).thenReturn(expected);
        Mockito.when((Object)this.manager.getSessionListeners()).thenReturn((Object)listeners);
        Mockito.when((Object)this.manager.getSessionManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.resumeBatch(this.batch)).thenReturn((Object)context);
        Object result = session.removeAttribute(name);
        Assert.assertSame((Object)expected, (Object)result);
        ((SessionListener)Mockito.verify((Object)listener)).attributeRemoved((Session)session, name, expected);
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        Mockito.reset((Object[])new BatchContext[]{context});
        ((org.wildfly.clustering.web.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).getAttributes();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$removeAttribute$9((Session)session, name));
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(null);
    }

    @Test
    public void removeNonExistingAttribute() {
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        String name = "name";
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        SessionListener listener = (SessionListener)Mockito.mock(SessionListener.class);
        SessionListeners listeners = new SessionListeners();
        listeners.addSessionListener(listener);
        Mockito.when((Object)this.session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when((Object)attributes.removeAttribute(name)).thenReturn(null);
        Mockito.when((Object)this.manager.getSessionListeners()).thenReturn((Object)listeners);
        Mockito.when((Object)this.manager.getSessionManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.resumeBatch(this.batch)).thenReturn((Object)context);
        Object result = session.removeAttribute(name);
        Assert.assertNull((Object)result);
        ((SessionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).attributeRemoved((Session)ArgumentMatchers.same((Object)session), (String)ArgumentMatchers.same((Object)name), ArgumentMatchers.any());
        ((BatchContext)Mockito.verify((Object)context)).close();
    }

    @Test
    public void removeAuthenticatedSessionAttribute() {
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        String name = CachedAuthenticatedSessionHandler.class.getName() + ".AuthenticatedSession";
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        Account oldAccount = (Account)Mockito.mock(Account.class);
        AuthenticatedSessionManager.AuthenticatedSession oldAuth = new AuthenticatedSessionManager.AuthenticatedSession(oldAccount, "FORM");
        Mockito.when((Object)this.manager.getSessionManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.resumeBatch(this.batch)).thenReturn((Object)context);
        Mockito.when((Object)this.session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when((Object)attributes.removeAttribute((String)ArgumentMatchers.same((Object)name))).thenReturn((Object)oldAuth);
        AuthenticatedSessionManager.AuthenticatedSession result = (AuthenticatedSessionManager.AuthenticatedSession)session.removeAttribute(name);
        Assert.assertSame((Object)oldAccount, (Object)result.getAccount());
        Assert.assertSame((Object)"FORM", (Object)result.getMechanism());
        ((BatchContext)Mockito.verify((Object)context)).close();
        Mockito.reset((Object[])new Object[]{context, attributes});
        HashMap<CallSite, AuthenticatedSessionManager.AuthenticatedSession> localContext = new HashMap<CallSite, AuthenticatedSessionManager.AuthenticatedSession>();
        AuthenticatedSessionManager.AuthenticatedSession oldSession = new AuthenticatedSessionManager.AuthenticatedSession(oldAccount, "BASIC");
        localContext.put((CallSite)((Object)name), oldSession);
        Mockito.when((Object)attributes.removeAttribute((String)ArgumentMatchers.same((Object)name))).thenReturn(null);
        Mockito.when((Object)((Map)this.session.getLocalContext())).thenReturn(localContext);
        result = (AuthenticatedSessionManager.AuthenticatedSession)session.removeAttribute(name);
        Assert.assertSame((Object)result, (Object)oldSession);
        Assert.assertNull(localContext.get(name));
        ((BatchContext)Mockito.verify((Object)context)).close();
        Mockito.reset((Object[])new Object[]{context, attributes});
        result = (AuthenticatedSessionManager.AuthenticatedSession)session.removeAttribute(name);
        Assert.assertNull((Object)result);
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session, (VerificationMode)Mockito.never())).close();
        ((Consumer)Mockito.verify(this.closeTask, (VerificationMode)Mockito.never())).accept(null);
        Mockito.reset((Object[])new BatchContext[]{context});
        ((org.wildfly.clustering.web.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).getAttributes();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$removeAuthenticatedSessionAttribute$10((Session)session, name));
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(null);
    }

    @Test
    public void removeWebSocketChannelsSessionAttribute() {
        this.removeLocalContextSessionAttribute("io.undertow.websocket.current-connections");
    }

    private void removeLocalContextSessionAttribute(String name) {
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        Object oldValue = new Object();
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        HashMap<String, Object> localContext = new HashMap<String, Object>();
        localContext.put(name, oldValue);
        Mockito.when((Object)this.manager.getSessionManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.resumeBatch(this.batch)).thenReturn((Object)context);
        Mockito.when((Object)((Map)this.session.getLocalContext())).thenReturn(localContext);
        Object result = session.removeAttribute(name);
        Assert.assertSame((Object)oldValue, (Object)result);
        Assert.assertNull(localContext.get(name));
        ((SessionAttributes)Mockito.verify((Object)attributes, (VerificationMode)Mockito.never())).removeAttribute(name);
        ((BatchContext)Mockito.verify((Object)context)).close();
    }

    @Test
    public void invalidate() {
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        HttpServerExchange exchange = new HttpServerExchange(null);
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionListener listener = (SessionListener)Mockito.mock(SessionListener.class);
        SessionAttributes attributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        SessionListeners listeners = new SessionListeners();
        listeners.addSessionListener(listener);
        String sessionId = "session";
        String attributeName = "attribute";
        Object attributeValue = Mockito.mock(HttpSessionActivationListener.class);
        Recordable recorder = (Recordable)Mockito.mock(Recordable.class);
        Mockito.when((Object)this.manager.getSessionListeners()).thenReturn((Object)listeners);
        Mockito.when((Object)this.session.isValid()).thenReturn((Object)true);
        Mockito.when((Object)this.session.getId()).thenReturn((Object)sessionId);
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.manager.getSessionManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.resumeBatch(this.batch)).thenReturn((Object)context);
        Mockito.when((Object)this.batch.getState()).thenReturn((Object)Batch.State.ACTIVE);
        Mockito.when((Object)this.session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when((Object)attributes.getAttributeNames()).thenReturn(Collections.singleton("attribute"));
        Mockito.when((Object)attributes.getAttribute(attributeName)).thenReturn(attributeValue);
        Mockito.when((Object)this.statistics.getInactiveSessionRecorder()).thenReturn((Object)recorder);
        session.invalidate(exchange);
        ((Recordable)Mockito.verify((Object)recorder)).record((Object)this.metaData);
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session)).invalidate();
        ((SessionConfig)Mockito.verify((Object)this.config)).clearSession(exchange, sessionId);
        ((SessionListener)Mockito.verify((Object)listener)).sessionDestroyed((Session)session, exchange, SessionListener.SessionDestroyedReason.INVALIDATED);
        ((SessionListener)Mockito.verify((Object)listener)).attributeRemoved((Session)session, attributeName, attributeValue);
        ((Batch)Mockito.verify((Object)this.batch)).close();
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(exchange);
        Mockito.reset((Object[])new Object[]{context, this.session, this.closeTask});
        ((org.wildfly.clustering.web.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).invalidate();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$invalidate$11((Session)session, exchange));
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(exchange);
    }

    @Test
    public void getSessionManager() {
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        Assert.assertSame((Object)this.manager, (Object)session.getSessionManager());
    }

    @Test
    public void changeSessionId() {
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        HttpServerExchange exchange = new HttpServerExchange(null);
        SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Supplier identifierFactory = (Supplier)Mockito.mock(Supplier.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        org.wildfly.clustering.web.session.Session newSession = (org.wildfly.clustering.web.session.Session)Mockito.mock(org.wildfly.clustering.web.session.Session.class);
        SessionAttributes oldAttributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        SessionAttributes newAttributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        SessionMetaData oldMetaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionMetaData newMetaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        HashMap<String, String> oldContext = new HashMap<String, String>();
        oldContext.put("foo", "bar");
        HashMap newContext = new HashMap();
        SessionListener listener = (SessionListener)Mockito.mock(SessionListener.class);
        SessionListeners listeners = new SessionListeners();
        listeners.addSessionListener(listener);
        String oldSessionId = "old";
        String newSessionId = "new";
        String name = "name";
        Object value = new Object();
        Instant now = Instant.now();
        Duration interval = Duration.ofSeconds(10L);
        Mockito.when((Object)this.manager.getSessionManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.resumeBatch(this.batch)).thenReturn((Object)context);
        Mockito.when((Object)manager.getIdentifierFactory()).thenReturn((Object)identifierFactory);
        Mockito.when((Object)((String)identifierFactory.get())).thenReturn((Object)newSessionId);
        Mockito.when((Object)manager.createSession(newSessionId)).thenReturn((Object)newSession);
        Mockito.when((Object)this.session.getAttributes()).thenReturn((Object)oldAttributes);
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)oldMetaData);
        Mockito.when((Object)newSession.getAttributes()).thenReturn((Object)newAttributes);
        Mockito.when((Object)newSession.getMetaData()).thenReturn((Object)newMetaData);
        Mockito.when((Object)oldAttributes.getAttributeNames()).thenReturn(Collections.singleton(name));
        Mockito.when((Object)oldAttributes.getAttribute(name)).thenReturn(value);
        Mockito.when((Object)newAttributes.setAttribute(name, value)).thenReturn(null);
        Mockito.when((Object)oldMetaData.getLastAccessStartTime()).thenReturn((Object)now);
        Mockito.when((Object)oldMetaData.getLastAccessEndTime()).thenReturn((Object)now);
        Mockito.when((Object)oldMetaData.getMaxInactiveInterval()).thenReturn((Object)interval);
        Mockito.when((Object)this.session.getId()).thenReturn((Object)oldSessionId);
        Mockito.when((Object)newSession.getId()).thenReturn((Object)newSessionId);
        Mockito.when((Object)((Map)this.session.getLocalContext())).thenReturn(oldContext);
        Mockito.when((Object)((Map)newSession.getLocalContext())).thenReturn(newContext);
        Mockito.when((Object)this.manager.getSessionListeners()).thenReturn((Object)listeners);
        String result = session.changeSessionId(exchange, config);
        Assert.assertSame((Object)newSessionId, (Object)result);
        ((SessionMetaData)Mockito.verify((Object)newMetaData)).setLastAccess(now, now);
        ((SessionMetaData)Mockito.verify((Object)newMetaData)).setMaxInactiveInterval(interval);
        ((SessionConfig)Mockito.verify((Object)config)).setSessionId(exchange, newSessionId);
        Assert.assertEquals(oldContext, newContext);
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session)).invalidate();
        ((org.wildfly.clustering.web.session.Session)Mockito.verify((Object)newSession, (VerificationMode)Mockito.never())).invalidate();
        ((SessionListener)Mockito.verify((Object)listener)).sessionIdChanged((Session)session, oldSessionId);
        ((BatchContext)Mockito.verify((Object)context)).close();
    }

    public void changeSessionIdResponseCommitted() {
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        Mockito.when((Object)this.session.isValid()).thenReturn((Object)true);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        Configurable configurable = (Configurable)Mockito.mock(Configurable.class);
        StreamSourceConduit sourceConduit = (StreamSourceConduit)Mockito.mock(StreamSourceConduit.class);
        ConduitStreamSourceChannel sourceChannel = new ConduitStreamSourceChannel(configurable, sourceConduit);
        StreamSinkConduit sinkConduit = (StreamSinkConduit)Mockito.mock(StreamSinkConduit.class);
        ConduitStreamSinkChannel sinkChannel = new ConduitStreamSinkChannel(configurable, sinkConduit);
        StreamConnection stream = (StreamConnection)Mockito.mock(StreamConnection.class);
        Mockito.when((Object)stream.getSourceChannel()).thenReturn((Object)sourceChannel);
        Mockito.when((Object)stream.getSinkChannel()).thenReturn((Object)sinkChannel);
        ByteBufferPool bufferPool = (ByteBufferPool)Mockito.mock(ByteBufferPool.class);
        HttpHandler handler = (HttpHandler)Mockito.mock(HttpHandler.class);
        HttpServerConnection connection = new HttpServerConnection(stream, bufferPool, handler, OptionMap.create((Option)UndertowOptions.ALWAYS_SET_DATE, (Object)false), 0, null);
        HttpServerExchange exchange = new HttpServerExchange((ServerConnection)connection);
        exchange.setProtocol(Protocols.HTTP_1_1);
        exchange.getResponseChannel();
        SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$changeSessionIdResponseCommitted$12((Session)session, exchange, config));
    }

    @Test
    public void changeSessionIdConcurrentInvalidate() {
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)this.metaData);
        Mockito.when((Object)this.metaData.isNew()).thenReturn((Object)false);
        DistributableSession session = new DistributableSession(this.manager, this.session, this.config, this.batch, this.closeTask, this.statistics);
        HttpServerExchange exchange = new HttpServerExchange(null);
        SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
        SessionManager manager = (SessionManager)Mockito.mock(SessionManager.class);
        Supplier identifierFactory = (Supplier)Mockito.mock(Supplier.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        org.wildfly.clustering.web.session.Session newSession = (org.wildfly.clustering.web.session.Session)Mockito.mock(org.wildfly.clustering.web.session.Session.class);
        SessionAttributes oldAttributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        SessionAttributes newAttributes = (SessionAttributes)Mockito.mock(SessionAttributes.class);
        SessionMetaData oldMetaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        SessionMetaData newMetaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        HashMap<String, String> oldContext = new HashMap<String, String>();
        oldContext.put("foo", "bar");
        HashMap newContext = new HashMap();
        SessionListener listener = (SessionListener)Mockito.mock(SessionListener.class);
        SessionListeners listeners = new SessionListeners();
        listeners.addSessionListener(listener);
        String oldSessionId = "old";
        String newSessionId = "new";
        String name = "name";
        Object value = new Object();
        Instant now = Instant.now();
        Duration interval = Duration.ofSeconds(10L);
        Mockito.when((Object)this.manager.getSessionManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.resumeBatch(this.batch)).thenReturn((Object)context);
        Mockito.when((Object)manager.getIdentifierFactory()).thenReturn((Object)identifierFactory);
        Mockito.when((Object)((String)identifierFactory.get())).thenReturn((Object)newSessionId);
        Mockito.when((Object)manager.createSession(newSessionId)).thenReturn((Object)newSession);
        Mockito.when((Object)this.session.getAttributes()).thenReturn((Object)oldAttributes);
        Mockito.when((Object)this.session.getMetaData()).thenReturn((Object)oldMetaData);
        Mockito.when((Object)newSession.getAttributes()).thenReturn((Object)newAttributes);
        Mockito.when((Object)newSession.getMetaData()).thenReturn((Object)newMetaData);
        Mockito.when((Object)oldAttributes.getAttributeNames()).thenReturn(Collections.singleton(name));
        Mockito.when((Object)oldAttributes.getAttribute(name)).thenReturn(value);
        Mockito.when((Object)newAttributes.setAttribute(name, value)).thenReturn(null);
        Mockito.when((Object)oldMetaData.getLastAccessStartTime()).thenReturn((Object)now);
        Mockito.when((Object)oldMetaData.getLastAccessEndTime()).thenReturn((Object)now);
        Mockito.when((Object)oldMetaData.getMaxInactiveInterval()).thenReturn((Object)interval);
        Mockito.when((Object)this.session.getId()).thenReturn((Object)oldSessionId);
        Mockito.when((Object)newSession.getId()).thenReturn((Object)newSessionId);
        Mockito.when((Object)((Map)this.session.getLocalContext())).thenReturn(oldContext);
        Mockito.when((Object)((Map)newSession.getLocalContext())).thenReturn(newContext);
        ((org.wildfly.clustering.web.session.Session)Mockito.doThrow(IllegalStateException.class).when(this.session)).invalidate();
        Assert.assertThrows(IllegalStateException.class, () -> DistributableSessionTestCase.lambda$changeSessionIdConcurrentInvalidate$13((Session)session, exchange, config));
        ((BatchContext)Mockito.verify((Object)context)).close();
        ((SessionListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).sessionIdChanged((Session)session, oldSessionId);
        ((org.wildfly.clustering.web.session.Session)Mockito.verify(this.session)).close();
        ((Consumer)Mockito.verify(this.closeTask)).accept(exchange);
        ((org.wildfly.clustering.web.session.Session)Mockito.verify((Object)newSession)).invalidate();
    }

    private static /* synthetic */ void lambda$changeSessionIdConcurrentInvalidate$13(Session session, HttpServerExchange exchange, SessionConfig config) throws Throwable {
        session.changeSessionId(exchange, config);
    }

    private static /* synthetic */ void lambda$changeSessionIdResponseCommitted$12(Session session, HttpServerExchange exchange, SessionConfig config) throws Throwable {
        session.changeSessionId(exchange, config);
    }

    private static /* synthetic */ void lambda$invalidate$11(Session session, HttpServerExchange exchange) throws Throwable {
        session.invalidate(exchange);
    }

    private static /* synthetic */ void lambda$removeAuthenticatedSessionAttribute$10(Session session, String name) throws Throwable {
        session.removeAttribute(name);
    }

    private static /* synthetic */ void lambda$removeAttribute$9(Session session, String name) throws Throwable {
        session.removeAttribute(name);
    }

    private static /* synthetic */ void lambda$setAuthenticatedSessionAttribute$8(Session session, String name, AuthenticatedSessionManager.AuthenticatedSession oldAuth) throws Throwable {
        session.setAttribute(name, (Object)oldAuth);
    }

    private static /* synthetic */ void lambda$setAttribute$7(Session session, String name, Integer value) throws Throwable {
        session.setAttribute(name, (Object)value);
    }

    private static /* synthetic */ void lambda$getAuthenticatedSessionAttribute$6(Session session, String name) throws Throwable {
        session.getAttribute(name);
    }

    private static /* synthetic */ void lambda$getAttribute$5(Session session, String name) throws Throwable {
        session.getAttribute(name);
    }

    private static /* synthetic */ void lambda$getAttributeNames$4(Session session) throws Throwable {
        session.getAttributeNames();
    }

    private static /* synthetic */ void lambda$setMaxInactiveInterval$3(Session session, int interval) throws Throwable {
        session.setMaxInactiveInterval(interval);
    }

    private static /* synthetic */ void lambda$getMaxInactiveInterval$2(Session session) throws Throwable {
        session.getMaxInactiveInterval();
    }

    private static /* synthetic */ void lambda$getLastAccessedTime$1(Session session) throws Throwable {
        session.getLastAccessedTime();
    }

    private static /* synthetic */ void lambda$getCreationTime$0(Session session) throws Throwable {
        session.getCreationTime();
    }
}

