/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.elytron;

import java.io.IOException;
import java.security.Principal;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.jboss.JBossMarshallingTesterFactory;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.cache.CachedIdentity;

public class CachedIdentityMarshallingTestCase {
    @Test
    public void testProtoStream() throws IOException {
        CachedIdentityMarshallingTestCase.test((Tester<CachedIdentity>)ProtoStreamTesterFactory.INSTANCE.createTester());
    }

    @Test
    public void testJBoss() throws IOException {
        CachedIdentityMarshallingTestCase.test((Tester<CachedIdentity>)JBossMarshallingTesterFactory.INSTANCE.createTester());
    }

    private static void test(Tester<CachedIdentity> tester) throws IOException {
        NamePrincipal principal = new NamePrincipal("name");
        tester.test((Object)new CachedIdentity("BASIC", false, (Principal)principal), CachedIdentityMarshallingTestCase::assertEquals);
        tester.test((Object)new CachedIdentity("CLIENT_CERT", false, (Principal)principal), CachedIdentityMarshallingTestCase::assertEquals);
        tester.test((Object)new CachedIdentity("DIGEST", false, (Principal)principal), CachedIdentityMarshallingTestCase::assertEquals);
        tester.test((Object)new CachedIdentity("FORM", false, (Principal)principal), CachedIdentityMarshallingTestCase::assertEquals);
        tester.test((Object)new CachedIdentity("Programmatic", true, (Principal)principal), CachedIdentityMarshallingTestCase::assertEquals);
    }

    static void assertEquals(CachedIdentity auth1, CachedIdentity auth2) {
        Assert.assertEquals((Object)auth1.getMechanismName(), (Object)auth2.getMechanismName());
        Assert.assertEquals((Object)auth1.getName(), (Object)auth2.getName());
        Assert.assertEquals((Object)auth1.isProgrammatic(), (Object)auth2.isProgrammatic());
    }
}

