/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.elytron;

import java.security.Principal;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.TesterFactory;
import org.wildfly.clustering.marshalling.junit.TesterFactorySource;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.cache.CachedIdentity;

public class CachedIdentityMarshallingTestCase {
    @ParameterizedTest
    @TesterFactorySource(value={MarshallingTesterFactory.class})
    public void test(TesterFactory factory) {
        Tester tester = factory.createTester(CachedIdentityMarshallingTestCase::assertEquals);
        NamePrincipal principal = new NamePrincipal("name");
        tester.accept((Object)new CachedIdentity("BASIC", false, (Principal)principal));
        tester.accept((Object)new CachedIdentity("CLIENT_CERT", false, (Principal)principal));
        tester.accept((Object)new CachedIdentity("DIGEST", false, (Principal)principal));
        tester.accept((Object)new CachedIdentity("FORM", false, (Principal)principal));
        tester.accept((Object)new CachedIdentity("Programmatic", true, (Principal)principal));
    }

    static void assertEquals(CachedIdentity auth1, CachedIdentity auth2) {
        Assertions.assertEquals((Object)auth1.getMechanismName(), (Object)auth2.getMechanismName());
        Assertions.assertEquals((Object)auth1.getName(), (Object)auth2.getName());
        Assertions.assertEquals((Object)auth1.isProgrammatic(), (Object)auth2.isProgrammatic());
    }
}

