/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.server.protocol.http.HttpServerConnection;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionListeners;
import io.undertow.util.Protocols;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.BatchContext;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionMetaData;
import org.wildfly.clustering.session.SessionStatistics;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManager;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManagerConfiguration;
import org.wildfly.clustering.web.undertow.session.RecordableSessionManagerStatistics;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;
import org.xnio.channels.Configurable;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

public class DistributableSessionManagerTestCase {
    private final String deploymentName = "mydeployment.war";
    private final SessionManager<Map<String, Object>> manager = (SessionManager)Mockito.mock(SessionManager.class);
    private final SessionListener listener = (SessionListener)Mockito.mock(SessionListener.class);
    private final SessionListeners listeners = new SessionListeners();
    private final SessionStatistics stats = (SessionStatistics)Mockito.mock(SessionStatistics.class);
    private final RecordableSessionManagerStatistics statistics = (RecordableSessionManagerStatistics)Mockito.mock(RecordableSessionManagerStatistics.class);
    private final Supplier<String> identifierFactory = (Supplier)Mockito.mock(Supplier.class);
    private final Supplier<Batch> batchFactory = (Supplier)Mockito.mock(Supplier.class);
    private DistributableSessionManager adapter;

    @Before
    public void init() {
        Mockito.when((Object)this.manager.getStatistics()).thenReturn((Object)this.stats);
        Mockito.when((Object)this.manager.getBatchFactory()).thenReturn(this.batchFactory);
        Mockito.when((Object)this.manager.getIdentifierFactory()).thenReturn(this.identifierFactory);
        DistributableSessionManagerConfiguration config = (DistributableSessionManagerConfiguration)Mockito.mock(DistributableSessionManagerConfiguration.class);
        Mockito.when((Object)config.getDeploymentName()).thenReturn((Object)this.deploymentName);
        Mockito.when((Object)config.getSessionListeners()).thenReturn((Object)this.listeners);
        Mockito.when((Object)config.getSessionManager()).thenReturn(this.manager);
        Mockito.when((Object)config.getStatistics()).thenReturn((Object)this.statistics);
        this.adapter = new DistributableSessionManager(config);
        this.adapter.registerSessionListener(this.listener);
    }

    @Test
    public void getDeploymentName() {
        Assert.assertSame((Object)this.deploymentName, (Object)this.adapter.getDeploymentName());
    }

    @Test
    public void start() {
        this.adapter.start();
        ((SessionManager)Mockito.verify(this.manager)).start();
        ((RecordableSessionManagerStatistics)Mockito.verify((Object)this.statistics)).reset();
    }

    @Test
    public void stop() {
        this.adapter.stop();
        ((SessionManager)Mockito.verify(this.manager)).stop();
    }

    @Test
    public void createSessionResponseCommitted() {
        Configurable configurable = (Configurable)Mockito.mock(Configurable.class);
        StreamSourceConduit sourceConduit = (StreamSourceConduit)Mockito.mock(StreamSourceConduit.class);
        ConduitStreamSourceChannel sourceChannel = new ConduitStreamSourceChannel(configurable, sourceConduit);
        StreamSinkConduit sinkConduit = (StreamSinkConduit)Mockito.mock(StreamSinkConduit.class);
        ConduitStreamSinkChannel sinkChannel = new ConduitStreamSinkChannel(configurable, sinkConduit);
        StreamConnection stream = (StreamConnection)Mockito.mock(StreamConnection.class);
        String id = "foo";
        int expectedTimeout = 10;
        this.adapter.setDefaultSessionTimeout(expectedTimeout);
        Mockito.when((Object)((String)this.identifierFactory.get())).thenReturn((Object)id);
        Mockito.when((Object)stream.getSourceChannel()).thenReturn((Object)sourceChannel);
        Mockito.when((Object)stream.getSinkChannel()).thenReturn((Object)sinkChannel);
        ByteBufferPool bufferPool = (ByteBufferPool)Mockito.mock(ByteBufferPool.class);
        HttpHandler handler = (HttpHandler)Mockito.mock(HttpHandler.class);
        HttpServerConnection connection = new HttpServerConnection(stream, bufferPool, handler, OptionMap.create((Option)UndertowOptions.ALWAYS_SET_DATE, (Object)false), 0, null);
        HttpServerExchange exchange = new HttpServerExchange((ServerConnection)connection);
        exchange.setProtocol(Protocols.HTTP_1_1);
        exchange.getResponseChannel();
        SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
        io.undertow.server.session.Session session = this.adapter.createSession(exchange, config);
        ((SessionManager)Mockito.verify(this.manager, (VerificationMode)Mockito.never())).createSession(id);
        Assert.assertEquals((Object)id, (Object)session.getId());
        Assert.assertEquals((long)expectedTimeout, (long)session.getMaxInactiveInterval());
    }

    @Test
    public void createSessionNoSessionId() {
        HttpServerExchange exchange = new HttpServerExchange(null);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        SuspendedBatch suspendedBatch = (SuspendedBatch)Mockito.mock(SuspendedBatch.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
        Session session = (Session)Mockito.mock(Session.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        String sessionId = "session";
        Mockito.when((Object)((Batch)this.batchFactory.get())).thenReturn((Object)batch);
        Mockito.when((Object)batch.suspend()).thenReturn((Object)suspendedBatch);
        Mockito.when((Object)suspendedBatch.resume()).thenReturn((Object)batch);
        Mockito.when((Object)suspendedBatch.resumeWithContext()).thenReturn((Object)context);
        Mockito.when((Object)((Batch)context.get())).thenReturn((Object)batch);
        Mockito.when((Object)((String)this.identifierFactory.get())).thenReturn((Object)sessionId);
        Mockito.when((Object)this.manager.createSession(sessionId)).thenReturn((Object)session);
        Mockito.when((Object)session.getId()).thenReturn((Object)sessionId);
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.isNew()).thenReturn((Object)true);
        io.undertow.server.session.Session sessionAdapter = this.adapter.createSession(exchange, config);
        Assert.assertNotNull((Object)sessionAdapter);
        ((SessionListener)Mockito.verify((Object)this.listener)).sessionCreated(sessionAdapter, exchange);
        ((SessionConfig)Mockito.verify((Object)config)).setSessionId(exchange, sessionId);
        ((Batch)Mockito.verify((Object)batch)).suspend();
        ((RecordableSessionManagerStatistics)Mockito.verify((Object)this.statistics)).record((Object)metaData);
        String expected = "expected";
        Mockito.when((Object)session.getId()).thenReturn((Object)expected);
        String result = sessionAdapter.getId();
        Assert.assertSame((Object)expected, (Object)result);
    }

    @Test
    public void createSessionSpecifiedSessionId() {
        HttpServerExchange exchange = new HttpServerExchange(null);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        SuspendedBatch suspendedBatch = (SuspendedBatch)Mockito.mock(SuspendedBatch.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
        Session session = (Session)Mockito.mock(Session.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        String sessionId = "session";
        Mockito.when((Object)((Batch)this.batchFactory.get())).thenReturn((Object)batch);
        Mockito.when((Object)batch.suspend()).thenReturn((Object)suspendedBatch);
        Mockito.when((Object)suspendedBatch.resume()).thenReturn((Object)batch);
        Mockito.when((Object)suspendedBatch.resumeWithContext()).thenReturn((Object)context);
        Mockito.when((Object)((Batch)context.get())).thenReturn((Object)batch);
        Mockito.when((Object)config.findSessionId(exchange)).thenReturn((Object)sessionId);
        Mockito.when((Object)this.manager.createSession(sessionId)).thenReturn((Object)session);
        Mockito.when((Object)session.getId()).thenReturn((Object)sessionId);
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.isNew()).thenReturn((Object)true);
        io.undertow.server.session.Session sessionAdapter = this.adapter.createSession(exchange, config);
        Assert.assertNotNull((Object)sessionAdapter);
        ((SessionListener)Mockito.verify((Object)this.listener)).sessionCreated(sessionAdapter, exchange);
        ((Batch)Mockito.verify((Object)batch)).suspend();
        ((RecordableSessionManagerStatistics)Mockito.verify((Object)this.statistics)).record((Object)metaData);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.identifierFactory});
        String expected = "expected";
        Mockito.when((Object)session.getId()).thenReturn((Object)expected);
        String result = sessionAdapter.getId();
        Assert.assertSame((Object)expected, (Object)result);
    }

    @Test
    public void createSessionAlreadyExists() {
        HttpServerExchange exchange = new HttpServerExchange(null);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        SuspendedBatch suspendedBatch = (SuspendedBatch)Mockito.mock(SuspendedBatch.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
        String sessionId = "session";
        Mockito.when((Object)((Batch)this.batchFactory.get())).thenReturn((Object)batch);
        Mockito.when((Object)batch.suspend()).thenReturn((Object)suspendedBatch);
        Mockito.when((Object)suspendedBatch.resume()).thenReturn((Object)batch);
        Mockito.when((Object)suspendedBatch.resumeWithContext()).thenReturn((Object)context);
        Mockito.when((Object)((Batch)context.get())).thenReturn((Object)batch);
        Mockito.when((Object)config.findSessionId(exchange)).thenReturn((Object)sessionId);
        Mockito.when((Object)this.manager.createSession(sessionId)).thenReturn(null);
        IllegalStateException exception = null;
        try {
            this.adapter.createSession(exchange, config);
        }
        catch (IllegalStateException e) {
            exception = e;
        }
        Assert.assertNotNull((Object)exception);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.identifierFactory});
        ((Batch)Mockito.verify((Object)batch)).discard();
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getSession() {
        HttpServerExchange exchange = new HttpServerExchange(null);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        SuspendedBatch suspendedBatch = (SuspendedBatch)Mockito.mock(SuspendedBatch.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
        Session session = (Session)Mockito.mock(Session.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        String sessionId = "session";
        Mockito.when((Object)((Batch)this.batchFactory.get())).thenReturn((Object)batch);
        Mockito.when((Object)batch.suspend()).thenReturn((Object)suspendedBatch);
        Mockito.when((Object)suspendedBatch.resume()).thenReturn((Object)batch);
        Mockito.when((Object)suspendedBatch.resumeWithContext()).thenReturn((Object)context);
        Mockito.when((Object)((Batch)context.get())).thenReturn((Object)batch);
        Mockito.when((Object)config.findSessionId(exchange)).thenReturn((Object)sessionId);
        Mockito.when((Object)this.manager.findSession(sessionId)).thenReturn((Object)session);
        Mockito.when((Object)session.getId()).thenReturn((Object)sessionId);
        Mockito.when((Object)session.isValid()).thenReturn((Object)true);
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.isExpired()).thenReturn((Object)false);
        Mockito.when((Object)metaData.isNew()).thenReturn((Object)false);
        io.undertow.server.session.Session sessionAdapter = this.adapter.getSession(exchange, config);
        Assert.assertNotNull((Object)sessionAdapter);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.statistics});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.identifierFactory});
        ((Batch)Mockito.verify((Object)batch)).suspend();
        String expected = "expected";
        Mockito.when((Object)session.getId()).thenReturn((Object)expected);
        String result = sessionAdapter.getId();
        Assert.assertSame((Object)expected, (Object)result);
    }

    @Test
    public void getSessionNoSessionId() {
        HttpServerExchange exchange = new HttpServerExchange(null);
        SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        SuspendedBatch suspendedBatch = (SuspendedBatch)Mockito.mock(SuspendedBatch.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        Mockito.when((Object)((Batch)this.batchFactory.get())).thenReturn((Object)batch);
        Mockito.when((Object)batch.suspend()).thenReturn((Object)suspendedBatch);
        Mockito.when((Object)suspendedBatch.resume()).thenReturn((Object)batch);
        Mockito.when((Object)suspendedBatch.resumeWithContext()).thenReturn((Object)context);
        Mockito.when((Object)((Batch)context.get())).thenReturn((Object)batch);
        Mockito.when((Object)config.findSessionId(exchange)).thenReturn(null);
        io.undertow.server.session.Session sessionAdapter = this.adapter.getSession(exchange, config);
        Assert.assertNull((Object)sessionAdapter);
        ((Batch)Mockito.verify((Object)batch)).discard();
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getSessionInvalidCharacters() {
        HttpServerExchange exchange = new HttpServerExchange(null);
        SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        SuspendedBatch suspendedBatch = (SuspendedBatch)Mockito.mock(SuspendedBatch.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        String sessionId = "session+";
        Mockito.when((Object)((Batch)this.batchFactory.get())).thenReturn((Object)batch);
        Mockito.when((Object)batch.suspend()).thenReturn((Object)suspendedBatch);
        Mockito.when((Object)suspendedBatch.resume()).thenReturn((Object)batch);
        Mockito.when((Object)suspendedBatch.resumeWithContext()).thenReturn((Object)context);
        Mockito.when((Object)((Batch)context.get())).thenReturn((Object)batch);
        Mockito.when((Object)config.findSessionId(exchange)).thenReturn((Object)sessionId);
        io.undertow.server.session.Session sessionAdapter = this.adapter.getSession(exchange, config);
        Assert.assertNull((Object)sessionAdapter);
        sessionAdapter = this.adapter.getSession(sessionId);
        Assert.assertNull((Object)sessionAdapter);
        ((SessionManager)Mockito.verify(this.manager, (VerificationMode)Mockito.never())).findSession(sessionId);
        ((Batch)Mockito.verify((Object)batch)).discard();
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getSessionNotExists() {
        HttpServerExchange exchange = new HttpServerExchange(null);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        SuspendedBatch suspendedBatch = (SuspendedBatch)Mockito.mock(SuspendedBatch.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
        String sessionId = "session";
        Mockito.when((Object)((Batch)this.batchFactory.get())).thenReturn((Object)batch);
        Mockito.when((Object)batch.suspend()).thenReturn((Object)suspendedBatch);
        Mockito.when((Object)suspendedBatch.resume()).thenReturn((Object)batch);
        Mockito.when((Object)suspendedBatch.resumeWithContext()).thenReturn((Object)context);
        Mockito.when((Object)((Batch)context.get())).thenReturn((Object)batch);
        Mockito.when((Object)config.findSessionId(exchange)).thenReturn((Object)sessionId);
        Mockito.when((Object)this.manager.findSession(sessionId)).thenReturn(null);
        Mockito.when((Object)this.manager.getBatchFactory()).thenReturn((Object)Supplier.of((Object)batch));
        io.undertow.server.session.Session sessionAdapter = this.adapter.getSession(exchange, config);
        Assert.assertNull((Object)sessionAdapter);
        ((Batch)Mockito.verify((Object)batch)).discard();
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getSessionInvalid() {
        HttpServerExchange exchange = new HttpServerExchange(null);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        SuspendedBatch suspendedBatch = (SuspendedBatch)Mockito.mock(SuspendedBatch.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
        Session session = (Session)Mockito.mock(Session.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        String sessionId = "session";
        Mockito.when((Object)((Batch)this.batchFactory.get())).thenReturn((Object)batch);
        Mockito.when((Object)batch.suspend()).thenReturn((Object)suspendedBatch);
        Mockito.when((Object)suspendedBatch.resume()).thenReturn((Object)batch);
        Mockito.when((Object)suspendedBatch.resumeWithContext()).thenReturn((Object)context);
        Mockito.when((Object)((Batch)context.get())).thenReturn((Object)batch);
        Mockito.when((Object)config.findSessionId(exchange)).thenReturn((Object)sessionId);
        Mockito.when((Object)this.manager.findSession(sessionId)).thenReturn((Object)session);
        Mockito.when((Object)session.getId()).thenReturn((Object)sessionId);
        Mockito.when((Object)session.isValid()).thenReturn((Object)false);
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.isExpired()).thenReturn((Object)false);
        Mockito.when((Object)metaData.isNew()).thenReturn((Object)false);
        io.undertow.server.session.Session sessionAdapter = this.adapter.getSession(exchange, config);
        Assert.assertNull((Object)sessionAdapter);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.statistics});
        ((Batch)Mockito.verify((Object)batch)).discard();
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getSessionExpired() {
        HttpServerExchange exchange = new HttpServerExchange(null);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        SuspendedBatch suspendedBatch = (SuspendedBatch)Mockito.mock(SuspendedBatch.class);
        BatchContext context = (BatchContext)Mockito.mock(BatchContext.class);
        SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
        Session session = (Session)Mockito.mock(Session.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        String sessionId = "session";
        Mockito.when((Object)((Batch)this.batchFactory.get())).thenReturn((Object)batch);
        Mockito.when((Object)batch.suspend()).thenReturn((Object)suspendedBatch);
        Mockito.when((Object)suspendedBatch.resume()).thenReturn((Object)batch);
        Mockito.when((Object)suspendedBatch.resumeWithContext()).thenReturn((Object)context);
        Mockito.when((Object)((Batch)context.get())).thenReturn((Object)batch);
        Mockito.when((Object)config.findSessionId(exchange)).thenReturn((Object)sessionId);
        Mockito.when((Object)this.manager.findSession(sessionId)).thenReturn((Object)session);
        Mockito.when((Object)session.getId()).thenReturn((Object)sessionId);
        Mockito.when((Object)session.isValid()).thenReturn((Object)true);
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.isExpired()).thenReturn((Object)true);
        Mockito.when((Object)metaData.isNew()).thenReturn((Object)false);
        io.undertow.server.session.Session sessionAdapter = this.adapter.getSession(exchange, config);
        Assert.assertNull((Object)sessionAdapter);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.statistics});
        ((Batch)Mockito.verify((Object)batch)).discard();
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void activeSessions() {
        Mockito.when((Object)this.stats.getActiveSessions()).thenReturn(Collections.singleton("expected"));
        int result = this.adapter.getActiveSessions().size();
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void getTransientSessions() {
        Set result = this.adapter.getTransientSessions();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void getActiveSessions() {
        String expected = "expected";
        Mockito.when((Object)this.stats.getActiveSessions()).thenReturn(Collections.singleton(expected));
        Set result = this.adapter.getActiveSessions();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertSame((Object)expected, result.iterator().next());
    }

    @Test
    public void getAllSessions() {
        String expected = "expected";
        Mockito.when((Object)this.stats.getSessions()).thenReturn(Collections.singleton(expected));
        Set result = this.adapter.getAllSessions();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertSame((Object)expected, result.iterator().next());
    }

    @Test
    public void getSessionByIdentifier() {
        Session session = (Session)Mockito.mock(Session.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        String id = "ABC123";
        ((SessionManager)Mockito.doReturn((Object)session).when(this.manager)).getDetachedSession(id);
        ((Session)Mockito.doReturn((Object)id).when((Object)session)).getId();
        ((Session)Mockito.doReturn((Object)metaData).when((Object)session)).getMetaData();
        ((Session)Mockito.doReturn((Object)false).when((Object)session)).isValid();
        io.undertow.server.session.Session result = this.adapter.getSession(id);
        Assert.assertNull((Object)result);
        ((Session)Mockito.doReturn((Object)true).when((Object)session)).isValid();
        result = this.adapter.getSession(id);
        Assert.assertSame((Object)id, (Object)result.getId());
    }

    @Test
    public void getStatistics() {
        Assert.assertSame((Object)this.statistics, (Object)this.adapter.getStatistics());
    }
}

