/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.undertow.session.UndertowSessionManager;

public class SessionFacade
implements io.undertow.server.session.Session {
    private final UndertowSessionManager manager;
    private volatile Map.Entry<Session<Void>, SessionConfig> entry;

    public SessionFacade(UndertowSessionManager manager, Session<Void> session, SessionConfig config) {
        this.manager = manager;
        this.entry = new AbstractMap.SimpleImmutableEntry<Session<Void>, SessionConfig>(session, config);
    }

    public String getId() {
        return this.entry.getKey().getId();
    }

    public void requestDone(HttpServerExchange exchange) {
        this.entry.getKey().close();
        this.manager.getSessionManager().getBatcher().endBatch(true);
    }

    public long getCreationTime() {
        return this.entry.getKey().getMetaData().getCreationTime().getTime();
    }

    public long getLastAccessedTime() {
        return this.entry.getKey().getMetaData().getLastAccessedTime().getTime();
    }

    public void setMaxInactiveInterval(int interval) {
        this.entry.getKey().getMetaData().setMaxInactiveInterval((long)interval, TimeUnit.SECONDS);
    }

    public int getMaxInactiveInterval() {
        return (int)this.entry.getKey().getMetaData().getMaxInactiveInterval(TimeUnit.SECONDS);
    }

    public Object getAttribute(String name) {
        return this.entry.getKey().getAttributes().getAttribute(name);
    }

    public Set<String> getAttributeNames() {
        return this.entry.getKey().getAttributes().getAttributeNames();
    }

    public Object setAttribute(String name, Object value) {
        if (value == null) {
            return this.removeAttribute(name);
        }
        Object old = this.entry.getKey().getAttributes().setAttribute(name, value);
        if (old == null) {
            this.manager.getSessionListeners().attributeAdded((io.undertow.server.session.Session)this, name, value);
        } else if (old != value) {
            this.manager.getSessionListeners().attributeUpdated((io.undertow.server.session.Session)this, name, value, old);
        }
        return old;
    }

    public Object removeAttribute(String name) {
        Object old = this.entry.getKey().getAttributes().removeAttribute(name);
        if (old != null) {
            this.manager.getSessionListeners().attributeRemoved((io.undertow.server.session.Session)this, name, old);
        }
        return old;
    }

    public void invalidate(HttpServerExchange exchange) {
        Map.Entry<Session<Void>, SessionConfig> entry = this.entry;
        Session<Void> session = entry.getKey();
        this.manager.getSessionListeners().sessionDestroyed((io.undertow.server.session.Session)this, exchange, SessionListener.SessionDestroyedReason.INVALIDATED);
        session.invalidate();
        if (exchange != null) {
            entry.getValue().clearSession(exchange, session.getId());
        }
        this.manager.getSessionManager().getBatcher().endBatch(true);
    }

    public SessionManager getSessionManager() {
        return this.manager;
    }

    public String changeSessionId(HttpServerExchange exchange, SessionConfig config) {
        Session<Void> oldSession = this.entry.getKey();
        org.wildfly.clustering.web.session.SessionManager<Void> manager = this.manager.getSessionManager();
        String id = manager.createSessionId();
        Session newSession = manager.createSession(id);
        for (String name : oldSession.getAttributes().getAttributeNames()) {
            newSession.getAttributes().setAttribute(name, oldSession.getAttributes().getAttribute(name));
        }
        newSession.getMetaData().setMaxInactiveInterval(oldSession.getMetaData().getMaxInactiveInterval(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        newSession.getMetaData().setLastAccessedTime(oldSession.getMetaData().getLastAccessedTime());
        config.setSessionId(exchange, this.manager.format(id, manager.locate(id)));
        this.entry = new AbstractMap.SimpleImmutableEntry<Session, SessionConfig>(newSession, config);
        oldSession.invalidate();
        return id;
    }
}

