/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.undertow.session.AbstractSessionAdapter;
import org.wildfly.clustering.web.undertow.session.UndertowSessionManager;

public class SessionAdapter
extends AbstractSessionAdapter<Session<Void>> {
    private final UndertowSessionManager manager;
    private volatile Map.Entry<Session<Void>, SessionConfig> entry;

    public SessionAdapter(UndertowSessionManager manager, Session<Void> session, SessionConfig config) {
        this.manager = manager;
        this.entry = new AbstractMap.SimpleImmutableEntry<Session<Void>, SessionConfig>(session, config);
    }

    public SessionManager getSessionManager() {
        return this.manager;
    }

    @Override
    protected Session<Void> getSession() {
        return this.entry.getKey();
    }

    public void requestDone(HttpServerExchange exchange) {
        this.getSession().close();
        this.manager.getSessionManager().getBatcher().endBatch(true);
    }

    public void setMaxInactiveInterval(int interval) {
        this.getSession().getMetaData().setMaxInactiveInterval((long)interval, TimeUnit.SECONDS);
    }

    public Object setAttribute(String name, Object value) {
        if (value == null) {
            return this.removeAttribute(name);
        }
        Object old = this.getSession().getAttributes().setAttribute(name, value);
        if (old == null) {
            this.manager.getSessionListeners().attributeAdded((io.undertow.server.session.Session)this, name, value);
        } else if (old != value) {
            this.manager.getSessionListeners().attributeUpdated((io.undertow.server.session.Session)this, name, value, old);
        }
        return old;
    }

    public Object removeAttribute(String name) {
        Object old = this.getSession().getAttributes().removeAttribute(name);
        if (old != null) {
            this.manager.getSessionListeners().attributeRemoved((io.undertow.server.session.Session)this, name, old);
        }
        return old;
    }

    public void invalidate(HttpServerExchange exchange) {
        Map.Entry<Session<Void>, SessionConfig> entry = this.entry;
        Session<Void> session = entry.getKey();
        this.manager.getSessionListeners().sessionDestroyed((io.undertow.server.session.Session)this, exchange, SessionListener.SessionDestroyedReason.INVALIDATED);
        session.invalidate();
        if (exchange != null) {
            entry.getValue().clearSession(exchange, session.getId());
        }
        this.manager.getSessionManager().getBatcher().endBatch(true);
    }

    public String changeSessionId(HttpServerExchange exchange, SessionConfig config) {
        Session<Void> oldSession = this.getSession();
        org.wildfly.clustering.web.session.SessionManager<Void> manager = this.manager.getSessionManager();
        String id = manager.createSessionId();
        Session newSession = manager.createSession(id);
        for (String name : oldSession.getAttributes().getAttributeNames()) {
            newSession.getAttributes().setAttribute(name, oldSession.getAttributes().getAttribute(name));
        }
        newSession.getMetaData().setMaxInactiveInterval(oldSession.getMetaData().getMaxInactiveInterval(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        newSession.getMetaData().setLastAccessedTime(oldSession.getMetaData().getLastAccessedTime());
        config.setSessionId(exchange, this.manager.format(id, manager.locate(id)));
        this.entry = new AbstractMap.SimpleImmutableEntry<Session, SessionConfig>(newSession, config);
        oldSession.invalidate();
        return id;
    }
}

