/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.security.idm.Account;
import io.undertow.security.impl.SingleSignOn;
import org.wildfly.clustering.web.Batch;
import org.wildfly.clustering.web.sso.Authentication;
import org.wildfly.clustering.web.sso.AuthenticationType;
import org.wildfly.clustering.web.sso.SSO;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.undertow.sso.DistributableSingleSignOn;
import org.wildfly.clustering.web.undertow.sso.SessionManagerRegistry;
import org.wildfly.extension.undertow.security.sso.SingleSignOnManager;

public class DistributableSingleSignOnManager
implements SingleSignOnManager {
    private final SSOManager<Account, String, Void> manager;
    private final SessionManagerRegistry registry;
    private volatile boolean started = false;

    public DistributableSingleSignOnManager(SSOManager<Account, String, Void> manager, SessionManagerRegistry registry) {
        this.manager = manager;
        this.registry = registry;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        this.manager.start();
        this.started = true;
    }

    public void stop() {
        this.started = false;
        this.manager.stop();
    }

    public SingleSignOn createSingleSignOn(Account account, String mechanism) {
        String id = (String)this.manager.createIdentifier();
        Batch batch = this.manager.getBatcher().startBatch();
        SSO sso = this.manager.createSSO(id);
        Authentication authentication = sso.getAuthentication();
        authentication.setIdentity((Object)account);
        authentication.setType(AuthenticationType.valueOf((String)mechanism));
        return new DistributableSingleSignOn((SSO<Account, String, Void>)sso, this.registry, batch);
    }

    public SingleSignOn findSingleSignOn(String id) {
        Batch batch = this.manager.getBatcher().startBatch();
        SSO sso = this.manager.findSSO(id);
        if (sso == null) {
            batch.discard();
            return null;
        }
        return new DistributableSingleSignOn((SSO<Account, String, Void>)sso, this.registry, batch);
    }

    public void removeSingleSignOn(String id) {
        Batch batch = this.manager.getBatcher().startBatch();
        SSO sso = this.manager.findSSO(id);
        if (sso != null) {
            sso.invalidate();
            batch.close();
        } else {
            batch.discard();
        }
    }
}

