/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.resourceadapters;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.services.mdr.AS7MetadataRepository;
import org.jboss.as.connector.services.resourceadapters.ResourceAdapterActivatorService;
import org.jboss.as.connector.services.resourceadapters.deployment.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemConfiguration;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.spec.Connector;
import org.jboss.jca.common.api.metadata.spec.ResourceAdapter;
import org.jboss.jca.common.metadata.resourceadapter.ActivationImpl;
import org.jboss.jca.common.metadata.resourceadapter.AdminObjectImpl;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.SubjectFactory;

public class DirectAdminObjectActivatorService
implements Service<ContextNames.BindInfo> {
    public static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"connector"}).append(new String[]{"direct-connection-factory-activator"});
    protected final InjectedValue<AS7MetadataRepository> mdr = new InjectedValue();
    private final String jndiName;
    private final String className;
    private final String resourceAdapter;
    private final String raId;
    private final Map<String, String> properties;
    private final Module module;
    private final ContextNames.BindInfo bindInfo;

    public DirectAdminObjectActivatorService(String jndiName, String className, String resourceAdapter, String raId, Map<String, String> properties, Module module, ContextNames.BindInfo bindInfo) {
        this.jndiName = jndiName;
        this.className = className;
        this.resourceAdapter = resourceAdapter;
        this.raId = raId;
        this.properties = properties;
        this.module = module;
        this.bindInfo = bindInfo;
    }

    public ContextNames.BindInfo getValue() throws IllegalStateException, IllegalArgumentException {
        return this.bindInfo;
    }

    public void start(StartContext context) throws StartException {
        ConnectorLogger.ROOT_LOGGER.debugf("started DirectConnectionFactoryActivatorService %s", context.getController().getName());
        String aoClass = null;
        try {
            Connector cmd = ((AS7MetadataRepository)this.mdr.getValue()).getResourceAdapter(this.raId);
            if (cmd.getVersion() == Connector.Version.V_10) {
                throw ConnectorLogger.ROOT_LOGGER.adminObjectForJCA10(this.resourceAdapter, this.jndiName);
            }
            ResourceAdapter ra1516 = cmd.getResourceadapter();
            if (ra1516.getAdminObjects() != null) {
                for (Object ao2 : ra1516.getAdminObjects()) {
                    if (!ao2.getAdminobjectClass().getValue().equals(this.className)) continue;
                    aoClass = ao2.getAdminobjectClass().getValue();
                }
            }
            if (aoClass == null || !aoClass.equals(this.className)) {
                throw ConnectorLogger.ROOT_LOGGER.invalidAdminObject(aoClass, this.resourceAdapter, this.jndiName);
            }
            HashMap<String, String> raConfigProperties = new HashMap<String, String>();
            HashMap<String, String> aoConfigProperties = new HashMap<String, String>();
            if (this.properties != null) {
                for (Map.Entry entry : this.properties.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (key.startsWith("ra.")) {
                        raConfigProperties.put(key.substring(3), value);
                        continue;
                    }
                    if (key.startsWith("ao.")) {
                        aoConfigProperties.put(key.substring(3), value);
                        continue;
                    }
                    aoConfigProperties.put(key, value);
                }
            }
            AdminObjectImpl ao = new AdminObjectImpl(aoConfigProperties, aoClass, this.jndiName, this.poolName(aoClass, this.className), Boolean.TRUE, Boolean.TRUE);
            ActivationImpl activationImpl = new ActivationImpl(null, null, TransactionSupportEnum.LocalTransaction, Collections.emptyList(), Collections.singletonList(ao), null, Collections.emptyList(), null, null);
            String serviceName = this.jndiName;
            serviceName = serviceName.replace(':', '_');
            serviceName = serviceName.replace('/', '_');
            ResourceAdapterActivatorService activator = new ResourceAdapterActivatorService(cmd, (Activation)activationImpl, (ClassLoader)this.module.getClassLoader(), serviceName);
            activator.setCreateBinderService(false);
            activator.setBindInfo(this.bindInfo);
            ServiceTarget serviceTarget = context.getChildTarget();
            ServiceBuilder adminObjectServiceBuilder = serviceTarget.addService(ConnectorServices.RESOURCE_ADAPTER_ACTIVATOR_SERVICE.append(new String[]{serviceName}), (Service)activator).addDependency(ConnectorServices.IRONJACAMAR_MDR, AS7MetadataRepository.class, activator.getMdrInjector()).addDependency(ConnectorServices.RA_REPOSITORY_SERVICE, ResourceAdapterRepository.class, activator.getRaRepositoryInjector()).addDependency(ConnectorServices.MANAGEMENT_REPOSITORY_SERVICE, ManagementRepository.class, activator.getManagementRepositoryInjector()).addDependency(ConnectorServices.RESOURCE_ADAPTER_REGISTRY_SERVICE, ResourceAdapterDeploymentRegistry.class, activator.getRegistryInjector()).addDependency(ConnectorServices.TRANSACTION_INTEGRATION_SERVICE, TransactionIntegration.class, activator.getTxIntegrationInjector()).addDependency(ConnectorServices.CONNECTOR_CONFIG_SERVICE, JcaSubsystemConfiguration.class, activator.getConfigInjector()).addDependency(SubjectFactoryService.SERVICE_NAME, SubjectFactory.class, activator.getSubjectFactoryInjector()).addDependency(ConnectorServices.CCM_SERVICE, CachedConnectionManager.class, activator.getCcmInjector()).addDependency(NamingService.SERVICE_NAME).addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER).addDependency(ConnectorServices.BOOTSTRAP_CONTEXT_SERVICE.append(new String[]{"default"}));
            adminObjectServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public Injector<AS7MetadataRepository> getMdrInjector() {
        return this.mdr;
    }

    public void stop(StopContext context) {
        ConnectorLogger.ROOT_LOGGER.debugf("stopped DirectConnectionFactoryActivatorService %s", context.getController().getName());
    }

    private String poolName(String aoClass, String aoInterface) {
        if (aoInterface != null) {
            if (aoInterface.indexOf(".") != -1) {
                return aoInterface.substring(aoInterface.lastIndexOf(".") + 1);
            }
            return aoInterface;
        }
        if (aoClass.indexOf(".") != -1) {
            return aoClass.substring(aoClass.lastIndexOf(".") + 1);
        }
        return aoClass;
    }
}

