/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.List;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceAdd;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.CommonDeploymentService;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.DataSourceConfigService;
import org.jboss.as.connector.subsystems.datasources.DataSourceEnable;
import org.jboss.as.connector.subsystems.datasources.DataSourceReferenceFactoryService;
import org.jboss.as.connector.subsystems.datasources.XADataSourceConfigService;
import org.jboss.as.connector.subsystems.datasources.XaDataSourceRemove;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public abstract class AbstractDataSourceRemove
extends AbstractRemoveStepHandler {
    private AbstractDataSourceAdd addHandler;

    protected AbstractDataSourceRemove(AbstractDataSourceAdd addHandler) {
        this.addHandler = addHandler;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceName dataSourceServiceName;
        ServiceController dataSourceController;
        ServiceController xaDataSourceConfigController;
        ServiceName referenceFactoryServiceName;
        ServiceController referenceFactoryController;
        ServiceRegistry registry = context.getServiceRegistry(true);
        ModelNode address = operation.require("address");
        String dsName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        String jndiName = Constants.JNDI_NAME.resolveModelAttribute(context, model).asString();
        ServiceName binderServiceName = ContextNames.bindInfoFor((String)jndiName).getBinderServiceName();
        ServiceController binderController = registry.getService(binderServiceName);
        if (binderController != null) {
            context.removeService(binderServiceName);
        }
        if ((referenceFactoryController = registry.getService(referenceFactoryServiceName = DataSourceReferenceFactoryService.SERVICE_NAME_BASE.append(new String[]{dsName}))) != null) {
            context.removeService(referenceFactoryServiceName);
        }
        ServiceName dataSourceConfigServiceName = DataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{dsName});
        ServiceName xaDataSourceConfigServiceName = XADataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{dsName});
        List serviceNames = registry.getServiceNames();
        for (ServiceName name : serviceNames) {
            if (dataSourceConfigServiceName.append(new String[]{"connection-properties"}).isParentOf(name)) {
                context.removeService(name);
            }
            if (!xaDataSourceConfigServiceName.append(new String[]{"xa-datasource-properties"}).isParentOf(name)) continue;
            context.removeService(name);
        }
        ServiceController dataSourceConfigController = registry.getService(dataSourceConfigServiceName);
        if (dataSourceConfigController != null) {
            context.removeService(dataSourceConfigServiceName);
        }
        if ((xaDataSourceConfigController = registry.getService(xaDataSourceConfigServiceName)) != null) {
            context.removeService(xaDataSourceConfigServiceName);
        }
        if ((dataSourceController = registry.getService(dataSourceServiceName = AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{jndiName}))) != null) {
            context.removeService(dataSourceServiceName);
        }
        context.removeService(CommonDeploymentService.SERVICE_NAME_BASE.append(new String[]{jndiName}));
        context.removeService(dataSourceServiceName.append(new String[]{"statistics"}));
        ServiceName driverDemanderServiceName = ServiceName.JBOSS.append(new String[]{"driver-demander"}).append(new String[]{jndiName});
        ServiceController driverDemanderController = registry.getService(driverDemanderServiceName);
        if (driverDemanderController != null) {
            context.removeService(driverDemanderServiceName);
        }
        context.getResourceRegistrationForUpdate().unregisterOverrideModel(dsName);
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        boolean enabled;
        this.addHandler.performRuntime(context, operation, null, model);
        boolean bl = enabled = !operation.hasDefined(Constants.ENABLED.getName()) || Constants.ENABLED.resolveModelAttribute(context, model).asBoolean();
        if (context.isNormalServer() && enabled) {
            ManagementResourceRegistration datasourceRegistration = context.getResourceRegistrationForUpdate();
            PathAddress addr = PathAddress.pathAddress((ModelNode)operation.get("address"));
            Resource resource = context.getOriginalRootResource();
            for (PathElement element : addr) {
                resource = resource.getChild(element);
            }
            DataSourceEnable.addServices(context, operation, datasourceRegistration, Resource.Tools.readModel((Resource)resource), this instanceof XaDataSourceRemove);
        }
    }
}

