/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.ra.processors;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.connector.annotations.repository.jandex.JandexAnnotationRepositoryImpl;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.metadata.api.resourceadapter.ActivationSecurityUtil;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.connector.metadata.xmldescriptors.IronJacamarXmlDescriptor;
import org.jboss.as.connector.services.mdr.AS7MetadataRepository;
import org.jboss.as.connector.services.resourceadapters.deployment.ResourceAdapterDeploymentService;
import org.jboss.as.connector.services.resourceadapters.deployment.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemConfiguration;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.core.security.ServerSecurityManager;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.security.service.SimpleSecurityManagerService;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentModelUtils;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.AnnotationIndexUtils;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.dmr.ModelNode;
import org.jboss.jandex.Index;
import org.jboss.jca.common.annotations.Annotations;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.spec.Connector;
import org.jboss.jca.common.metadata.merge.Merger;
import org.jboss.jca.common.spi.annotations.repository.AnnotationRepository;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.SubjectFactory;

public class ParsedRaDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ConnectorXmlDescriptor connectorXmlDescriptor = (ConnectorXmlDescriptor)phaseContext.getDeploymentUnit().getAttachment(ConnectorXmlDescriptor.ATTACHMENT_KEY);
        ManagementResourceRegistration baseRegistration = (ManagementResourceRegistration)phaseContext.getDeploymentUnit().getAttachment(DeploymentModelUtils.MUTABLE_REGISTRATION_ATTACHMENT);
        Resource deploymentResource = (Resource)phaseContext.getDeploymentUnit().getAttachment(DeploymentModelUtils.DEPLOYMENT_RESOURCE);
        if (connectorXmlDescriptor == null) {
            return;
        }
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ManagementResourceRegistration registration = deploymentUnit.getParent() != null ? baseRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subdeployment")})) : baseRegistration;
        IronJacamarXmlDescriptor ironJacamarXmlDescriptor = (IronJacamarXmlDescriptor)deploymentUnit.getAttachment(IronJacamarXmlDescriptor.ATTACHMENT_KEY);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            throw ConnectorLogger.ROOT_LOGGER.failedToGetModuleAttachment(phaseContext.getDeploymentUnit());
        }
        ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debugf("ParsedRaDeploymentProcessor: Processing=%s", deploymentUnit);
        ModuleClassLoader classLoader = module.getClassLoader();
        Map annotationIndexes = AnnotationIndexUtils.getAnnotationIndexes((DeploymentUnit)deploymentUnit);
        ServiceBuilder<ResourceAdapterDeployment> builder = ParsedRaDeploymentProcessor.process(connectorXmlDescriptor, ironJacamarXmlDescriptor, (ClassLoader)classLoader, serviceTarget, annotationIndexes, deploymentUnit.getServiceName(), registration, deploymentResource);
        if (builder != null) {
            String bootstrapCtx = null;
            if (ironJacamarXmlDescriptor != null && ironJacamarXmlDescriptor.getIronJacamar() != null && ironJacamarXmlDescriptor.getIronJacamar().getBootstrapContext() != null) {
                bootstrapCtx = ironJacamarXmlDescriptor.getIronJacamar().getBootstrapContext();
            }
            if (bootstrapCtx == null) {
                bootstrapCtx = "default";
            }
            builder.addDependency(ConnectorServices.BOOTSTRAP_CONTEXT_SERVICE.append(new String[]{bootstrapCtx}));
            if (registration.isAllowsOverride() && registration.getOverrideModel(deploymentUnit.getName()) == null) {
                registration.registerOverrideModel(deploymentUnit.getName(), new OverrideDescriptionProvider(){

                    public Map<String, ModelNode> getAttributeOverrideDescriptions(Locale locale) {
                        return Collections.emptyMap();
                    }

                    public Map<String, ModelNode> getChildTypeOverrideDescriptions(Locale locale) {
                        return Collections.emptyMap();
                    }
                });
            }
            builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
    }

    public static ServiceBuilder<ResourceAdapterDeployment> process(ConnectorXmlDescriptor connectorXmlDescriptor, IronJacamarXmlDescriptor ironJacamarXmlDescriptor, ClassLoader classLoader, ServiceTarget serviceTarget, Map<ResourceRoot, Index> annotationIndexes, ServiceName duServiceName, ManagementResourceRegistration registration, Resource deploymentResource) throws DeploymentUnitProcessingException {
        Connector cmd = connectorXmlDescriptor != null ? connectorXmlDescriptor.getConnector() : null;
        Activation activation = ironJacamarXmlDescriptor != null ? ironJacamarXmlDescriptor.getIronJacamar() : null;
        try {
            Annotations annotator = new Annotations();
            if (annotationIndexes != null && annotationIndexes.size() > 0) {
                ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debugf("ParsedRaDeploymentProcessor: Found %d annotationIndexes", annotationIndexes.size());
                for (Index index : annotationIndexes.values()) {
                    if (index.getKnownClasses() == null || index.getKnownClasses().size() <= 0) continue;
                    JandexAnnotationRepositoryImpl repository = new JandexAnnotationRepositoryImpl(index, classLoader);
                    cmd = annotator.merge(cmd, (AnnotationRepository)repository, classLoader);
                    ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debugf("ParsedRaDeploymentProcessor: CMD=%s", cmd);
                }
            }
            if (annotationIndexes == null || annotationIndexes.size() == 0) {
                ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debugf("ParsedRaDeploymentProcessor: Found 0 annotationIndexes", new Object[0]);
            }
            if (cmd != null) {
                cmd.validate();
                cmd = new Merger().mergeConnectorWithCommonIronJacamar(activation, cmd);
            }
            TransactionSupportEnum transactionSupport = TransactionSupportEnum.NoTransaction;
            if (cmd != null && cmd.getResourceadapter() != null && cmd.getResourceadapter().getOutboundResourceadapter() != null) {
                transactionSupport = cmd.getResourceadapter().getOutboundResourceadapter().getTransactionSupport();
            }
            if (activation != null && activation.getTransactionSupport() != null) {
                transactionSupport = activation.getTransactionSupport();
            }
            ServiceName deployerServiceName = ConnectorServices.RESOURCE_ADAPTER_DEPLOYER_SERVICE_PREFIX.append(new String[]{connectorXmlDescriptor.getDeploymentName()});
            ResourceAdapterDeploymentService raDeploymentService = new ResourceAdapterDeploymentService(connectorXmlDescriptor, cmd, activation, classLoader, deployerServiceName, duServiceName, registration, deploymentResource);
            ServiceBuilder builder = Services.addServerExecutorDependency((ServiceBuilder)serviceTarget.addService(deployerServiceName, (Service)raDeploymentService), raDeploymentService.getExecutorServiceInjector()).addDependency(ConnectorServices.IRONJACAMAR_MDR, AS7MetadataRepository.class, raDeploymentService.getMdrInjector()).addDependency(ConnectorServices.RA_REPOSITORY_SERVICE, ResourceAdapterRepository.class, raDeploymentService.getRaRepositoryInjector()).addDependency(ConnectorServices.MANAGEMENT_REPOSITORY_SERVICE, ManagementRepository.class, raDeploymentService.getManagementRepositoryInjector()).addDependency(ConnectorServices.RESOURCE_ADAPTER_REGISTRY_SERVICE, ResourceAdapterDeploymentRegistry.class, raDeploymentService.getRegistryInjector()).addDependency(ConnectorServices.TRANSACTION_INTEGRATION_SERVICE, TransactionIntegration.class, raDeploymentService.getTxIntegrationInjector()).addDependency(ConnectorServices.CONNECTOR_CONFIG_SERVICE, JcaSubsystemConfiguration.class, raDeploymentService.getConfigInjector()).addDependency(ConnectorServices.IDLE_REMOVER_SERVICE).addDependency(ConnectorServices.CONNECTION_VALIDATOR_SERVICE).addDependency(NamingService.SERVICE_NAME);
            if (transactionSupport == null || transactionSupport.equals((Object)TransactionSupportEnum.NoTransaction)) {
                builder.addDependency(ConnectorServices.NON_TX_CCM_SERVICE, CachedConnectionManager.class, raDeploymentService.getCcmInjector());
            } else {
                builder.addDependency(ConnectorServices.CCM_SERVICE, CachedConnectionManager.class, raDeploymentService.getCcmInjector());
            }
            if (activation != null && ActivationSecurityUtil.isLegacySecurityRequired(activation)) {
                builder.addDependency(SubjectFactoryService.SERVICE_NAME, SubjectFactory.class, raDeploymentService.getSubjectFactoryInjector()).addDependency(SimpleSecurityManagerService.SERVICE_NAME, ServerSecurityManager.class, raDeploymentService.getServerSecurityManager());
            }
            return builder;
        }
        catch (Throwable t) {
            throw new DeploymentUnitProcessingException(t);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

