/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.metadata.api.resourceadapter;

import java.util.List;
import org.jboss.as.connector.metadata.api.resourceadapter.WorkManagerSecurity;
import org.jboss.jca.common.api.metadata.common.Security;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition;

public final class ActivationSecurityUtil {
    public static boolean isLegacySecurityRequired(Activation raxml) {
        List connDefs;
        org.jboss.jca.common.api.metadata.resourceadapter.WorkManagerSecurity wmsecurity;
        boolean required = false;
        org.jboss.jca.common.api.metadata.resourceadapter.WorkManagerSecurity workManagerSecurity = wmsecurity = raxml.getWorkManager() != null ? raxml.getWorkManager().getSecurity() : null;
        if (wmsecurity != null && !ActivationSecurityUtil.isElytronEnabled(wmsecurity)) {
            String domain = wmsecurity.getDomain();
            boolean bl = required = domain != null && domain.trim().length() > 0;
        }
        if (!required && (connDefs = raxml.getConnectionDefinitions()) != null) {
            for (ConnectionDefinition cd : connDefs) {
                String domain;
                Security cdsecurity = cd.getSecurity();
                if (cdsecurity == null || ActivationSecurityUtil.isElytronEnabled(cdsecurity) || (domain = cdsecurity.resolveSecurityDomain()) == null || domain.trim().length() <= 0) continue;
                required = true;
                break;
            }
        }
        return required;
    }

    public static boolean isLegacySecurityRequired(Security security) {
        boolean required;
        boolean bl = required = security != null && !ActivationSecurityUtil.isElytronEnabled(security);
        if (required) {
            String domain = security.resolveSecurityDomain();
            required = domain != null && domain.trim().length() > 0;
        }
        return required;
    }

    private static boolean isElytronEnabled(Object config) {
        return config instanceof WorkManagerSecurity && ((WorkManagerSecurity)config).isElytronEnabled();
    }

    private ActivationSecurityUtil() {
    }
}

