/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.resourceadapters;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.connector.services.resourceadapters.ResourceAdapterService;
import org.jboss.as.connector.services.resourceadapters.deployment.AbstractResourceAdapterDeploymentService;
import org.jboss.as.connector.services.resourceadapters.deployment.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.spec.AdminObject;
import org.jboss.jca.common.api.metadata.spec.Connector;
import org.jboss.jca.common.api.metadata.spec.ResourceAdapter;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.deployers.DeployersLogger;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.Configuration;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public final class ResourceAdapterActivatorService
extends AbstractResourceAdapterDeploymentService
implements Service<ResourceAdapterDeployment> {
    private static final DeployersLogger DEPLOYERS_LOGGER = (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)ResourceAdapterActivator.class.getName());
    private final ClassLoader cl;
    private final Connector cmd;
    private final Activation activation;
    private final String deploymentName;
    private CommonDeployment deploymentMD;
    private ContextNames.BindInfo bindInfo;
    private final List<String> jndiAliases = new ArrayList<String>();
    private boolean createBinderService = true;

    public ResourceAdapterActivatorService(Connector cmd, Activation activation, ClassLoader cl, String deploymentName) {
        this.cmd = cmd;
        this.activation = activation;
        this.cl = cl;
        this.deploymentName = deploymentName;
        this.connectorServicesRegistrationName = deploymentName;
        this.bindInfo = null;
    }

    @Override
    public ContextNames.BindInfo getBindInfo(String jndi) {
        if (this.bindInfo != null) {
            return this.bindInfo;
        }
        return ContextNames.bindInfoFor((String)jndi);
    }

    public void setBindInfo(ContextNames.BindInfo bindInfo) {
        this.bindInfo = bindInfo;
    }

    public void addJndiAlias(String alias) {
        this.jndiAliases.add(alias);
    }

    public void addJndiAliases(Collection<String> aliases) {
        this.jndiAliases.addAll(aliases);
    }

    @Override
    public Collection<String> getJndiAliases() {
        return Collections.unmodifiableList(this.jndiAliases);
    }

    @Override
    public boolean isCreateBinderService() {
        return this.createBinderService;
    }

    public void setCreateBinderService(boolean createBinderService) {
        this.createBinderService = createBinderService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        String pathname = "file://RaActivator" + this.deploymentName;
        try {
            ResourceAdapterActivator activator = new ResourceAdapterActivator(context.getChildTarget(), new URL(pathname), this.deploymentName, new File(pathname), this.cl, this.cmd, this.activation);
            activator.setConfiguration((Configuration)this.getConfig().getValue());
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.cl);
                this.deploymentMD = activator.doDeploy();
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
            String raName = this.deploymentMD.getDeploymentName();
            ServiceName raServiceName = ConnectorServices.getResourceAdapterServiceName(raName);
            this.value = new ResourceAdapterDeployment(this.deploymentMD, raName, raServiceName);
            ((ResourceAdapterDeploymentRegistry)this.registry.getValue()).registerResourceAdapterDeployment(this.value);
            ((ManagementRepository)this.managementRepository.getValue()).getConnectors().add(this.value.getDeployment().getConnector());
            context.getChildTarget().addService(raServiceName, (Service)new ResourceAdapterService(raServiceName, this.value.getDeployment().getResourceAdapter())).setInitialMode(ServiceController.Mode.ACTIVE).install();
            ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debugf("Started service %s", ConnectorServices.RESOURCE_ADAPTER_ACTIVATOR_SERVICE);
        }
        catch (Throwable t) {
            String raName = this.deploymentName;
            ServiceName raServiceName = ConnectorServices.getResourceAdapterServiceName(raName);
            this.cleanupStartAsync(context, this.deploymentName, raServiceName, t);
        }
    }

    public void stop(StopContext context) {
        this.stopAsync(context, this.deploymentName, ConnectorServices.RESOURCE_ADAPTER_ACTIVATOR_SERVICE);
    }

    public CommonDeployment getDeploymentMD() {
        return this.deploymentMD;
    }

    private class ResourceAdapterActivator
    extends AbstractResourceAdapterDeploymentService.AbstractWildFlyRaDeployer {
        private final Activation activation;

        public ResourceAdapterActivator(ServiceTarget serviceTarget, URL url, String deploymentName, File root, ClassLoader cl, Connector cmd, Activation activation) {
            super(ResourceAdapterActivatorService.this, serviceTarget, url, deploymentName, root, cl, cmd, null);
            this.activation = activation;
        }

        @Override
        public CommonDeployment doDeploy() throws Throwable {
            this.setConfiguration((Configuration)ResourceAdapterActivatorService.this.getConfig().getValue());
            this.getConfiguration().setBeanValidation(false);
            this.start();
            CommonDeployment dep = this.createObjectsAndInjectValue(this.url, this.deploymentName, this.root, this.cl, this.cmd, this.activation);
            return dep;
        }

        @Override
        protected boolean checkActivation(Connector cmd, Activation activation) {
            if (cmd != null) {
                List aoMetas;
                List cdMetas;
                HashSet<String> raMcfClasses = new HashSet<String>();
                HashSet<String> raAoClasses = new HashSet<String>();
                ResourceAdapter ra = cmd.getResourceadapter();
                if (ra != null && ra.getOutboundResourceadapter() != null && ra.getOutboundResourceadapter().getConnectionDefinitions() != null && (cdMetas = ra.getOutboundResourceadapter().getConnectionDefinitions()).size() > 0) {
                    for (org.jboss.jca.common.api.metadata.spec.ConnectionDefinition cdMeta : cdMetas) {
                        raMcfClasses.add(cdMeta.getManagedConnectionFactoryClass().getValue());
                    }
                }
                if (ra != null && ra.getAdminObjects() != null && (aoMetas = ra.getAdminObjects()).size() > 0) {
                    for (AdminObject aoMeta : aoMetas) {
                        raAoClasses.add(aoMeta.getAdminobjectClass().getValue());
                    }
                }
                if (raMcfClasses.size() == 0 && raAoClasses.size() == 0) {
                    return true;
                }
                if (activation != null) {
                    String clz;
                    Iterator it;
                    String clz2;
                    HashSet<String> ijMcfClasses = new HashSet<String>();
                    HashSet<String> ijAoClasses = new HashSet<String>();
                    boolean mcfSingle = raMcfClasses.size() == 1;
                    boolean aoSingle = raAoClasses.size() == 1;
                    boolean mcfOk = true;
                    boolean aoOk = true;
                    if (activation.getConnectionDefinitions() != null) {
                        for (ConnectionDefinition def : activation.getConnectionDefinitions()) {
                            clz2 = def.getClassName();
                            if (clz2 == null) continue;
                            ijMcfClasses.add(clz2);
                        }
                    }
                    if (!mcfSingle) {
                        it = ijMcfClasses.iterator();
                        while (mcfOk && it.hasNext()) {
                            clz = (String)it.next();
                            if (raMcfClasses.contains(clz)) continue;
                            mcfOk = false;
                        }
                    }
                    if (activation.getAdminObjects() != null) {
                        for (ConnectionDefinition def : activation.getAdminObjects()) {
                            clz2 = def.getClassName();
                            if (clz2 == null) continue;
                            ijAoClasses.add(clz2);
                        }
                    }
                    if (!aoSingle) {
                        it = ijAoClasses.iterator();
                        while (aoOk && it.hasNext()) {
                            clz = (String)it.next();
                            if (raAoClasses.contains(clz)) continue;
                            aoOk = false;
                        }
                    }
                    return mcfOk || aoOk;
                }
            }
            return false;
        }

        protected DeployersLogger getLogger() {
            return DEPLOYERS_LOGGER;
        }

        protected void setRecoveryForResourceAdapterInResourceAdapterRepository(String key, boolean isXA) {
            try {
                ((ResourceAdapterRepository)ResourceAdapterActivatorService.this.raRepository.getValue()).setRecoveryForResourceAdapter(key, isXA);
            }
            catch (Throwable t) {
                ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.unableToRegisterRecovery(key, isXA);
            }
        }
    }
}

