/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.workmanager;

import java.util.concurrent.CountDownLatch;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkListener;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.security.CallbackImpl;
import org.jboss.as.connector.security.ElytronSecurityContext;
import org.jboss.jca.core.spi.security.SecurityIntegration;
import org.jboss.jca.core.workmanager.WorkManagerImpl;
import org.jboss.jca.core.workmanager.WorkWrapper;

public class WildflyWorkWrapper
extends WorkWrapper {
    WildflyWorkWrapper(WorkManagerImpl workManager, SecurityIntegration si, Work work, ExecutionContext executionContext, WorkListener workListener, CountDownLatch startedLatch, CountDownLatch completedLatch, long startTime) {
        super(workManager, si, work, executionContext, workListener, startedLatch, completedLatch, startTime);
    }

    protected void runWork() throws WorkCompletedException {
        if (this.securityIntegration.getSecurityContext() != null && ((CallbackImpl)this.workManager.getCallbackSecurity()).isElytronEnabled()) {
            ((ElytronSecurityContext)this.securityIntegration.getSecurityContext()).runWork(() -> {
                try {
                    WildflyWorkWrapper.super.runWork();
                }
                catch (WorkCompletedException e) {
                    ConnectorLogger.ROOT_LOGGER.unexceptedWorkerCompletionError(e.getLocalizedMessage(), e);
                }
            });
        } else {
            super.runWork();
        }
    }
}

