/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.resourceadapters.statistics;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.connector.dynamicresource.StatisticsResourceDefinition;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.connector.subsystems.resourceadapters.CommonAttributes;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.api.bootstrap.CloneableBootstrapContext;
import org.jboss.jca.core.api.connectionmanager.pool.PoolStatistics;
import org.jboss.jca.core.api.management.ConnectionFactory;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.spi.statistics.StatisticsPlugin;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ConnectionDefinitionStatisticsService
implements Service<ManagementResourceRegistration> {
    private final ManagementResourceRegistration overrideRegistration;
    private final boolean statsEnabled;
    private final String jndiName;
    protected final InjectedValue<ResourceAdapterDeployment> deployment = new InjectedValue();
    protected final InjectedValue<CloneableBootstrapContext> bootstrapContext = new InjectedValue();

    public ConnectionDefinitionStatisticsService(ManagementResourceRegistration registration, String jndiName, String poolName, boolean statsEnabled) {
        this.jndiName = jndiName;
        this.overrideRegistration = registration.isAllowsOverride() ? registration.registerOverrideModel(poolName, new OverrideDescriptionProvider(){

            public Map<String, ModelNode> getAttributeOverrideDescriptions(Locale locale) {
                return Collections.emptyMap();
            }

            public Map<String, ModelNode> getChildTypeOverrideDescriptions(Locale locale) {
                return Collections.emptyMap();
            }
        }) : registration;
        this.statsEnabled = statsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        ConnectorLogger.ROOT_LOGGER.debugf("Starting ConnectionDefinitionStatisticsService %s", this.jndiName);
        ConnectionDefinitionStatisticsService connectionDefinitionStatisticsService = this;
        synchronized (connectionDefinitionStatisticsService) {
            CommonDeployment deploymentMD = ((ResourceAdapterDeployment)this.deployment.getValue()).getDeployment();
            PathElement pePoolStats = PathElement.pathElement((String)"statistics", (String)"pool");
            PathElement peExtendedStats = PathElement.pathElement((String)"statistics", (String)"extended");
            if (deploymentMD.getConnector() != null && deploymentMD.getConnector().getConnectionFactories() != null) {
                for (ConnectionFactory cf : deploymentMD.getConnector().getConnectionFactories()) {
                    if (cf.getManagedConnectionFactory() == null || cf.getManagedConnectionFactory().getStatistics() == null) continue;
                    StatisticsPlugin extendStats = cf.getManagedConnectionFactory().getStatistics();
                    extendStats.setEnabled(this.statsEnabled);
                    if (extendStats.getNames().isEmpty() || this.overrideRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{peExtendedStats})) != null) continue;
                    this.overrideRegistration.registerSubModel((ResourceDefinition)new StatisticsResourceDefinition(peExtendedStats, CommonAttributes.RESOURCE_NAME, extendStats));
                }
            }
            if (deploymentMD.getConnectionManagers() != null) {
                for (ConnectionManager cm : deploymentMD.getConnectionManagers()) {
                    if (cm.getPool() == null || cm.getJndiName() == null || !cm.getJndiName().equals(this.jndiName)) continue;
                    PoolStatistics poolStats = cm.getPool().getStatistics();
                    poolStats.setEnabled(this.statsEnabled);
                    if (poolStats.getNames().isEmpty() || this.overrideRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{pePoolStats})) != null) continue;
                    this.overrideRegistration.registerSubModel((ResourceDefinition)new StatisticsResourceDefinition(pePoolStats, CommonAttributes.RESOURCE_NAME, (StatisticsPlugin)poolStats));
                }
            }
        }
    }

    public void stop(StopContext context) {
        PathElement peCD = PathElement.pathElement((String)"statistics", (String)"pool");
        if (this.overrideRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{peCD})) != null) {
            this.overrideRegistration.unregisterSubModel(peCD);
        }
        PathElement peExtended = PathElement.pathElement((String)"statistics", (String)"extended");
        if (this.overrideRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{peExtended})) != null) {
            this.overrideRegistration.unregisterSubModel(peExtended);
        }
    }

    public ManagementResourceRegistration getValue() throws IllegalStateException, IllegalArgumentException {
        return this.overrideRegistration;
    }

    public Injector<ResourceAdapterDeployment> getResourceAdapterDeploymentInjector() {
        return this.deployment;
    }

    public Injector<CloneableBootstrapContext> getBootstrapContextInjector() {
        return this.bootstrapContext;
    }
}

