/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.services.resourceadapters.statistics.ConnectionDefinitionStatisticsService;
import org.jboss.as.connector.subsystems.resourceadapters.CommonAttributes;
import org.jboss.as.connector.subsystems.resourceadapters.ConnectionDefinitionService;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.IronJacamarResource;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableResourceAdapter;
import org.jboss.as.connector.subsystems.resourceadapters.RaAdd;
import org.jboss.as.connector.subsystems.resourceadapters.RaOperationUtil;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.credential.source.CredentialSource;

public class ConnectionDefinitionAdd
extends AbstractAddStepHandler {
    private static final ServiceName SECURITY_MANAGER_SERVICE = ServiceName.JBOSS.append(new String[]{"security", "simple-security-manager"});
    private static final ServiceName SUBJECT_FACTORY_SERVICE = ServiceName.JBOSS.append(new String[]{"security", "subject-factory"});
    public static final ConnectionDefinitionAdd INSTANCE = new ConnectionDefinitionAdd();

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        ModelNode model = resource.getModel();
        CredentialReference.handleCredentialReferenceUpdate((OperationContext)context, (ModelNode)model.get(Constants.RECOVERY_CREDENTIAL_REFERENCE.getName()), (String)Constants.RECOVERY_CREDENTIAL_REFERENCE.getName());
    }

    protected void populateModel(ModelNode operation, ModelNode modelNode) throws OperationFailedException {
        for (AttributeDefinition attribute : CommonAttributes.CONNECTION_DEFINITIONS_NODE_ATTRIBUTE) {
            attribute.validateAndSet(operation, modelNode);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode address = operation.require("address");
        PathAddress path = context.getCurrentAddress();
        String jndiName = Constants.JNDINAME.resolveModelAttribute(context, operation).asString();
        String raName = path.getParent().getLastElement().getValue();
        ModelNode raModel = context.readResourceFromRoot(path.getParent(), false).getModel();
        boolean statsEnabled = Constants.STATISTICS_ENABLED.resolveModelAttribute(context, raModel).asBoolean();
        if (!raModel.hasDefined(Constants.ARCHIVE.getName()) && !raModel.hasDefined(Constants.MODULE.getName())) {
            throw ConnectorLogger.ROOT_LOGGER.archiveOrModuleRequired();
        }
        ModelNode resourceModel = resource.getModel();
        if (Constants.ELYTRON_ENABLED.resolveModelAttribute(context, resourceModel).asBoolean()) {
            if (resourceModel.hasDefined(Constants.SECURITY_DOMAIN.getName())) {
                throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.attributeRequiresFalseOrUndefinedAttribute(Constants.SECURITY_DOMAIN.getName(), Constants.ELYTRON_ENABLED.getName());
            }
            if (resourceModel.hasDefined(Constants.SECURITY_DOMAIN_AND_APPLICATION.getName())) {
                throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.attributeRequiresFalseOrUndefinedAttribute(Constants.SECURITY_DOMAIN_AND_APPLICATION.getName(), Constants.ELYTRON_ENABLED.getName());
            }
            if (resourceModel.hasDefined(Constants.APPLICATION.getName())) {
                throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.attributeRequiresFalseOrUndefinedAttribute(Constants.APPLICATION.getName(), Constants.ELYTRON_ENABLED.getName());
            }
        } else {
            if (resourceModel.hasDefined(Constants.AUTHENTICATION_CONTEXT.getName())) {
                throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.attributeRequiresTrueAttribute(Constants.AUTHENTICATION_CONTEXT.getName(), Constants.ELYTRON_ENABLED.getName());
            }
            if (resourceModel.hasDefined(Constants.AUTHENTICATION_CONTEXT_AND_APPLICATION.getName())) {
                throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.attributeRequiresTrueAttribute(Constants.AUTHENTICATION_CONTEXT_AND_APPLICATION.getName(), Constants.ELYTRON_ENABLED.getName());
            }
        }
        if (Constants.RECOVERY_ELYTRON_ENABLED.resolveModelAttribute(context, resourceModel).asBoolean()) {
            if (resourceModel.hasDefined(Constants.RECOVERY_SECURITY_DOMAIN.getName())) {
                throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.attributeRequiresFalseOrUndefinedAttribute(Constants.RECOVERY_SECURITY_DOMAIN.getName(), Constants.RECOVERY_ELYTRON_ENABLED.getName());
            }
        } else if (resourceModel.hasDefined(Constants.RECOVERY_AUTHENTICATION_CONTEXT.getName())) {
            throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.attributeRequiresTrueAttribute(Constants.RECOVERY_AUTHENTICATION_CONTEXT.getName(), Constants.RECOVERY_ELYTRON_ENABLED.getName());
        }
        boolean elytronEnabled = Constants.ELYTRON_ENABLED.resolveModelAttribute(context, resourceModel).asBoolean();
        boolean elytronRecoveryEnabled = Constants.RECOVERY_ELYTRON_ENABLED.resolveModelAttribute(context, resourceModel).asBoolean();
        ModelNode credentialReference = Constants.RECOVERY_CREDENTIAL_REFERENCE.resolveModelAttribute(context, resourceModel);
        boolean hasSecurityDomain = resourceModel.hasDefined(Constants.SECURITY_DOMAIN.getName());
        boolean hasSecurityDomainAndApp = resourceModel.hasDefined(Constants.SECURITY_DOMAIN_AND_APPLICATION.getName());
        if (resourceModel.hasDefined(Constants.AUTHENTICATION_CONTEXT.getName()) && !elytronEnabled) {
            throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.attributeRequiresTrueAttribute(Constants.AUTHENTICATION_CONTEXT.getName(), Constants.ELYTRON_ENABLED.getName());
        }
        if (resourceModel.hasDefined(Constants.AUTHENTICATION_CONTEXT_AND_APPLICATION.getName()) && !elytronEnabled) {
            throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.attributeRequiresTrueAttribute(Constants.AUTHENTICATION_CONTEXT_AND_APPLICATION.getName(), Constants.ELYTRON_ENABLED.getName());
        }
        if (hasSecurityDomain && elytronEnabled) {
            throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.attributeRequiresFalseOrUndefinedAttribute(Constants.SECURITY_DOMAIN.getName(), Constants.ELYTRON_ENABLED.getName());
        }
        if (hasSecurityDomainAndApp && elytronEnabled) {
            throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.attributeRequiresFalseOrUndefinedAttribute(Constants.SECURITY_DOMAIN_AND_APPLICATION.getName(), Constants.ELYTRON_ENABLED.getName());
        }
        boolean hasRecoverySecurityDomain = resourceModel.hasDefined(Constants.RECOVERY_SECURITY_DOMAIN.getName());
        if (resourceModel.hasDefined(Constants.RECOVERY_AUTHENTICATION_CONTEXT.getName()) && !elytronRecoveryEnabled) {
            throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.attributeRequiresTrueAttribute(Constants.RECOVERY_AUTHENTICATION_CONTEXT.getName(), Constants.RECOVERY_ELYTRON_ENABLED.getName());
        }
        if (hasRecoverySecurityDomain && elytronRecoveryEnabled) {
            throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.attributeRequiresFalseOrUndefinedAttribute(Constants.RECOVERY_SECURITY_DOMAIN.getName(), Constants.RECOVERY_ELYTRON_ENABLED.getName());
        }
        String archiveOrModuleName = raModel.get(Constants.ARCHIVE.getName()).isDefined() ? Constants.ARCHIVE.resolveModelAttribute(context, raModel).asString() : Constants.MODULE.resolveModelAttribute(context, raModel).asString();
        String poolName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        try {
            ServiceName serviceName = ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{raName, poolName});
            ServiceName raServiceName = ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{raName});
            ModifiableResourceAdapter ravalue = (ModifiableResourceAdapter)((Object)context.getServiceRegistry(false).getService(raServiceName).getValue());
            boolean isXa = ravalue.getTransactionSupport() == TransactionSupportEnum.XATransaction;
            ServiceTarget serviceTarget = context.getServiceTarget();
            ConnectionDefinitionService service = new ConnectionDefinitionService();
            service.getConnectionDefinitionSupplierInjector().inject(() -> RaOperationUtil.buildConnectionDefinitionObject(context, resourceModel, poolName, isXa, (ExceptionSupplier<CredentialSource, Exception>)((ExceptionSupplier)service.getCredentialSourceSupplier().getOptionalValue())));
            ServiceBuilder cdServiceBuilder = serviceTarget.addService(serviceName, (Service)service).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(raServiceName, ModifiableResourceAdapter.class, service.getRaInjector());
            if (elytronEnabled) {
                if (resourceModel.hasDefined(Constants.AUTHENTICATION_CONTEXT.getName())) {
                    cdServiceBuilder.requires(context.getCapabilityServiceName("org.wildfly.security.authentication-context", Constants.AUTHENTICATION_CONTEXT.resolveModelAttribute(context, resourceModel).asString(), AuthenticationContext.class));
                } else if (resourceModel.hasDefined(Constants.AUTHENTICATION_CONTEXT_AND_APPLICATION.getName())) {
                    cdServiceBuilder.requires(context.getCapabilityServiceName("org.wildfly.security.authentication-context", Constants.AUTHENTICATION_CONTEXT_AND_APPLICATION.resolveModelAttribute(context, resourceModel).asString(), AuthenticationContext.class));
                }
            }
            if (elytronRecoveryEnabled && resourceModel.hasDefined(Constants.RECOVERY_AUTHENTICATION_CONTEXT.getName())) {
                cdServiceBuilder.requires(context.getCapabilityServiceName("org.wildfly.security.authentication-context", Constants.RECOVERY_AUTHENTICATION_CONTEXT.resolveModelAttribute(context, resourceModel).asString(), AuthenticationContext.class));
            }
            if ((!elytronEnabled || !elytronRecoveryEnabled) && (hasSecurityDomain || hasSecurityDomainAndApp || hasRecoverySecurityDomain || RaAdd.requiresLegacySecurity(context, raModel))) {
                context.setRollbackOnly();
                throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.legacySecurityNotAvailable(path.getLastElement().getValue(), path.getParent().getLastElement().getValue());
            }
            if (credentialReference.isDefined()) {
                service.getCredentialSourceSupplier().inject((Object)CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)Constants.RECOVERY_CREDENTIAL_REFERENCE, (ModelNode)resourceModel, (ServiceBuilder)cdServiceBuilder));
            }
            cdServiceBuilder.install();
            ServiceRegistry registry = context.getServiceRegistry(true);
            ServiceController RaxmlController = registry.getService(ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{raName}));
            Activation raxml = (Activation)RaxmlController.getValue();
            ServiceName deploymentServiceName = ConnectorServices.getDeploymentServiceName(archiveOrModuleName, raName);
            String bootStrapCtxName = "default";
            if (raxml.getBootstrapContext() != null && !raxml.getBootstrapContext().equals("undefined")) {
                bootStrapCtxName = raxml.getBootstrapContext();
            }
            ConnectionDefinitionStatisticsService connectionDefinitionStatisticsService = new ConnectionDefinitionStatisticsService(context.getResourceRegistrationForUpdate(), jndiName, poolName, statsEnabled);
            ServiceBuilder statsServiceBuilder = serviceTarget.addService(serviceName.append(new String[]{"STATISTICS"}), (Service)connectionDefinitionStatisticsService);
            statsServiceBuilder.addDependency(ConnectorServices.BOOTSTRAP_CONTEXT_SERVICE.append(new String[]{bootStrapCtxName}), Object.class, connectionDefinitionStatisticsService.getBootstrapContextInjector()).addDependency(deploymentServiceName, Object.class, connectionDefinitionStatisticsService.getResourceAdapterDeploymentInjector()).setInitialMode(ServiceController.Mode.PASSIVE).install();
            PathElement peCD = PathElement.pathElement((String)"statistics", (String)"pool");
            IronJacamarResource.IronJacamarRuntimeResource cdResource = new IronJacamarResource.IronJacamarRuntimeResource();
            resource.registerChild(peCD, (Resource)cdResource);
            PathElement peExtended = PathElement.pathElement((String)"statistics", (String)"extended");
            IronJacamarResource.IronJacamarRuntimeResource extendedResource = new IronJacamarResource.IronJacamarRuntimeResource();
            resource.registerChild(peExtended, (Resource)extendedResource);
        }
        catch (Exception e) {
            throw new OperationFailedException((Throwable)e, new ModelNode().set(ConnectorLogger.ROOT_LOGGER.failedToCreate("ConnectionDefinition", operation, e.getLocalizedMessage())));
        }
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        CredentialReference.rollbackCredentialStoreUpdate((AttributeDefinition)Constants.RECOVERY_CREDENTIAL_REFERENCE, (OperationContext)context, (Resource)resource);
    }
}

