/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.Map;
import java.util.function.Supplier;
import org.jboss.as.connector.subsystems.datasources.ModifiableXaDataSource;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class XADataSourceConfigService
implements Service<ModifiableXaDataSource> {
    public static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"xa-data-source-config"});
    private final ModifiableXaDataSource dataSourceConfig;
    private final Map<String, Supplier<String>> xaDataSourceProperties;

    public XADataSourceConfigService(ModifiableXaDataSource dataSourceConfig, Map<String, Supplier<String>> xaDataSourceProperties) {
        this.dataSourceConfig = dataSourceConfig;
        this.xaDataSourceProperties = xaDataSourceProperties;
    }

    public void start(StartContext startContext) throws StartException {
        for (Map.Entry<String, Supplier<String>> xaDataSourceProperty : this.xaDataSourceProperties.entrySet()) {
            this.dataSourceConfig.addXaDataSourceProperty(xaDataSourceProperty.getKey(), xaDataSourceProperty.getValue().get());
        }
    }

    public void stop(StopContext stopContext) {
    }

    public ModifiableXaDataSource getValue() {
        return this.dataSourceConfig;
    }
}

