/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.ra;

import java.util.Arrays;
import javax.resource.spi.TransactionSupport;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.services.mdr.AS7MetadataRepository;
import org.jboss.as.connector.services.resourceadapters.ConnectionFactoryReferenceFactoryService;
import org.jboss.as.connector.services.resourceadapters.DirectConnectionFactoryActivatorService;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

public class DirectConnectionFactoryInjectionSource
extends InjectionSource {
    public static final String DESCRIPTION = "description";
    public static final String MAX_POOL_SIZE = "maxPoolSize";
    public static final String MIN_POOL_SIZE = "minPoolSize";
    public static final String PROPERTIES = "properties";
    public static final String TRANSACTION_SUPPORT = "transactionSupport";
    private final String jndiName;
    private final String interfaceName;
    private final String resourceAdapter;
    private String description;
    private int maxPoolSize = -1;
    private int minPoolSize = -1;
    private String[] properties;
    private TransactionSupport.TransactionSupportLevel transactionSupport;

    public DirectConnectionFactoryInjectionSource(String jndiName, String interfaceName, String resourceAdapter) {
        this.jndiName = jndiName;
        this.interfaceName = interfaceName;
        this.resourceAdapter = resourceAdapter;
    }

    public void getResourceValue(InjectionSource.ResolutionContext context, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        String raId = this.resourceAdapter;
        if (this.resourceAdapter.startsWith("#")) {
            raId = deploymentUnit.getParent().getName() + raId;
        }
        String deployerServiceName = raId;
        if (!raId.endsWith(".rar")) {
            raId = deployerServiceName = deployerServiceName + ".rar";
        }
        ConnectorLogger.SUBSYSTEM_RA_LOGGER.debugf("@ConnectionFactoryDefinition: %s for %s binding to %s ", this.interfaceName, this.resourceAdapter, this.jndiName);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoForEnvEntry((String)context.getApplicationName(), (String)context.getModuleName(), (String)context.getComponentName(), (!context.isCompUsesModule() ? 1 : 0) != 0, (String)this.jndiName);
        DirectConnectionFactoryActivatorService service = new DirectConnectionFactoryActivatorService(this.jndiName, this.interfaceName, this.resourceAdapter, raId, this.maxPoolSize, this.minPoolSize, this.properties, this.transactionSupport, module, bindInfo);
        ServiceName serviceName = DirectConnectionFactoryActivatorService.SERVICE_NAME_BASE.append(new String[]{this.jndiName});
        phaseContext.getServiceTarget().addService(serviceName, (Service)service).addDependency(ConnectorServices.IRONJACAMAR_MDR, AS7MetadataRepository.class, service.getMdrInjector()).addDependency(ConnectorServices.RESOURCE_ADAPTER_DEPLOYER_SERVICE_PREFIX.append(new String[]{deployerServiceName})).setInitialMode(ServiceController.Mode.ACTIVE).install();
        serviceBuilder.addDependency(ConnectionFactoryReferenceFactoryService.SERVICE_NAME_BASE.append(bindInfo.getBinderServiceName()), ManagedReferenceFactory.class, injector);
        serviceBuilder.addListener((ServiceListener)new AbstractServiceListener<Object>(){

            public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
                switch (transition) {
                    case STARTING_to_UP: {
                        ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.connectionFactoryAnnotation(DirectConnectionFactoryInjectionSource.this.jndiName);
                        break;
                    }
                    case STOPPING_to_DOWN: {
                        break;
                    }
                    case REMOVING_to_REMOVED: {
                        ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debugf("Removed JCA ConnectionFactory [%s]", DirectConnectionFactoryInjectionSource.this.jndiName);
                    }
                }
            }
        });
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public void setProperties(String[] properties) {
        this.properties = properties;
    }

    public TransactionSupport.TransactionSupportLevel getTransactionSupportLevel() {
        return this.transactionSupport;
    }

    public void setTransactionSupportLevel(TransactionSupport.TransactionSupportLevel transactionSupport) {
        this.transactionSupport = transactionSupport;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DirectConnectionFactoryInjectionSource)) {
            return false;
        }
        DirectConnectionFactoryInjectionSource that = (DirectConnectionFactoryInjectionSource)((Object)o);
        if (this.maxPoolSize != that.maxPoolSize) {
            return false;
        }
        if (this.minPoolSize != that.minPoolSize) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.interfaceName != null ? !this.interfaceName.equals(that.interfaceName) : that.interfaceName != null) {
            return false;
        }
        if (this.jndiName != null ? !this.jndiName.equals(that.jndiName) : that.jndiName != null) {
            return false;
        }
        if (!Arrays.equals(this.properties, that.properties)) {
            return false;
        }
        if (this.resourceAdapter != null ? !this.resourceAdapter.equals(that.resourceAdapter) : that.resourceAdapter != null) {
            return false;
        }
        return this.transactionSupport == that.transactionSupport;
    }

    public int hashCode() {
        int result = this.jndiName != null ? this.jndiName.hashCode() : 0;
        result = 31 * result + (this.interfaceName != null ? this.interfaceName.hashCode() : 0);
        result = 31 * result + (this.resourceAdapter != null ? this.resourceAdapter.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + this.maxPoolSize;
        result = 31 * result + this.minPoolSize;
        result = 31 * result + (this.properties != null ? Arrays.hashCode(this.properties) : 0);
        result = 31 * result + (this.transactionSupport != null ? this.transactionSupport.hashCode() : 0);
        return result;
    }
}

