/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.List;
import org.jboss.as.connector.logging.ConnectorMessages;
import org.jboss.as.connector.subsystems.resourceadapters.CommonAttributes;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableResourceAdapter;
import org.jboss.as.connector.subsystems.resourceadapters.RaOperationUtil;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class RaAdd
extends AbstractAddStepHandler {
    static final RaAdd INSTANCE = new RaAdd();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attribute : CommonAttributes.RESOURCE_ADAPTER_ATTRIBUTE) {
            attribute.validateAndSet(operation, model);
        }
    }

    public void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode address = operation.require("address");
        String name = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        if (!model.hasDefined(Constants.ARCHIVE.getName()) && !model.hasDefined(Constants.MODULE.getName())) {
            throw ConnectorMessages.MESSAGES.archiveOrModuleRequired();
        }
        String archiveOrModuleName = model.get(Constants.ARCHIVE.getName()).isDefined() ? model.get(Constants.ARCHIVE.getName()).asString() : model.get(Constants.MODULE.getName()).asString();
        ModifiableResourceAdapter resourceAdapter = RaOperationUtil.buildResourceAdaptersObject(name, context, operation, archiveOrModuleName);
        if (model.get(Constants.ARCHIVE.getName()).isDefined()) {
            RaOperationUtil.installRaServices(context, verificationHandler, name, resourceAdapter, newControllers);
        } else {
            RaOperationUtil.installRaServicesAndDeployFromModule(context, verificationHandler, name, resourceAdapter, archiveOrModuleName, newControllers);
        }
    }
}

