/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.resourceadapters.deployment.registry;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.logging.ConnectorMessages;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.connector.services.resourceadapters.deployment.registry.ResourceAdapterDeploymentRegistry;

public final class ResourceAdapterDeploymentRegistryImpl
implements ResourceAdapterDeploymentRegistry {
    private Set<ResourceAdapterDeployment> deployments = new HashSet<ResourceAdapterDeployment>();

    @Override
    public void registerResourceAdapterDeployment(ResourceAdapterDeployment deployment) {
        if (deployment == null) {
            throw new IllegalArgumentException(ConnectorMessages.MESSAGES.nullVar("Deployment"));
        }
        ConnectorLogger.DEPLOYMENT_CONNECTOR_REGISTRY_LOGGER.tracef("Adding deployment: %s", deployment);
        this.deployments.add(deployment);
    }

    @Override
    public void unregisterResourceAdapterDeployment(ResourceAdapterDeployment deployment) {
        if (deployment == null) {
            throw new IllegalArgumentException(ConnectorMessages.MESSAGES.nullVar("Deployment"));
        }
        ConnectorLogger.DEPLOYMENT_CONNECTOR_REGISTRY_LOGGER.tracef("Removing deployment: %s", deployment);
        this.deployments.remove(deployment);
    }

    @Override
    public Set<ResourceAdapterDeployment> getResourceAdapterDeployments() {
        return Collections.unmodifiableSet(this.deployments);
    }
}

