/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.jca;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.subsystems.jca.Attribute;
import org.jboss.as.connector.subsystems.jca.Element;
import org.jboss.as.connector.subsystems.jca.JcaArchiveValidationDefinition;
import org.jboss.as.connector.subsystems.jca.JcaBeanValidationDefinition;
import org.jboss.as.connector.subsystems.jca.JcaBootstrapContextDefinition;
import org.jboss.as.connector.subsystems.jca.JcaCachedConnectionManagerDefinition;
import org.jboss.as.connector.subsystems.jca.JcaDistributedWorkManagerDefinition;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemRootDefinition;
import org.jboss.as.connector.subsystems.jca.JcaWorkManagerDefinition;
import org.jboss.as.connector.subsystems.jca.Namespace;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.threads.ThreadsParser;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JcaExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "jca";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 2;
    private static final int MANAGEMENT_API_MINOR_VERSION = 0;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    private static final String RESOURCE_NAME = JcaExtension.class.getPackage().getName() + ".LocalDescriptions";

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, JcaExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        ConnectorLogger.ROOT_LOGGER.debugf("Initializing Connector Extension", new Object[0]);
        boolean registerRuntimeOnly = context.isRuntimeOnlyRegistrationValid();
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 2, 0, 0);
        subsystem.registerSubsystemModel((ResourceDefinition)JcaSubsystemRootDefinition.createInstance(registerRuntimeOnly));
        subsystem.registerXMLElementWriter((XMLElementWriter)ConnectorSubsystemParser.INSTANCE);
        if (context.isRegisterTransformers()) {
            JcaSubsystemRootDefinition.registerTransformers(subsystem);
        }
        System.setProperty("ironjacamar.no_delist_resource_all", "true");
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.JCA_1_0.getUriString(), (XMLElementReader)ConnectorSubsystemParser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.JCA_1_1.getUriString(), (XMLElementReader)ConnectorSubsystemParser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.JCA_2_0.getUriString(), (XMLElementReader)ConnectorSubsystemParser.INSTANCE);
    }

    static final class ConnectorSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        static final ConnectorSubsystemParser INSTANCE = new ConnectorSubsystemParser();

        ConnectorSubsystemParser() {
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
            ModelNode node = context.getModelNode();
            this.writeArchiveValidation(writer, node);
            this.writeBeanValidation(writer, node);
            this.writeWorkManagers(writer, node);
            this.writeDistributedWorkManagers(writer, node);
            this.writeBootstrapContexts(writer, node);
            this.writeCachedConnectionManager(writer, node);
            writer.writeEndElement();
        }

        private void writeArchiveValidation(XMLExtendedStreamWriter writer, ModelNode parentNode) throws XMLStreamException {
            if (parentNode.hasDefined("archive-validation")) {
                ModelNode node = parentNode.get("archive-validation").get("archive-validation");
                if (JcaArchiveValidationDefinition.ArchiveValidationParameters.ARCHIVE_VALIDATION_ENABLED.getAttribute().isMarshallable(node) || JcaArchiveValidationDefinition.ArchiveValidationParameters.ARCHIVE_VALIDATION_FAIL_ON_ERROR.getAttribute().isMarshallable(node) || JcaArchiveValidationDefinition.ArchiveValidationParameters.ARCHIVE_VALIDATION_FAIL_ON_WARN.getAttribute().isMarshallable(node)) {
                    writer.writeEmptyElement(Element.ARCHIVE_VALIDATION.getLocalName());
                    JcaArchiveValidationDefinition.ArchiveValidationParameters.ARCHIVE_VALIDATION_ENABLED.getAttribute().marshallAsAttribute(node, (XMLStreamWriter)writer);
                    JcaArchiveValidationDefinition.ArchiveValidationParameters.ARCHIVE_VALIDATION_FAIL_ON_ERROR.getAttribute().marshallAsAttribute(node, (XMLStreamWriter)writer);
                    JcaArchiveValidationDefinition.ArchiveValidationParameters.ARCHIVE_VALIDATION_FAIL_ON_WARN.getAttribute().marshallAsAttribute(node, (XMLStreamWriter)writer);
                }
            }
        }

        private void writeBeanValidation(XMLExtendedStreamWriter writer, ModelNode parentNode) throws XMLStreamException {
            if (parentNode.hasDefined("bean-validation")) {
                ModelNode node = parentNode.get("bean-validation").get("bean-validation");
                if (JcaBeanValidationDefinition.BeanValidationParameters.BEAN_VALIDATION_ENABLED.getAttribute().isMarshallable(node)) {
                    writer.writeEmptyElement(Element.BEAN_VALIDATION.getLocalName());
                    JcaBeanValidationDefinition.BeanValidationParameters.BEAN_VALIDATION_ENABLED.getAttribute().marshallAsAttribute(node, (XMLStreamWriter)writer);
                }
            }
        }

        private void writeCachedConnectionManager(XMLExtendedStreamWriter writer, ModelNode parentNode) throws XMLStreamException {
            String name;
            ModelNode node;
            if (parentNode.hasDefined("cached-connection-manager") && (node = parentNode.get("cached-connection-manager").get("cached-connection-manager")).hasDefined(name = JcaCachedConnectionManagerDefinition.CcmParameters.INSTALL.getAttribute().getName()) && node.get(name).asBoolean()) {
                writer.writeEmptyElement(Element.CACHED_CONNECTION_MANAGER.getLocalName());
                JcaCachedConnectionManagerDefinition.CcmParameters.DEBUG.getAttribute().marshallAsAttribute(node, (XMLStreamWriter)writer);
                JcaCachedConnectionManagerDefinition.CcmParameters.ERROR.getAttribute().marshallAsAttribute(node, (XMLStreamWriter)writer);
                JcaCachedConnectionManagerDefinition.CcmParameters.IGNORE_UNKNOWN_CONNECTIONS.getAttribute().marshallAsAttribute(node, (XMLStreamWriter)writer);
            }
        }

        private void writeDistributedWorkManagers(XMLExtendedStreamWriter writer, ModelNode parentNode) throws XMLStreamException {
            if (parentNode.hasDefined("distributed-workmanager") && parentNode.get("distributed-workmanager").asList().size() != 0) {
                Object channel = null;
                Object stack = null;
                Object timeout = null;
                for (Property property : parentNode.get("distributed-workmanager").asPropertyList()) {
                    writer.writeStartElement(Element.DISTRIBUTED_WORKMANAGER.getLocalName());
                    ((SimpleAttributeDefinition)JcaDistributedWorkManagerDefinition.DWmParameters.NAME.getAttribute()).marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
                    for (Property prop : property.getValue().asPropertyList()) {
                        if ("long-running-threads".equals(prop.getName()) && prop.getValue().isDefined() && prop.getValue().asPropertyList().size() != 0) {
                            ThreadsParser.getInstance().writeBoundedQueueThreadPool(writer, prop.getValue().asProperty(), Element.LONG_RUNNING_THREADS.getLocalName(), false);
                        }
                        if ("short-running-threads".equals(prop.getName()) && prop.getValue().isDefined() && prop.getValue().asPropertyList().size() != 0) {
                            ThreadsParser.getInstance().writeBoundedQueueThreadPool(writer, prop.getValue().asProperty(), Element.SHORT_RUNNING_THREADS.getLocalName(), false);
                        }
                        if (JcaDistributedWorkManagerDefinition.DWmParameters.POLICY.getAttribute().getName().equals(prop.getName()) && prop.getValue().isDefined()) {
                            writer.writeStartElement(Element.POLICY.getLocalName());
                            writer.writeAttribute(JcaDistributedWorkManagerDefinition.DWmParameters.NAME.getAttribute().getXmlName(), prop.getValue().asString());
                            if (property.getValue().hasDefined(JcaDistributedWorkManagerDefinition.DWmParameters.POLICY_OPTIONS.getAttribute().getName())) {
                                for (Property option : property.getValue().get(JcaDistributedWorkManagerDefinition.DWmParameters.POLICY_OPTIONS.getAttribute().getName()).asPropertyList()) {
                                    this.writeProperty(writer, option.getName(), option.getValue().asString(), Element.OPTION.getLocalName());
                                }
                            }
                            writer.writeEndElement();
                        }
                        if (!JcaDistributedWorkManagerDefinition.DWmParameters.SELECTOR.getAttribute().getName().equals(prop.getName()) || !prop.getValue().isDefined()) continue;
                        writer.writeStartElement(Element.SELECTOR.getLocalName());
                        writer.writeAttribute(JcaDistributedWorkManagerDefinition.DWmParameters.NAME.getAttribute().getXmlName(), prop.getValue().asString());
                        if (property.getValue().hasDefined(JcaDistributedWorkManagerDefinition.DWmParameters.SELECTOR_OPTIONS.getAttribute().getName())) {
                            for (Property option : property.getValue().get(JcaDistributedWorkManagerDefinition.DWmParameters.SELECTOR_OPTIONS.getAttribute().getName()).asPropertyList()) {
                                this.writeProperty(writer, option.getName(), option.getValue().asString(), Element.OPTION.getLocalName());
                            }
                        }
                        writer.writeEndElement();
                    }
                    writer.writeStartElement(Element.TRANSPORT.getLocalName());
                    ((SimpleAttributeDefinition)JcaDistributedWorkManagerDefinition.DWmParameters.TRANSPORT_JGROPUS_STACK.getAttribute()).marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
                    ((SimpleAttributeDefinition)JcaDistributedWorkManagerDefinition.DWmParameters.TRANSPORT_JGROPUS_CLUSTER.getAttribute()).marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
                    ((SimpleAttributeDefinition)JcaDistributedWorkManagerDefinition.DWmParameters.TRANSPORT_REQUEST_TIMEOUT.getAttribute()).marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
                    writer.writeEndElement();
                    writer.writeEndElement();
                }
            }
        }

        private void writeWorkManagers(XMLExtendedStreamWriter writer, ModelNode parentNode) throws XMLStreamException {
            if (parentNode.hasDefined("workmanager") && parentNode.get("workmanager").asList().size() != 0) {
                for (Property property : parentNode.get("workmanager").asPropertyList()) {
                    if ("default".equals(property.getValue().get("name").asString())) {
                        writer.writeStartElement(Element.DEFAULT_WORKMANAGER.getLocalName());
                    } else {
                        writer.writeStartElement(Element.WORKMANAGER.getLocalName());
                        JcaWorkManagerDefinition.WmParameters.NAME.getAttribute().marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
                    }
                    for (Property prop : property.getValue().asPropertyList()) {
                        if ("long-running-threads".equals(prop.getName()) && prop.getValue().isDefined() && prop.getValue().asPropertyList().size() != 0) {
                            ThreadsParser.getInstance().writeBoundedQueueThreadPool(writer, prop.getValue().asProperty(), Element.LONG_RUNNING_THREADS.getLocalName(), false);
                        }
                        if (!"short-running-threads".equals(prop.getName()) || !prop.getValue().isDefined() || prop.getValue().asPropertyList().size() == 0) continue;
                        ThreadsParser.getInstance().writeBoundedQueueThreadPool(writer, prop.getValue().asProperty(), Element.SHORT_RUNNING_THREADS.getLocalName(), false);
                    }
                    writer.writeEndElement();
                }
            }
        }

        private void writeBootstrapContexts(XMLExtendedStreamWriter writer, ModelNode parentNode) throws XMLStreamException {
            if (parentNode.hasDefined("bootstrap-context") && parentNode.get("bootstrap-context").asList().size() != 0) {
                boolean started = false;
                for (Property property : parentNode.get("bootstrap-context").asPropertyList()) {
                    if (property.getValue().get(JcaBootstrapContextDefinition.BootstrapCtxParameters.NAME.getAttribute().getName()).asString().equals("default") || !JcaBootstrapContextDefinition.BootstrapCtxParameters.NAME.getAttribute().isMarshallable(property.getValue()) && !JcaBootstrapContextDefinition.BootstrapCtxParameters.WORKMANAGER.getAttribute().isMarshallable(property.getValue())) continue;
                    if (!started) {
                        writer.writeStartElement(Element.BOOTSTRAP_CONTEXTS.getLocalName());
                        started = true;
                    }
                    writer.writeStartElement(Element.BOOTSTRAP_CONTEXT.getLocalName());
                    JcaBootstrapContextDefinition.BootstrapCtxParameters.NAME.getAttribute().marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
                    JcaBootstrapContextDefinition.BootstrapCtxParameters.WORKMANAGER.getAttribute().marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
                if (started) {
                    writer.writeEndElement();
                }
            }
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ModelNode address = new ModelNode();
            address.add("subsystem", JcaExtension.SUBSYSTEM_NAME);
            address.protect();
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation").set("add");
            subsystem.get("address").set(address);
            list.add(subsystem);
            EnumSet<Element> visited = EnumSet.noneOf(Element.class);
            EnumSet<Element> requiredElement = EnumSet.of(Element.DEFAULT_WORKMANAGER);
            boolean ccmAdded = false;
            block12: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case JCA_2_0: 
                    case JCA_1_1: 
                    case JCA_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        if (!visited.add(element)) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        switch (element) {
                            case ARCHIVE_VALIDATION: {
                                list.add(this.parseArchiveValidation(reader, address));
                                continue block12;
                            }
                            case BEAN_VALIDATION: {
                                list.add(this.parseBeanValidation(reader, address));
                                continue block12;
                            }
                            case DEFAULT_WORKMANAGER: {
                                this.parseWorkManager(reader, address, list, subsystem, true);
                                ModelNode bootstrapContextOperation = new ModelNode();
                                bootstrapContextOperation.get("operation").set("add");
                                ModelNode bootStrapCOntextAddress = address.clone();
                                bootStrapCOntextAddress.add("bootstrap-context", "default");
                                bootStrapCOntextAddress.protect();
                                bootstrapContextOperation.get("address").set(bootStrapCOntextAddress);
                                bootstrapContextOperation.get("workmanager").set("default");
                                bootstrapContextOperation.get("name").set("default");
                                list.add(bootstrapContextOperation);
                                requiredElement.remove((Object)Element.DEFAULT_WORKMANAGER);
                                continue block12;
                            }
                            case CACHED_CONNECTION_MANAGER: {
                                list.add(this.parseCcm(reader, address));
                                ccmAdded = true;
                                continue block12;
                            }
                            case WORKMANAGER: {
                                this.parseWorkManager(reader, address, list, subsystem, false);
                                visited.remove((Object)Element.WORKMANAGER);
                                continue block12;
                            }
                            case DISTRIBUTED_WORKMANAGER: {
                                this.parseDistributedWorkManager(reader, address, list, subsystem, false);
                                visited.remove((Object)Element.DISTRIBUTED_WORKMANAGER);
                                continue block12;
                            }
                            case BOOTSTRAP_CONTEXTS: {
                                this.parseBootstrapContexts(reader, address, list);
                                continue block12;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            if (!requiredElement.isEmpty()) {
                throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, requiredElement);
            }
            if (!ccmAdded) {
                ModelNode ccmOperation = new ModelNode();
                ccmOperation.get("operation").set("add");
                ModelNode ccmAddress = address.clone();
                ccmAddress.add("cached-connection-manager", "cached-connection-manager");
                ccmAddress.protect();
                ccmOperation.get("address").set(ccmAddress);
                list.add(ccmOperation);
            }
        }

        private ModelNode parseArchiveValidation(XMLExtendedStreamReader reader, ModelNode parentOperation) throws XMLStreamException {
            ModelNode archiveValidationOperation = new ModelNode();
            archiveValidationOperation.get("operation").set("add");
            ModelNode archiveValidationAddress = parentOperation.clone();
            archiveValidationAddress.add("archive-validation", "archive-validation");
            archiveValidationAddress.protect();
            archiveValidationOperation.get("address").set(archiveValidationAddress);
            int cnt = reader.getAttributeCount();
            block5: for (int i = 0; i < cnt; ++i) {
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case ENABLED: {
                        String value = this.rawAttributeText((XMLStreamReader)reader, JcaArchiveValidationDefinition.ArchiveValidationParameters.ARCHIVE_VALIDATION_ENABLED.getAttribute().getXmlName());
                        JcaArchiveValidationDefinition.ArchiveValidationParameters.ARCHIVE_VALIDATION_ENABLED.getAttribute().parseAndSetParameter(value, archiveValidationOperation, (XMLStreamReader)reader);
                        continue block5;
                    }
                    case FAIL_ON_ERROR: {
                        String value = this.rawAttributeText((XMLStreamReader)reader, JcaArchiveValidationDefinition.ArchiveValidationParameters.ARCHIVE_VALIDATION_FAIL_ON_ERROR.getAttribute().getXmlName());
                        JcaArchiveValidationDefinition.ArchiveValidationParameters.ARCHIVE_VALIDATION_FAIL_ON_ERROR.getAttribute().parseAndSetParameter(value, archiveValidationOperation, (XMLStreamReader)reader);
                        continue block5;
                    }
                    case FAIL_ON_WARN: {
                        String value = this.rawAttributeText((XMLStreamReader)reader, JcaArchiveValidationDefinition.ArchiveValidationParameters.ARCHIVE_VALIDATION_FAIL_ON_WARN.getAttribute().getXmlName());
                        JcaArchiveValidationDefinition.ArchiveValidationParameters.ARCHIVE_VALIDATION_FAIL_ON_WARN.getAttribute().parseAndSetParameter(value, archiveValidationOperation, (XMLStreamReader)reader);
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            return archiveValidationOperation;
        }

        private void parseWorkManager(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list, ModelNode node, boolean defaultWm) throws XMLStreamException {
            ModelNode workManagerOperation = new ModelNode();
            workManagerOperation.get("operation").set("add");
            int cnt = reader.getAttributeCount();
            String name = null;
            block13: for (int i = 0; i < cnt; ++i) {
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = this.rawAttributeText((XMLStreamReader)reader, JcaWorkManagerDefinition.WmParameters.NAME.getAttribute().getXmlName());
                        JcaWorkManagerDefinition.WmParameters.NAME.getAttribute().parseAndSetParameter(name, workManagerOperation, (XMLStreamReader)reader);
                        continue block13;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                if (defaultWm) {
                    name = "default";
                    workManagerOperation.get("name").set(name);
                } else {
                    throw new XMLStreamException("name attribute is mandatory for workmanager element");
                }
            }
            ModelNode workManagerAddress = parentAddress.clone();
            workManagerAddress.add("workmanager", name);
            workManagerAddress.protect();
            workManagerOperation.get("address").set(workManagerAddress);
            list.add(workManagerOperation);
            block14: while (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                Namespace readerNS = Namespace.forUri(reader.getNamespaceURI());
                switch (element) {
                    case LONG_RUNNING_THREADS: {
                        org.jboss.as.threads.Namespace ns;
                        switch (readerNS) {
                            case JCA_1_0: {
                                ns = org.jboss.as.threads.Namespace.THREADS_1_0;
                                ThreadsParser.getInstance().parseBlockingBoundedQueueThreadPool(reader, readerNS.getUriString(), ns, workManagerAddress, list, "long-running-threads", name);
                                continue block14;
                            }
                        }
                        ns = org.jboss.as.threads.Namespace.THREADS_1_1;
                        ThreadsParser.getInstance().parseBlockingBoundedQueueThreadPool(reader, readerNS.getUriString(), ns, workManagerAddress, list, "long-running-threads", name);
                        continue block14;
                    }
                    case SHORT_RUNNING_THREADS: {
                        org.jboss.as.threads.Namespace ns;
                        switch (readerNS) {
                            case JCA_1_0: {
                                ns = org.jboss.as.threads.Namespace.THREADS_1_0;
                                ThreadsParser.getInstance().parseBlockingBoundedQueueThreadPool(reader, readerNS.getUriString(), ns, workManagerAddress, list, "short-running-threads", name);
                                continue block14;
                            }
                        }
                        ns = org.jboss.as.threads.Namespace.THREADS_1_1;
                        ThreadsParser.getInstance().parseBlockingBoundedQueueThreadPool(reader, readerNS.getUriString(), ns, workManagerAddress, list, "short-running-threads", name);
                        continue block14;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        private void parseDistributedWorkManager(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list, ModelNode node, boolean defaultWm) throws XMLStreamException {
            ModelNode distributedWorkManagerOperation = new ModelNode();
            distributedWorkManagerOperation.get("operation").set("add");
            int cnt = reader.getAttributeCount();
            String name = null;
            block25: for (int i = 0; i < cnt; ++i) {
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = this.rawAttributeText((XMLStreamReader)reader, JcaDistributedWorkManagerDefinition.DWmParameters.NAME.getAttribute().getXmlName());
                        ((SimpleAttributeDefinition)JcaDistributedWorkManagerDefinition.DWmParameters.NAME.getAttribute()).parseAndSetParameter(name, distributedWorkManagerOperation, (XMLStreamReader)reader);
                        continue block25;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                throw ControllerMessages.MESSAGES.missingRequiredAttributes(new StringBuilder(name), reader.getLocation());
            }
            ModelNode distributedWorkManagerAddress = parentAddress.clone();
            distributedWorkManagerAddress.add("distributed-workmanager", name);
            distributedWorkManagerAddress.protect();
            distributedWorkManagerOperation.get("address").set(distributedWorkManagerAddress);
            list.add(distributedWorkManagerOperation);
            block26: while (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                Namespace readerNS = Namespace.forUri(reader.getNamespaceURI());
                switch (element) {
                    case LONG_RUNNING_THREADS: {
                        org.jboss.as.threads.Namespace ns;
                        switch (readerNS) {
                            case JCA_1_0: {
                                ns = org.jboss.as.threads.Namespace.THREADS_1_0;
                                ThreadsParser.getInstance().parseBlockingBoundedQueueThreadPool(reader, readerNS.getUriString(), ns, distributedWorkManagerAddress, list, "long-running-threads", name);
                                continue block26;
                            }
                        }
                        ns = org.jboss.as.threads.Namespace.THREADS_1_1;
                        ThreadsParser.getInstance().parseBlockingBoundedQueueThreadPool(reader, readerNS.getUriString(), ns, distributedWorkManagerAddress, list, "long-running-threads", name);
                        continue block26;
                    }
                    case SHORT_RUNNING_THREADS: {
                        org.jboss.as.threads.Namespace ns;
                        switch (readerNS) {
                            case JCA_1_0: {
                                ns = org.jboss.as.threads.Namespace.THREADS_1_0;
                                ThreadsParser.getInstance().parseBlockingBoundedQueueThreadPool(reader, readerNS.getUriString(), ns, distributedWorkManagerAddress, list, "short-running-threads", name);
                                continue block26;
                            }
                        }
                        ns = org.jboss.as.threads.Namespace.THREADS_1_1;
                        ThreadsParser.getInstance().parseBlockingBoundedQueueThreadPool(reader, readerNS.getUriString(), ns, distributedWorkManagerAddress, list, "short-running-threads", name);
                        continue block26;
                    }
                    case POLICY: {
                        switch (readerNS) {
                            case JCA_2_0: {
                                this.parsePolicy(reader, distributedWorkManagerOperation);
                                continue block26;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    case SELECTOR: {
                        switch (readerNS) {
                            case JCA_2_0: {
                                this.parseSelector(reader, distributedWorkManagerOperation);
                                continue block26;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    case TRANSPORT: {
                        switch (readerNS) {
                            case JCA_2_0: {
                                this.parseTransport(reader, distributedWorkManagerOperation);
                                continue block26;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        private void parsePolicy(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
            int cnt = reader.getAttributeCount();
            block6: for (int i = 0; i < cnt; ++i) {
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        String policy = this.rawAttributeText((XMLStreamReader)reader, attribute.getLocalName());
                        ((SimpleAttributeDefinition)JcaDistributedWorkManagerDefinition.DWmParameters.POLICY.getAttribute()).parseAndSetParameter(policy, operation, (XMLStreamReader)reader);
                        continue block6;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            while (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                Namespace readerNS = Namespace.forUri(reader.getNamespaceURI());
                switch (element) {
                    case OPTION: {
                        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
                        String name = this.rawAttributeText((XMLStreamReader)reader, "name");
                        String value = this.rawElementText((XMLStreamReader)reader);
                        String trimmed = value == null ? null : value.trim();
                        ((PropertiesAttributeDefinition)JcaDistributedWorkManagerDefinition.DWmParameters.POLICY_OPTIONS.getAttribute()).parseAndAddParameterElement(name, trimmed, operation, reader);
                        break;
                    }
                }
            }
        }

        private void parseSelector(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
            int cnt = reader.getAttributeCount();
            block6: for (int i = 0; i < cnt; ++i) {
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        String selector = this.rawAttributeText((XMLStreamReader)reader, attribute.getLocalName());
                        ((SimpleAttributeDefinition)JcaDistributedWorkManagerDefinition.DWmParameters.SELECTOR.getAttribute()).parseAndSetParameter(selector, operation, (XMLStreamReader)reader);
                        continue block6;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            while (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                Namespace readerNS = Namespace.forUri(reader.getNamespaceURI());
                switch (element) {
                    case OPTION: {
                        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
                        String name = this.rawAttributeText((XMLStreamReader)reader, "name");
                        String value = this.rawElementText((XMLStreamReader)reader);
                        String trimmed = value == null ? null : value.trim();
                        ((PropertiesAttributeDefinition)JcaDistributedWorkManagerDefinition.DWmParameters.SELECTOR_OPTIONS.getAttribute()).parseAndAddParameterElement(name, trimmed, operation, reader);
                        break;
                    }
                }
            }
        }

        private void parseTransport(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
            int cnt = reader.getAttributeCount();
            block5: for (int i = 0; i < cnt; ++i) {
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case JGROUPS_STACK: {
                        String value = this.rawAttributeText((XMLStreamReader)reader, JcaDistributedWorkManagerDefinition.DWmParameters.TRANSPORT_JGROPUS_STACK.getAttribute().getXmlName());
                        ((SimpleAttributeDefinition)JcaDistributedWorkManagerDefinition.DWmParameters.TRANSPORT_JGROPUS_STACK.getAttribute()).parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        continue block5;
                    }
                    case JGROUPS_CLUSTER: {
                        String value = this.rawAttributeText((XMLStreamReader)reader, JcaDistributedWorkManagerDefinition.DWmParameters.TRANSPORT_JGROPUS_CLUSTER.getAttribute().getXmlName());
                        ((SimpleAttributeDefinition)JcaDistributedWorkManagerDefinition.DWmParameters.TRANSPORT_JGROPUS_CLUSTER.getAttribute()).parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        continue block5;
                    }
                    case REQUEST_TIMEOUT: {
                        String value = this.rawAttributeText((XMLStreamReader)reader, JcaDistributedWorkManagerDefinition.DWmParameters.TRANSPORT_REQUEST_TIMEOUT.getAttribute().getXmlName());
                        ((SimpleAttributeDefinition)JcaDistributedWorkManagerDefinition.DWmParameters.TRANSPORT_REQUEST_TIMEOUT.getAttribute()).parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        }

        private ModelNode parseBeanValidation(XMLExtendedStreamReader reader, ModelNode parentOperation) throws XMLStreamException {
            ModelNode beanValidationOperation = new ModelNode();
            beanValidationOperation.get("operation").set("add");
            ModelNode beanValidationAddress = parentOperation.clone();
            beanValidationAddress.add("bean-validation", "bean-validation");
            beanValidationAddress.protect();
            beanValidationOperation.get("address").set(beanValidationAddress);
            int cnt = reader.getAttributeCount();
            block3: for (int i = 0; i < cnt; ++i) {
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case ENABLED: {
                        String value = this.rawAttributeText((XMLStreamReader)reader, JcaBeanValidationDefinition.BeanValidationParameters.BEAN_VALIDATION_ENABLED.getAttribute().getXmlName());
                        JcaBeanValidationDefinition.BeanValidationParameters.BEAN_VALIDATION_ENABLED.getAttribute().parseAndSetParameter(value, beanValidationOperation, (XMLStreamReader)reader);
                        continue block3;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            return beanValidationOperation;
        }

        private ModelNode parseCcm(XMLExtendedStreamReader reader, ModelNode parentOperation) throws XMLStreamException {
            ModelNode ccmOperation = new ModelNode();
            ccmOperation.get("operation").set("add");
            ModelNode ccmAddress = parentOperation.clone();
            ccmAddress.add("cached-connection-manager", "cached-connection-manager");
            ccmAddress.protect();
            ccmOperation.get("address").set(ccmAddress);
            int cnt = reader.getAttributeCount();
            block5: for (int i = 0; i < cnt; ++i) {
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case DEBUG: {
                        String value = this.rawAttributeText((XMLStreamReader)reader, JcaCachedConnectionManagerDefinition.CcmParameters.DEBUG.getAttribute().getXmlName());
                        JcaCachedConnectionManagerDefinition.CcmParameters.DEBUG.getAttribute().parseAndSetParameter(value, ccmOperation, (XMLStreamReader)reader);
                        continue block5;
                    }
                    case ERROR: {
                        String value = this.rawAttributeText((XMLStreamReader)reader, JcaCachedConnectionManagerDefinition.CcmParameters.ERROR.getAttribute().getXmlName());
                        JcaCachedConnectionManagerDefinition.CcmParameters.ERROR.getAttribute().parseAndSetParameter(value, ccmOperation, (XMLStreamReader)reader);
                        continue block5;
                    }
                    case IGNORE_UNKNOWN_CONNECHIONS: {
                        String value = this.rawAttributeText((XMLStreamReader)reader, JcaCachedConnectionManagerDefinition.CcmParameters.IGNORE_UNKNOWN_CONNECTIONS.getAttribute().getXmlName());
                        JcaCachedConnectionManagerDefinition.CcmParameters.IGNORE_UNKNOWN_CONNECTIONS.getAttribute().parseAndSetParameter(value, ccmOperation, (XMLStreamReader)reader);
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ccmOperation.get(JcaCachedConnectionManagerDefinition.CcmParameters.INSTALL.getAttribute().getName()).set(true);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            return ccmOperation;
        }

        private void parseBootstrapContexts(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
            block7: while (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case BOOTSTRAP_CONTEXT: {
                        ModelNode bootstrapContextOperation = new ModelNode();
                        bootstrapContextOperation.get("operation").set("add");
                        int cnt = reader.getAttributeCount();
                        String name = null;
                        String wmName = null;
                        block8: for (int i = 0; i < cnt; ++i) {
                            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                            switch (attribute) {
                                case NAME: {
                                    name = this.rawAttributeText((XMLStreamReader)reader, JcaBootstrapContextDefinition.BootstrapCtxParameters.NAME.getAttribute().getXmlName());
                                    JcaBootstrapContextDefinition.BootstrapCtxParameters.NAME.getAttribute().parseAndSetParameter(name, bootstrapContextOperation, (XMLStreamReader)reader);
                                    continue block8;
                                }
                                case WORKMANAGER: {
                                    wmName = this.rawAttributeText((XMLStreamReader)reader, JcaBootstrapContextDefinition.BootstrapCtxParameters.WORKMANAGER.getAttribute().getXmlName());
                                    JcaBootstrapContextDefinition.BootstrapCtxParameters.WORKMANAGER.getAttribute().parseAndSetParameter(wmName, bootstrapContextOperation, (XMLStreamReader)reader);
                                    continue block8;
                                }
                                default: {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                            }
                        }
                        if (name == null) {
                            if ("default".equals(wmName)) {
                                name = "default";
                            } else {
                                throw new XMLStreamException("name attribute is mandatory for workmanager element");
                            }
                        }
                        ModelNode bootstrapContextAddress = parentAddress.clone();
                        bootstrapContextAddress.add("bootstrap-context", name);
                        bootstrapContextAddress.protect();
                        bootstrapContextOperation.get("address").set(bootstrapContextAddress);
                        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                        list.add(bootstrapContextOperation);
                        continue block7;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        public String rawAttributeText(XMLStreamReader reader, String attributeName) {
            String attributeString = reader.getAttributeValue("", attributeName) == null ? null : reader.getAttributeValue("", attributeName).trim();
            return attributeString;
        }

        public String rawElementText(XMLStreamReader reader) throws XMLStreamException {
            String elementText = reader.getElementText();
            elementText = elementText == null || elementText.trim().length() == 0 ? null : elementText.trim();
            return elementText;
        }

        private void writeProperty(XMLExtendedStreamWriter writer, String name, String value, String localName) throws XMLStreamException {
            writer.writeStartElement(localName);
            writer.writeAttribute("name", name);
            writer.writeCharacters(value);
            writer.writeEndElement();
        }
    }
}

