/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.ra;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.resource.ConnectionFactoryDefinition;
import javax.resource.ConnectionFactoryDefinitions;
import javax.resource.spi.TransactionSupport;
import org.jboss.as.connector.deployers.ra.DirectConnectionFactoryInjectionSource;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public class ConnectionFactoryDefinitionAnnotationParser
implements DeploymentUnitProcessor {
    private static final DotName CONNECTION_FACTORY_DEFINITION = DotName.createSimple((String)ConnectionFactoryDefinition.class.getName());
    private static final DotName CONNECTION_FACTORY_DEFINITIONS = DotName.createSimple((String)ConnectionFactoryDefinitions.class.getName());

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        List connectionFactories;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        List connectionFactoryDefinitions = index.getAnnotations(CONNECTION_FACTORY_DEFINITIONS);
        if (connectionFactoryDefinitions != null) {
            for (AnnotationInstance annotation : connectionFactoryDefinitions) {
                AnnotationTarget target = annotation.target();
                if (!(target instanceof ClassInfo)) {
                    throw EeLogger.ROOT_LOGGER.classOnlyAnnotation("@ConnectionFactoryDefinitions", target);
                }
                List<AnnotationInstance> connectionFactories2 = this.getNestedConnectionFactoryAnnotations(annotation);
                for (AnnotationInstance connectionFactory : connectionFactories2) {
                    this.processConnectionFactoryDefinition(eeModuleDescription, connectionFactory, (ClassInfo)target, applicationClasses);
                }
            }
        }
        if ((connectionFactories = index.getAnnotations(CONNECTION_FACTORY_DEFINITION)) != null) {
            for (AnnotationInstance connectionFactory : connectionFactories) {
                AnnotationTarget target = connectionFactory.target();
                if (!(target instanceof ClassInfo)) {
                    throw EeLogger.ROOT_LOGGER.classOnlyAnnotation("@ConnectionFactoryDefinition", target);
                }
                this.processConnectionFactoryDefinition(eeModuleDescription, connectionFactory, (ClassInfo)target, applicationClasses);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void processConnectionFactoryDefinition(EEModuleDescription eeModuleDescription, AnnotationInstance connectionFactoryDefinition, ClassInfo targetClass, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        BindingConfiguration bindingConfiguration = this.getBindingConfiguration(connectionFactoryDefinition);
        EEModuleClassDescription classDescription = eeModuleDescription.addOrGetLocalClassDescription(targetClass.name().toString());
        classDescription.getBindingConfigurations().add(bindingConfiguration);
    }

    private BindingConfiguration getBindingConfiguration(AnnotationInstance connectionFactoryAnnotation) {
        String interfaceClz;
        String name = this.asString(connectionFactoryAnnotation, "name");
        if (name == null || name.isEmpty()) {
            throw EeLogger.ROOT_LOGGER.annotationAttributeMissing("@ConnectionFactoryDefinition", "name");
        }
        if (!name.startsWith("java:")) {
            name = "java:comp/env/" + name;
        }
        if ((interfaceClz = this.asString(connectionFactoryAnnotation, "interfaceName")) == null || interfaceClz.equals(Object.class.getName())) {
            throw EeLogger.ROOT_LOGGER.annotationAttributeMissing("@ConnectionFactoryDefinition", "interfaceValue");
        }
        String ra = this.asString(connectionFactoryAnnotation, "resourceAdapter");
        if (ra == null || ra.equals(Object.class.getName())) {
            throw EeLogger.ROOT_LOGGER.annotationAttributeMissing("@ConnectionFactoryDefinition", "resourceAdapter");
        }
        DirectConnectionFactoryInjectionSource directConnectionFactoryInjectionSource = new DirectConnectionFactoryInjectionSource(name, interfaceClz, ra);
        directConnectionFactoryInjectionSource.setDescription(this.asString(connectionFactoryAnnotation, "description"));
        directConnectionFactoryInjectionSource.setMaxPoolSize(this.asInt(connectionFactoryAnnotation, "maxPoolSize"));
        directConnectionFactoryInjectionSource.setMinPoolSize(this.asInt(connectionFactoryAnnotation, "minPoolSize"));
        directConnectionFactoryInjectionSource.setProperties(this.asArray(connectionFactoryAnnotation, "properties"));
        directConnectionFactoryInjectionSource.setTransactionSupportLevel(this.asTransactionSupportLocal(connectionFactoryAnnotation, "transactionSupport"));
        BindingConfiguration bindingDescription = new BindingConfiguration(name, (InjectionSource)directConnectionFactoryInjectionSource);
        return bindingDescription;
    }

    private int asInt(AnnotationInstance annotation, String string) {
        AnnotationValue value = annotation.value(string);
        return value == null ? -1 : value.asInt();
    }

    private String asString(AnnotationInstance annotation, String property) {
        AnnotationValue value = annotation.value(property);
        return value == null ? null : value.asString();
    }

    private String[] asArray(AnnotationInstance annotation, String property) {
        AnnotationValue value = annotation.value(property);
        return value == null ? null : value.asStringArray();
    }

    private TransactionSupport.TransactionSupportLevel asTransactionSupportLocal(AnnotationInstance annotation, String property) {
        AnnotationValue value = annotation.value(property);
        return value == null ? null : TransactionSupport.TransactionSupportLevel.valueOf((String)((String)value.value()));
    }

    private List<AnnotationInstance> getNestedConnectionFactoryAnnotations(AnnotationInstance connectionFactoryDefinitions) {
        if (connectionFactoryDefinitions == null) {
            return Collections.emptyList();
        }
        AnnotationInstance[] nested = connectionFactoryDefinitions.value().asNestedArray();
        return Arrays.asList(nested);
    }
}

