/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.driver.registry;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.services.driver.InstalledDriver;
import org.jboss.as.connector.services.driver.registry.DriverRegistry;

public class DriverRegistryImpl
implements DriverRegistry {
    private Map<String, InstalledDriver> drivers = new HashMap<String, InstalledDriver>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerInstalledDriver(InstalledDriver driver) throws IllegalArgumentException {
        if (driver == null) {
            throw new IllegalArgumentException(ConnectorLogger.ROOT_LOGGER.nullVar("driver"));
        }
        ConnectorLogger.DEPLOYMENT_CONNECTOR_REGISTRY_LOGGER.tracef("Adding driver: %s", driver);
        Map<String, InstalledDriver> map = this.drivers;
        synchronized (map) {
            this.drivers.put(driver.getDriverName(), driver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterInstalledDriver(InstalledDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException(ConnectorLogger.ROOT_LOGGER.nullVar("driver"));
        }
        ConnectorLogger.DEPLOYMENT_CONNECTOR_REGISTRY_LOGGER.tracef("Removing deployment: %s", driver);
        Map<String, InstalledDriver> map = this.drivers;
        synchronized (map) {
            this.drivers.remove(driver.getDriverName());
        }
    }

    @Override
    public Set<InstalledDriver> getInstalledDrivers() {
        return Collections.unmodifiableSet(Collections.synchronizedSet(new HashSet<InstalledDriver>(this.drivers.values())));
    }

    @Override
    public InstalledDriver getInstalledDriver(String name) {
        return this.drivers.get(name);
    }
}

