/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.resourceadapters.deployment;

import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.spi.ResourceAdapter;
import javax.transaction.TransactionManager;
import javax.validation.ValidatorFactory;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.connector.services.mdr.AS7MetadataRepository;
import org.jboss.as.connector.services.resourceadapters.AdminObjectReferenceFactoryService;
import org.jboss.as.connector.services.resourceadapters.AdminObjectService;
import org.jboss.as.connector.services.resourceadapters.ConnectionFactoryReferenceFactoryService;
import org.jboss.as.connector.services.resourceadapters.ConnectionFactoryService;
import org.jboss.as.connector.services.resourceadapters.deployment.JBossLogPrintWriter;
import org.jboss.as.connector.services.resourceadapters.deployment.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemConfiguration;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.connector.util.Injection;
import org.jboss.as.connector.util.JCAValidatorFactory;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.WritableServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.spec.ConfigProperty;
import org.jboss.jca.common.api.metadata.spec.Connector;
import org.jboss.jca.common.api.metadata.spec.XsdString;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.spi.mdr.AlreadyExistsException;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecovery;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecoveryRegistry;
import org.jboss.jca.deployers.common.AbstractResourceAdapterDeployer;
import org.jboss.jca.deployers.common.BeanValidation;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.logging.BasicLogger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.SubjectFactory;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.manager.action.ClearContextClassLoaderAction;
import org.wildfly.security.manager.action.GetAccessControlContextAction;
import org.wildfly.security.manager.action.SetContextClassLoaderFromClassAction;

public abstract class AbstractResourceAdapterDeploymentService {
    protected ResourceAdapterDeployment value;
    protected final InjectedValue<AS7MetadataRepository> mdr = new InjectedValue();
    protected final InjectedValue<ResourceAdapterRepository> raRepository = new InjectedValue();
    protected final InjectedValue<ResourceAdapterDeploymentRegistry> registry = new InjectedValue();
    protected final InjectedValue<ManagementRepository> managementRepository = new InjectedValue();
    protected final InjectedValue<JcaSubsystemConfiguration> config = new InjectedValue();
    protected final InjectedValue<TransactionIntegration> txInt = new InjectedValue();
    protected final InjectedValue<SubjectFactory> subjectFactory = new InjectedValue();
    protected final InjectedValue<CachedConnectionManager> ccmValue = new InjectedValue();
    protected final InjectedValue<ExecutorService> executorServiceInjector = new InjectedValue();
    protected String raRepositoryRegistrationId;
    protected String connectorServicesRegistrationName;
    protected String mdrRegistrationName;

    public ResourceAdapterDeployment getValue() {
        return ConnectorServices.notNull(this.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAll(String deploymentName) {
        if (this.value != null) {
            XAResourceRecoveryRegistry rr;
            String jndi;
            int i;
            ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debugf("Unregistering: %s", deploymentName);
            if (this.registry != null && this.registry.getValue() != null) {
                ((ResourceAdapterDeploymentRegistry)this.registry.getValue()).unregisterResourceAdapterDeployment(this.value);
            }
            if (this.managementRepository != null && this.managementRepository.getValue() != null && this.value.getDeployment() != null && this.value.getDeployment().getConnector() != null) {
                ((ManagementRepository)this.managementRepository.getValue()).getConnectors().remove(this.value.getDeployment().getConnector());
            }
            if (this.mdr != null && this.mdr.getValue() != null && this.value.getDeployment() != null && this.value.getDeployment().getCfs() != null && this.value.getDeployment().getCfJndiNames() != null) {
                for (i = 0; i < this.value.getDeployment().getCfs().length; ++i) {
                    try {
                        String cf = this.value.getDeployment().getCfs()[i].getClass().getName();
                        jndi = this.value.getDeployment().getCfJndiNames()[i];
                        ((AS7MetadataRepository)this.mdr.getValue()).unregisterJndiMapping(this.value.getDeployment().getURL().toExternalForm(), cf, jndi);
                        continue;
                    }
                    catch (Throwable nfe) {
                        ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debug("Exception during JNDI unbinding", nfe);
                    }
                }
            }
            if (this.mdr != null && this.mdr.getValue() != null && this.value.getDeployment().getAos() != null && this.value.getDeployment().getAoJndiNames() != null) {
                for (i = 0; i < this.value.getDeployment().getAos().length; ++i) {
                    try {
                        String ao = this.value.getDeployment().getAos()[i].getClass().getName();
                        jndi = this.value.getDeployment().getAoJndiNames()[i];
                        ((AS7MetadataRepository)this.mdr.getValue()).unregisterJndiMapping(this.value.getDeployment().getURL().toExternalForm(), ao, jndi);
                        continue;
                    }
                    catch (Throwable nfe) {
                        ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debug("Exception during JNDI unbinding", nfe);
                    }
                }
            }
            if (this.value != null && this.value.getDeployment() != null && this.value.getDeployment().getRecovery() != null && this.txInt != null && this.txInt.getValue() != null && (rr = ((TransactionIntegration)this.txInt.getValue()).getRecoveryRegistry()) != null) {
                for (XAResourceRecovery recovery : this.value.getDeployment().getRecovery()) {
                    if (recovery == null) continue;
                    try {
                        recovery.shutdown();
                    }
                    catch (Exception e) {
                        ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.error("Error during recovery shutdown", e);
                    }
                    finally {
                        rr.removeXAResourceRecovery(recovery);
                    }
                }
            }
            if (this.value.getDeployment() != null && this.value.getDeployment().getConnectionManagers() != null) {
                for (ConnectionManager cm : this.value.getDeployment().getConnectionManagers()) {
                    cm.shutdown();
                }
            }
            if (this.value.getDeployment() != null && this.value.getDeployment().getResourceAdapter() != null) {
                ClassLoader old = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                try {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.value.getDeployment().getResourceAdapter().getClass().getClassLoader());
                    this.value.getDeployment().getResourceAdapter().stop();
                }
                catch (Throwable nfe) {
                    ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.warn("Exception during stopping resource adapter", nfe);
                }
                finally {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)old);
                }
            }
        }
        if (this.raRepositoryRegistrationId != null && this.raRepository != null && this.raRepository.getValue() != null) {
            try {
                ((ResourceAdapterRepository)this.raRepository.getValue()).unregisterResourceAdapter(this.raRepositoryRegistrationId);
            }
            catch (Throwable e) {
                ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debug("Failed to unregister RA from RA Repository", e);
            }
        }
        if (this.connectorServicesRegistrationName != null) {
            try {
                ConnectorServices.unregisterResourceAdapterIdentifier(this.connectorServicesRegistrationName);
            }
            catch (Throwable e) {
                ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debug("Failed to unregister RA from ConnectorServices", e);
            }
        }
        if (this.mdrRegistrationName != null && this.mdr != null && this.mdr.getValue() != null) {
            try {
                ((AS7MetadataRepository)this.mdr.getValue()).unregisterResourceAdapter(this.mdrRegistrationName);
            }
            catch (Throwable e) {
                ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debug("Failed to unregister RA from MDR", e);
            }
        }
    }

    public Injector<AS7MetadataRepository> getMdrInjector() {
        return this.mdr;
    }

    public Injector<ResourceAdapterRepository> getRaRepositoryInjector() {
        return this.raRepository;
    }

    public Injector<ManagementRepository> getManagementRepositoryInjector() {
        return this.managementRepository;
    }

    public Injector<ResourceAdapterDeploymentRegistry> getRegistryInjector() {
        return this.registry;
    }

    public InjectedValue<JcaSubsystemConfiguration> getConfig() {
        return this.config;
    }

    public InjectedValue<TransactionIntegration> getTxIntegration() {
        return this.txInt;
    }

    public Injector<TransactionIntegration> getTxIntegrationInjector() {
        return this.txInt;
    }

    public Injector<JcaSubsystemConfiguration> getConfigInjector() {
        return this.config;
    }

    public Injector<SubjectFactory> getSubjectFactoryInjector() {
        return this.subjectFactory;
    }

    public Injector<CachedConnectionManager> getCcmInjector() {
        return this.ccmValue;
    }

    public Injector<ExecutorService> getExecutorServiceInjector() {
        return this.executorServiceInjector;
    }

    protected final ExecutorService getLifecycleExecutorService() {
        ExecutorService result = (ExecutorService)this.executorServiceInjector.getOptionalValue();
        if (result == null) {
            ThreadGroup threadGroup = new ThreadGroup("ResourceAdapterDeploymentService ThreadGroup");
            String namePattern = "ResourceAdapterDeploymentService Thread Pool -- %t";
            JBossThreadFactory threadFactory = new JBossThreadFactory(threadGroup, Boolean.FALSE, null, "ResourceAdapterDeploymentService Thread Pool -- %t", null, null, (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance()));
            result = Executors.newSingleThreadExecutor((ThreadFactory)threadFactory);
        }
        return result;
    }

    public ContextNames.BindInfo getBindInfo(String jndi) {
        return ContextNames.bindInfoFor((String)jndi);
    }

    public boolean isCreateBinderService() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void cleanupStartAsync(final StartContext context, final String deploymentName, final ServiceName serviceName, final Throwable cause) {
        ExecutorService executorService = this.getLifecycleExecutorService();
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    WritableServiceBasedNamingStore.pushOwner((ServiceName)serviceName);
                    AbstractResourceAdapterDeploymentService.this.unregisterAll(deploymentName);
                }
                finally {
                    WritableServiceBasedNamingStore.popOwner();
                    context.failed(ConnectorLogger.ROOT_LOGGER.failedToStartRaDeployment(cause, deploymentName));
                }
            }
        };
        try {
            executorService.execute(r);
        }
        catch (RejectedExecutionException e) {
            r.run();
        }
        finally {
            context.asynchronous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopAsync(final StopContext context, final String deploymentName, final ServiceName serviceName) {
        ExecutorService executorService = this.getLifecycleExecutorService();
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debugf("Stopping service %s", serviceName);
                    WritableServiceBasedNamingStore.pushOwner((ServiceName)serviceName);
                    AbstractResourceAdapterDeploymentService.this.unregisterAll(deploymentName);
                }
                finally {
                    WritableServiceBasedNamingStore.popOwner();
                    context.complete();
                }
            }
        };
        try {
            executorService.execute(r);
        }
        catch (RejectedExecutionException e) {
            r.run();
        }
        finally {
            context.asynchronous();
        }
    }

    protected abstract class AbstractAS7RaDeployer
    extends AbstractResourceAdapterDeployer {
        protected final ServiceTarget serviceTarget;
        protected final URL url;
        protected final String deploymentName;
        protected final File root;
        protected final ClassLoader cl;
        protected final Connector cmd;
        protected final ServiceName deploymentServiceName;

        protected AbstractAS7RaDeployer(ServiceTarget serviceTarget, URL url, String deploymentName, File root, ClassLoader cl, Connector cmd, ServiceName deploymentServiceName) {
            super(true);
            this.serviceTarget = serviceTarget;
            this.url = url;
            this.deploymentName = deploymentName;
            this.root = root;
            this.cl = cl;
            this.cmd = cmd;
            this.deploymentServiceName = deploymentServiceName;
        }

        public abstract CommonDeployment doDeploy() throws Throwable;

        public String[] bindConnectionFactory(URL url, String deployment, Object cf) throws Throwable {
            throw ConnectorLogger.ROOT_LOGGER.jndiBindingsNotSupported();
        }

        public String[] bindConnectionFactory(URL url, String deployment, Object cf, final String jndi) throws Throwable {
            ((AS7MetadataRepository)AbstractResourceAdapterDeploymentService.this.mdr.getValue()).registerJndiMapping(url.toExternalForm(), cf.getClass().getName(), jndi);
            ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.registeredConnectionFactory(jndi);
            ConnectionFactoryService connectionFactoryService = new ConnectionFactoryService(cf);
            ServiceName connectionFactoryServiceName = ConnectionFactoryService.SERVICE_NAME_BASE.append(new String[]{jndi});
            ServiceBuilder connectionFactoryBuilder = this.serviceTarget.addService(connectionFactoryServiceName, (Service)connectionFactoryService);
            if (this.deploymentServiceName != null) {
                connectionFactoryBuilder.addDependency(this.deploymentServiceName);
            }
            connectionFactoryBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
            ContextNames.BindInfo bindInfo = AbstractResourceAdapterDeploymentService.this.getBindInfo(jndi);
            ConnectionFactoryReferenceFactoryService referenceFactoryService = new ConnectionFactoryReferenceFactoryService();
            ServiceName referenceFactoryServiceName = ConnectionFactoryReferenceFactoryService.SERVICE_NAME_BASE.append(bindInfo.getBinderServiceName());
            this.serviceTarget.addService(referenceFactoryServiceName, (Service)referenceFactoryService).addDependency(connectionFactoryServiceName, Object.class, referenceFactoryService.getConnectionFactoryInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
            if (AbstractResourceAdapterDeploymentService.this.isCreateBinderService()) {
                BinderService binderService = new BinderService(bindInfo.getBindName());
                this.serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, (Injector)binderService.getManagedObjectInjector()).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector()).addListener((ServiceListener)new AbstractServiceListener<Object>(){

                    public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
                        switch (transition) {
                            case STARTING_to_UP: {
                                ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.boundJca("ConnectionFactory", jndi);
                                break;
                            }
                            case STOPPING_to_DOWN: {
                                ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.unboundJca("ConnectionFactory", jndi);
                                break;
                            }
                            case REMOVING_to_REMOVED: {
                                ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debugf("Removed JCA ConnectionFactory [%s]", jndi);
                            }
                        }
                    }
                }).setInitialMode(ServiceController.Mode.ACTIVE).install();
            }
            if (cf instanceof Referenceable) {
                ((Referenceable)cf).setReference(new Reference(jndi));
            }
            return new String[]{jndi};
        }

        public String[] bindAdminObject(URL url, String deployment, Object ao) throws Throwable {
            throw ConnectorLogger.ROOT_LOGGER.jndiBindingsNotSupported();
        }

        public String[] bindAdminObject(URL url, String deployment, Object ao, final String jndi) throws Throwable {
            ((AS7MetadataRepository)AbstractResourceAdapterDeploymentService.this.mdr.getValue()).registerJndiMapping(url.toExternalForm(), ao.getClass().getName(), jndi);
            ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.registeredAdminObject(jndi);
            AdminObjectService adminObjectService = new AdminObjectService(ao);
            ServiceName adminObjectServiceName = AdminObjectService.SERVICE_NAME_BASE.append(new String[]{jndi});
            this.serviceTarget.addService(adminObjectServiceName, (Service)adminObjectService).setInitialMode(ServiceController.Mode.ACTIVE).install();
            ContextNames.BindInfo bindInfo = AbstractResourceAdapterDeploymentService.this.getBindInfo(jndi);
            AdminObjectReferenceFactoryService referenceFactoryService = new AdminObjectReferenceFactoryService();
            ServiceName referenceFactoryServiceName = AdminObjectReferenceFactoryService.SERVICE_NAME_BASE.append(bindInfo.getBinderServiceName());
            this.serviceTarget.addService(referenceFactoryServiceName, (Service)referenceFactoryService).addDependency(adminObjectServiceName, Object.class, referenceFactoryService.getAdminObjectInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
            if (AbstractResourceAdapterDeploymentService.this.isCreateBinderService()) {
                BinderService binderService = new BinderService(bindInfo.getBindName());
                ServiceName binderServiceName = bindInfo.getBinderServiceName();
                this.serviceTarget.addService(binderServiceName, (Service)binderService).addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, (Injector)binderService.getManagedObjectInjector()).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector()).addListener((ServiceListener)new AbstractServiceListener<Object>(){

                    public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
                        switch (transition) {
                            case STARTING_to_UP: {
                                ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.boundJca("AdminObject", jndi);
                                break;
                            }
                            case STOPPING_to_DOWN: {
                                ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.unboundJca("AdminObject", jndi);
                                break;
                            }
                            case REMOVING_to_REMOVED: {
                                ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debugf("Removed JCA AdminObject [%s]", jndi);
                            }
                        }
                    }
                }).setInitialMode(ServiceController.Mode.ACTIVE).install();
            }
            if (ao instanceof Referenceable) {
                ((Referenceable)ao).setReference(new Reference(jndi));
            }
            return new String[]{jndi};
        }

        protected abstract boolean checkActivation(Connector var1, Activation var2);

        protected boolean checkConfigurationIsValid() {
            return this.getConfiguration() != null;
        }

        protected PrintWriter getLogPrintWriter() {
            return new JBossLogPrintWriter(this.deploymentName, (BasicLogger)this.log);
        }

        protected File getReportDirectory() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected TransactionManager getTransactionManager() {
            if (!WildFlySecurityManager.isChecking()) {
                Thread.currentThread().setContextClassLoader(TransactionIntegration.class.getClassLoader());
            } else {
                AccessController.doPrivileged(new SetContextClassLoaderFromClassAction(TransactionIntegration.class));
            }
            try {
                TransactionManager transactionManager = ((TransactionIntegration)AbstractResourceAdapterDeploymentService.this.getTxIntegration().getValue()).getTransactionManager();
                return transactionManager;
            }
            finally {
                if (!WildFlySecurityManager.isChecking()) {
                    Thread.currentThread().setContextClassLoader(null);
                } else {
                    AccessController.doPrivileged(ClearContextClassLoaderAction.getInstance());
                }
            }
        }

        public Object initAndInject(String className, List<? extends ConfigProperty> configs, ClassLoader cl) throws DeployException {
            try {
                Class<?> clz = Class.forName(className, true, cl);
                Object o = clz.newInstance();
                if (configs != null) {
                    Injection injector = new Injection();
                    for (ConfigProperty configProperty : configs) {
                        if (!configProperty.isValueSet()) continue;
                        if (XsdString.isNull((XsdString)configProperty.getConfigPropertyType())) {
                            injector.inject(o, configProperty.getConfigPropertyName().getValue(), configProperty.getConfigPropertyValue().getValue());
                            continue;
                        }
                        injector.inject(o, configProperty.getConfigPropertyName().getValue(), configProperty.getConfigPropertyValue().getValue(), configProperty.getConfigPropertyType().getValue());
                    }
                }
                return o;
            }
            catch (Throwable t) {
                throw ConnectorLogger.ROOT_LOGGER.deploymentFailed(t, className);
            }
        }

        protected void registerResourceAdapterToMDR(URL url, File file, Connector connector, Activation ij) throws AlreadyExistsException {
            ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debugf("Registering ResourceAdapter %s", this.deploymentName);
            ((AS7MetadataRepository)AbstractResourceAdapterDeploymentService.this.mdr.getValue()).registerResourceAdapter(this.deploymentName, file, connector, ij);
            AbstractResourceAdapterDeploymentService.this.mdrRegistrationName = this.deploymentName;
        }

        protected String registerResourceAdapterToResourceAdapterRepository(ResourceAdapter instance) {
            AbstractResourceAdapterDeploymentService.this.raRepositoryRegistrationId = ((ResourceAdapterRepository)AbstractResourceAdapterDeploymentService.this.raRepository.getValue()).registerResourceAdapter(instance);
            if (AbstractResourceAdapterDeploymentService.this.connectorServicesRegistrationName != null) {
                ConnectorServices.registerResourceAdapterIdentifier(AbstractResourceAdapterDeploymentService.this.connectorServicesRegistrationName, AbstractResourceAdapterDeploymentService.this.raRepositoryRegistrationId);
            }
            return AbstractResourceAdapterDeploymentService.this.raRepositoryRegistrationId;
        }

        protected SubjectFactory getSubjectFactory(String securityDomain) throws DeployException {
            if (securityDomain == null || securityDomain.trim().equals("")) {
                return null;
            }
            return (SubjectFactory)AbstractResourceAdapterDeploymentService.this.subjectFactory.getValue();
        }

        protected TransactionIntegration getTransactionIntegration() {
            return (TransactionIntegration)AbstractResourceAdapterDeploymentService.this.getTxIntegration().getValue();
        }

        protected CachedConnectionManager getCachedConnectionManager() {
            return (CachedConnectionManager)AbstractResourceAdapterDeploymentService.this.ccmValue.getValue();
        }

        protected String buildJndiName(String rawJndiName, Boolean javaContext) {
            String jndiName = !rawJndiName.startsWith("java:") ? (rawJndiName.startsWith("jboss/") ? "java:" + rawJndiName : "java:/" + rawJndiName) : rawJndiName;
            return jndiName;
        }

        protected BeanValidation getBeanValidation() {
            return new BeanValidation((ValidatorFactory)new JCAValidatorFactory(this.cl));
        }
    }
}

