/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.HashMap;
import java.util.Map;

public enum Namespace {
    UNKNOWN(null),
    DATASOURCES_1_0("urn:jboss:domain:datasources:1.0"),
    DATASOURCES_1_1("urn:jboss:domain:datasources:1.1"),
    DATASOURCES_2_0("urn:jboss:domain:datasources:2.0"),
    DATASOURCES_3_0("urn:jboss:domain:datasources:3.0");

    public static final Namespace CURRENT;
    private final String name;
    private static final Map<String, Namespace> MAP;

    private Namespace(String name) {
        this.name = name;
    }

    public String getUriString() {
        return this.name;
    }

    public static Namespace forUri(String uri) {
        Namespace element = MAP.get(uri);
        return element == null ? UNKNOWN : element;
    }

    static {
        CURRENT = DATASOURCES_3_0;
        HashMap<String, Namespace> map = new HashMap<String, Namespace>();
        for (Namespace namespace : Namespace.values()) {
            String name = namespace.getUriString();
            if (name == null) continue;
            map.put(name, namespace);
        }
        MAP = map;
    }
}

