/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.List;
import java.util.Map;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.subsystems.common.pool.PoolConfigurationRWHandler;
import org.jboss.as.connector.subsystems.common.pool.PoolOperations;
import org.jboss.as.connector.subsystems.datasources.ConnectionPropertyDefinition;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.DataSourceDisable;
import org.jboss.as.connector.subsystems.datasources.DataSourceEnable;
import org.jboss.as.connector.subsystems.datasources.DataSourcesExtension;
import org.jboss.as.connector.subsystems.datasources.DisableRequiredWriteAttributeHandler;
import org.jboss.as.connector.subsystems.datasources.XMLXaDataSourceRuntimeHandler;
import org.jboss.as.connector.subsystems.datasources.XaDataSourceAdd;
import org.jboss.as.connector.subsystems.datasources.XaDataSourcePropertyDefinition;
import org.jboss.as.connector.subsystems.datasources.XaDataSourceRemove;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;

public class XaDataSourceDefinition
extends SimpleResourceDefinition {
    protected static final PathElement PATH_XA_DATASOURCE = PathElement.pathElement((String)"xa-data-source");
    private final boolean registerRuntimeOnly;
    private final boolean deployed;
    private final List<AccessConstraintDefinition> accessConstraints;

    private XaDataSourceDefinition(boolean registerRuntimeOnly, boolean deployed) {
        super(PATH_XA_DATASOURCE, (ResourceDescriptionResolver)DataSourcesExtension.getResourceDescriptionResolver("xa-data-source"), (OperationStepHandler)(deployed ? null : XaDataSourceAdd.INSTANCE), (OperationStepHandler)(deployed ? null : XaDataSourceRemove.INSTANCE));
        this.registerRuntimeOnly = registerRuntimeOnly;
        this.deployed = deployed;
        ApplicationTypeConfig atc = new ApplicationTypeConfig("datasources", "xa-data-source");
        this.accessConstraints = new ApplicationTypeAccessConstraintDefinition(atc).wrapAsList();
    }

    public static XaDataSourceDefinition createInstance(boolean registerRuntimeOnly, boolean deployed) {
        return new XaDataSourceDefinition(registerRuntimeOnly, deployed);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (!this.deployed) {
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.DATASOURCE_ENABLE, (OperationStepHandler)DataSourceEnable.XA_INSTANCE);
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.DATASOURCE_DISABLE, (OperationStepHandler)DataSourceDisable.XA_INSTANCE);
        }
        if (this.registerRuntimeOnly) {
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.FLUSH_IDLE_CONNECTION, (OperationStepHandler)PoolOperations.FlushIdleConnectionInPool.DS_INSTANCE);
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.FLUSH_ALL_CONNECTION, (OperationStepHandler)PoolOperations.FlushAllConnectionInPool.DS_INSTANCE);
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.DUMP_QUEUED_THREADS, (OperationStepHandler)PoolOperations.DumpQueuedThreadInPool.DS_INSTANCE);
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.FLUSH_INVALID_CONNECTION, (OperationStepHandler)PoolOperations.FlushInvalidConnectionInPool.DS_INSTANCE);
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.FLUSH_GRACEFULLY_CONNECTION, (OperationStepHandler)PoolOperations.FlushGracefullyConnectionInPool.DS_INSTANCE);
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.TEST_CONNECTION, (OperationStepHandler)PoolOperations.TestConnectionInPool.DS_INSTANCE);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        if (this.deployed) {
            SimpleAttributeDefinition runtimeAttribute;
            for (SimpleAttributeDefinition simpleAttributeDefinition : Constants.XA_DATASOURCE_ATTRIBUTE) {
                runtimeAttribute = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(simpleAttributeDefinition).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
                resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)runtimeAttribute, (OperationStepHandler)XMLXaDataSourceRuntimeHandler.INSTANCE);
            }
            for (SimpleAttributeDefinition simpleAttributeDefinition : Constants.XA_DATASOURCE_PROPERTIES_ATTRIBUTES) {
                runtimeAttribute = ((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder((PropertiesAttributeDefinition)simpleAttributeDefinition).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
                resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)runtimeAttribute, (OperationStepHandler)XMLXaDataSourceRuntimeHandler.INSTANCE);
            }
        } else {
            void var5_13;
            DisableRequiredWriteAttributeHandler disableRequiredWriteHandler = new DisableRequiredWriteAttributeHandler((AttributeDefinition[])Constants.XA_DATASOURCE_ATTRIBUTE);
            SimpleAttributeDefinition[] arr$ = Constants.XA_DATASOURCE_ATTRIBUTE;
            int len$ = arr$.length;
            boolean bl = false;
            while (var5_13 < len$) {
                SimpleAttributeDefinition attribute = arr$[var5_13];
                if (PoolConfigurationRWHandler.ATTRIBUTES.contains(attribute.getName())) {
                    resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, (OperationStepHandler)PoolConfigurationRWHandler.PoolConfigurationReadHandler.INSTANCE, (OperationStepHandler)PoolConfigurationRWHandler.LocalAndXaDataSourcePoolConfigurationWriteHandler.INSTANCE);
                } else if (attribute.equals(Constants.STATISTICS_ENABLED)) {
                    resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[0]));
                } else {
                    resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, null, (OperationStepHandler)disableRequiredWriteHandler);
                }
                ++var5_13;
            }
            DisableRequiredWriteAttributeHandler disableRequiredPropertiesWriteHandler = new DisableRequiredWriteAttributeHandler((AttributeDefinition[])Constants.XA_DATASOURCE_PROPERTIES_ATTRIBUTES);
            for (PropertiesAttributeDefinition attribute : Constants.XA_DATASOURCE_PROPERTIES_ATTRIBUTES) {
                if (PoolConfigurationRWHandler.ATTRIBUTES.contains(attribute.getName())) {
                    resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, (OperationStepHandler)PoolConfigurationRWHandler.PoolConfigurationReadHandler.INSTANCE, (OperationStepHandler)PoolConfigurationRWHandler.LocalAndXaDataSourcePoolConfigurationWriteHandler.INSTANCE);
                    continue;
                }
                resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, null, (OperationStepHandler)disableRequiredPropertiesWriteHandler);
            }
        }
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        if (this.deployed) {
            resourceRegistration.registerSubModel((ResourceDefinition)XaDataSourcePropertyDefinition.DEPLOYED_INSTANCE);
        } else {
            resourceRegistration.registerSubModel((ResourceDefinition)XaDataSourcePropertyDefinition.INSTANCE);
        }
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }

    static void registerTransformers110(ResourceTransformationDescriptionBuilder parentBuilder) {
        ResourceTransformationDescriptionBuilder builder = ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)parentBuilder.addChildResource(PATH_XA_DATASOURCE).getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_PROPERTIES, Constants.CONNECTION_LISTENER_CLASS, Constants.CONNECTION_LISTENER_PROPERTIES, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_PROPERTIES, org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(false)}), new AttributeDefinition[]{Constants.CONNECTABLE})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, false, new ModelNode[]{new ModelNode(true)}), new AttributeDefinition[]{Constants.STATISTICS_ENABLED})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{Constants.TRACKING})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.DefaultRejectAttributeChecker(){

            public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
                return ConnectorLogger.ROOT_LOGGER.rejectAttributesMustBeTrue(attributes.keySet());
            }

            protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                return !attributeValue.isDefined() || !attributeValue.asString().equals("true");
            }
        }, new AttributeDefinition[]{Constants.STATISTICS_ENABLED})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_PROPERTIES, Constants.CONNECTION_LISTENER_CLASS, Constants.CONNECTION_LISTENER_PROPERTIES, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_PROPERTIES, org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE, Constants.URL_PROPERTY, Constants.CONNECTABLE, Constants.TRACKING})).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, (AttributeDefinition[])Constants.DATASOURCE_PROPERTIES_ATTRIBUTES)).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{Constants.ENABLED})).end().addOperationTransformationOverride("write-attribute").inheritResourceAttributeDefinitions().setCustomOperationTransformer(Constants.ENABLE_TRANSFORMER).end().addOperationTransformationOverride("undefine-attribute").inheritResourceAttributeDefinitions().setCustomOperationTransformer(Constants.ENABLE_TRANSFORMER).end().addOperationTransformationOverride("add").inheritResourceAttributeDefinitions().setCustomOperationTransformer(Constants.ENABLE_ADD_TRANSFORMER).end().addOperationTransformationOverride(Constants.DATASOURCE_ENABLE.getName()).end().addOperationTransformationOverride(Constants.DATASOURCE_DISABLE.getName()).end();
        ConnectionPropertyDefinition.registerTransformers11x(builder);
    }

    static void registerTransformers111(ResourceTransformationDescriptionBuilder parentBuilder) {
        ResourceTransformationDescriptionBuilder builder = parentBuilder.addChildResource(PATH_XA_DATASOURCE);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_PROPERTIES, Constants.CONNECTION_LISTENER_CLASS, Constants.CONNECTION_LISTENER_PROPERTIES, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS, Constants.CONNECTION_PROPERTIES, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_PROPERTIES, org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(false)}), new AttributeDefinition[]{Constants.CONNECTABLE})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, false, new ModelNode[]{new ModelNode(true)}), new AttributeDefinition[]{Constants.STATISTICS_ENABLED})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{Constants.TRACKING})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.DefaultRejectAttributeChecker(){

            public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
                return ConnectorLogger.ROOT_LOGGER.rejectAttributesMustBeTrue(attributes.keySet());
            }

            protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                return !attributeValue.isDefined() || !attributeValue.asString().equals("true");
            }
        }, new AttributeDefinition[]{Constants.STATISTICS_ENABLED})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_PROPERTIES, Constants.CONNECTION_LISTENER_CLASS, Constants.CONNECTION_LISTENER_PROPERTIES, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS, Constants.CONNECTION_PROPERTIES, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_PROPERTIES, org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE, Constants.URL_PROPERTY, Constants.CONNECTABLE, Constants.TRACKING})).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{Constants.ENABLED})).end().addOperationTransformationOverride("write-attribute").inheritResourceAttributeDefinitions().setCustomOperationTransformer(Constants.ENABLE_TRANSFORMER).end().addOperationTransformationOverride("undefine-attribute").inheritResourceAttributeDefinitions().setCustomOperationTransformer(Constants.ENABLE_TRANSFORMER).end().addOperationTransformationOverride("add").inheritResourceAttributeDefinitions().setCustomOperationTransformer(Constants.ENABLE_ADD_TRANSFORMER).end().addOperationTransformationOverride(Constants.DATASOURCE_ENABLE.getName()).end().addOperationTransformationOverride(Constants.DATASOURCE_DISABLE.getName()).end();
        ConnectionPropertyDefinition.registerTransformers11x(builder);
    }

    static void registerTransformers200(ResourceTransformationDescriptionBuilder parentBuilder) {
        ResourceTransformationDescriptionBuilder builder = parentBuilder.addChildResource(PATH_XA_DATASOURCE);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(false)}), new AttributeDefinition[]{Constants.CONNECTABLE})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, false, new ModelNode[]{new ModelNode(true)}), new AttributeDefinition[]{Constants.STATISTICS_ENABLED})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.DefaultRejectAttributeChecker(){

            public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
                return ConnectorLogger.ROOT_LOGGER.rejectAttributesMustBeTrue(attributes.keySet());
            }

            protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                return !attributeValue.isDefined() || !attributeValue.asString().equals("true");
            }
        }, new AttributeDefinition[]{Constants.STATISTICS_ENABLED})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{Constants.TRACKING})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Constants.TRACKING})).end().addOperationTransformationOverride(Constants.DATASOURCE_ENABLE.getName()).end().addOperationTransformationOverride(Constants.DATASOURCE_DISABLE.getName()).end();
    }
}

