/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.jca;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.services.workmanager.DistributedWorkManagerService;
import org.jboss.as.connector.services.workmanager.NamedDistributedWorkManager;
import org.jboss.as.connector.subsystems.jca.JcaDistributedWorkManagerDefinition;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.connector.util.Injection;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.api.workmanager.DistributedWorkManager;
import org.jboss.jca.core.spi.workmanager.policy.Policy;
import org.jboss.jca.core.spi.workmanager.selector.Selector;
import org.jboss.jca.core.workmanager.policy.Always;
import org.jboss.jca.core.workmanager.policy.Never;
import org.jboss.jca.core.workmanager.policy.WaterMark;
import org.jboss.jca.core.workmanager.selector.FirstAvailable;
import org.jboss.jca.core.workmanager.selector.MaxFreeThreads;
import org.jboss.jca.core.workmanager.selector.PingTime;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.tm.JBossXATerminator;

public class DistributedWorkManagerAdd
extends AbstractAddStepHandler {
    public static final DistributedWorkManagerAdd INSTANCE = new DistributedWorkManagerAdd();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (JcaDistributedWorkManagerDefinition.DWmParameters parameter : JcaDistributedWorkManagerDefinition.DWmParameters.values()) {
            parameter.getAttribute().validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        Injection injector;
        String name = JcaDistributedWorkManagerDefinition.DWmParameters.NAME.getAttribute().resolveModelAttribute(context, model).asString();
        String policy = JcaDistributedWorkManagerDefinition.DWmParameters.POLICY.getAttribute().resolveModelAttribute(context, model).asString();
        String selector = JcaDistributedWorkManagerDefinition.DWmParameters.SELECTOR.getAttribute().resolveModelAttribute(context, model).asString();
        ServiceTarget serviceTarget = context.getServiceTarget();
        NamedDistributedWorkManager namedDistributedWorkManager = new NamedDistributedWorkManager(name);
        if (policy != null && !policy.trim().isEmpty()) {
            switch (JcaDistributedWorkManagerDefinition.PolicyValue.valueOf(policy)) {
                case NEVER: {
                    namedDistributedWorkManager.setPolicy((Policy)new Never());
                    break;
                }
                case ALWAYS: {
                    namedDistributedWorkManager.setPolicy((Policy)new Always());
                    break;
                }
                case WATERMARK: {
                    namedDistributedWorkManager.setPolicy((Policy)new WaterMark());
                    break;
                }
                default: {
                    throw ConnectorLogger.ROOT_LOGGER.unsupportedPolicy(policy);
                }
            }
            injector = new Injection();
            for (Map.Entry entry : ((PropertiesAttributeDefinition)JcaDistributedWorkManagerDefinition.DWmParameters.POLICY_OPTIONS.getAttribute()).unwrap(context, model).entrySet()) {
                try {
                    injector.inject(namedDistributedWorkManager.getPolicy(), (String)entry.getKey(), entry.getValue());
                }
                catch (Exception e) {
                    ConnectorLogger.ROOT_LOGGER.unsupportedPolicyOption((String)entry.getKey());
                }
            }
        } else {
            namedDistributedWorkManager.setPolicy((Policy)new WaterMark());
        }
        if (selector != null && !selector.trim().isEmpty()) {
            switch (JcaDistributedWorkManagerDefinition.SelectorValue.valueOf(selector)) {
                case FIRST_AVAILABLE: {
                    namedDistributedWorkManager.setSelector((Selector)new FirstAvailable());
                    break;
                }
                case MAX_FREE_THREADS: {
                    namedDistributedWorkManager.setSelector((Selector)new MaxFreeThreads());
                    break;
                }
                case PING_TIME: {
                    namedDistributedWorkManager.setSelector((Selector)new PingTime());
                    break;
                }
                default: {
                    throw ConnectorLogger.ROOT_LOGGER.unsupportedSelector(selector);
                }
            }
            injector = new Injection();
            for (Map.Entry entry : ((PropertiesAttributeDefinition)JcaDistributedWorkManagerDefinition.DWmParameters.SELECTOR_OPTIONS.getAttribute()).unwrap(context, model).entrySet()) {
                try {
                    injector.inject(namedDistributedWorkManager.getSelector(), (String)entry.getKey(), entry.getValue());
                }
                catch (Exception e) {
                    ConnectorLogger.ROOT_LOGGER.unsupportedSelectorOption((String)entry.getKey());
                }
            }
        } else {
            namedDistributedWorkManager.setSelector((Selector)new PingTime());
        }
        String jgroupsStack = model.hasDefined(JcaDistributedWorkManagerDefinition.DWmParameters.TRANSPORT_JGROPUS_STACK.getAttribute().getName()) ? JcaDistributedWorkManagerDefinition.DWmParameters.TRANSPORT_JGROPUS_STACK.getAttribute().resolveModelAttribute(context, model).asString() : "udp";
        String channelName = JcaDistributedWorkManagerDefinition.DWmParameters.TRANSPORT_JGROPUS_CLUSTER.getAttribute().resolveModelAttribute(context, model).asString();
        Long requestTimeout = JcaDistributedWorkManagerDefinition.DWmParameters.TRANSPORT_REQUEST_TIMEOUT.getAttribute().resolveModelAttribute(context, model).asLong();
        DistributedWorkManagerService wmService = new DistributedWorkManagerService((DistributedWorkManager)namedDistributedWorkManager, channelName, requestTimeout);
        ServiceBuilder builder = serviceTarget.addService(ConnectorServices.WORKMANAGER_SERVICE.append(new String[]{name}), (Service)wmService);
        builder.addDependency(ServiceName.JBOSS.append(new String[]{"jgroups"}).append(new String[]{"stack"}).append(new String[]{jgroupsStack}), ChannelFactory.class, wmService.getJGroupsChannelFactoryInjector());
        builder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, ThreadsServices.EXECUTOR.append(new String[]{"long-running-threads"}).append(new String[]{name}), Executor.class, wmService.getExecutorLongInjector());
        builder.addDependency(ThreadsServices.EXECUTOR.append(new String[]{"short-running-threads"}).append(new String[]{name}), Executor.class, wmService.getExecutorShortInjector());
        builder.addDependency(TxnServices.JBOSS_TXN_XA_TERMINATOR, JBossXATerminator.class, wmService.getXaTerminatorInjector()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }
}

