/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.lang.reflect.Constructor;
import java.sql.Driver;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.services.driver.DriverService;
import org.jboss.as.connector.services.driver.InstalledDriver;
import org.jboss.as.connector.services.driver.registry.DriverRegistry;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class JdbcDriverAdd
extends AbstractAddStepHandler {
    static final JdbcDriverAdd INSTANCE = new JdbcDriverAdd();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode address = operation.require("address");
        String driverName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        for (SimpleAttributeDefinition attribute : Constants.JDBC_DRIVER_ATTRIBUTES) {
            attribute.validateAndSet(operation, model);
        }
        model.get(Constants.DRIVER_NAME.getName()).set(driverName);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        Module module;
        ModuleIdentifier moduleId;
        ModelNode address = operation.require("address");
        String driverName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        if (operation.get(Constants.DRIVER_NAME.getName()).isDefined() && !driverName.equals(operation.get(Constants.DRIVER_NAME.getName()).asString())) {
            throw ConnectorLogger.ROOT_LOGGER.driverNameAndResourceNameNotEquals(operation.get(Constants.DRIVER_NAME.getName()).asString(), driverName);
        }
        String moduleName = Constants.DRIVER_MODULE_NAME.resolveModelAttribute(context, model).asString();
        Integer majorVersion = model.hasDefined(Constants.DRIVER_MAJOR_VERSION.getName()) ? Integer.valueOf(Constants.DRIVER_MAJOR_VERSION.resolveModelAttribute(context, model).asInt()) : null;
        Integer minorVersion = model.hasDefined(Constants.DRIVER_MINOR_VERSION.getName()) ? Integer.valueOf(Constants.DRIVER_MINOR_VERSION.resolveModelAttribute(context, model).asInt()) : null;
        String driverClassName = model.hasDefined(Constants.DRIVER_CLASS_NAME.getName()) ? Constants.DRIVER_CLASS_NAME.resolveModelAttribute(context, model).asString() : null;
        String dataSourceClassName = model.hasDefined(Constants.DRIVER_DATASOURCE_CLASS_NAME.getName()) ? Constants.DRIVER_DATASOURCE_CLASS_NAME.resolveModelAttribute(context, model).asString() : null;
        String xaDataSourceClassName = model.hasDefined(Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.getName()) ? Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.resolveModelAttribute(context, model).asString() : null;
        Resource rootNode = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false);
        ModelNode rootModel = rootNode.getModel();
        String profile = rootModel.hasDefined("profile-name") ? rootModel.get("profile-name").asString() : null;
        ServiceTarget target = context.getServiceTarget();
        String slot = model.hasDefined(Constants.MODULE_SLOT.getName()) ? Constants.MODULE_SLOT.resolveModelAttribute(context, model).asString() : null;
        try {
            moduleId = ModuleIdentifier.create((String)moduleName, (String)slot);
            module = Module.getCallerModuleLoader().loadModule(moduleId);
        }
        catch (ModuleLoadException e) {
            throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.failedToLoadModuleDriver(moduleName), (Throwable)e);
        }
        if (driverClassName == null) {
            Iterator i$;
            ServiceLoader serviceLoader = module.loadService(Driver.class);
            boolean driverLoaded = false;
            if (serviceLoader != null && (i$ = serviceLoader.iterator()).hasNext()) {
                Driver driver = (Driver)i$.next();
                JdbcDriverAdd.startDriverServices(target, moduleId, driver, driverName, majorVersion, minorVersion, dataSourceClassName, xaDataSourceClassName, profile);
                driverLoaded = true;
            }
            if (!driverLoaded) {
                ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.cannotFindDriverClassName(driverName);
            }
        } else {
            try {
                Class<Driver> driverClass = module.getClassLoader().loadClass(driverClassName).asSubclass(Driver.class);
                Constructor<Driver> constructor = driverClass.getConstructor(new Class[0]);
                Driver driver = constructor.newInstance(new Object[0]);
                JdbcDriverAdd.startDriverServices(target, moduleId, driver, driverName, majorVersion, minorVersion, dataSourceClassName, xaDataSourceClassName, profile);
            }
            catch (Exception e) {
                ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.cannotInstantiateDriverClass(driverClassName, e);
                throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.cannotInstantiateDriverClass(driverClassName));
            }
        }
    }

    public static void startDriverServices(ServiceTarget target, ModuleIdentifier moduleId, Driver driver, String driverName, Integer majorVersion, Integer minorVersion, String dataSourceClassName, String xaDataSourceClassName, String profile) throws IllegalStateException {
        int majorVer = driver.getMajorVersion();
        int minorVer = driver.getMinorVersion();
        if (majorVersion != null && majorVersion != majorVer || minorVersion != null && minorVersion != minorVer) {
            throw ConnectorLogger.ROOT_LOGGER.driverVersionMismatch();
        }
        boolean compliant = driver.jdbcCompliant();
        if (compliant) {
            ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.deployingCompliantJdbcDriver(driver.getClass(), majorVer, minorVer);
        } else {
            ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.deployingNonCompliantJdbcDriver(driver.getClass(), majorVer, minorVer);
        }
        InstalledDriver driverMetadata = new InstalledDriver(driverName, moduleId, driver.getClass().getName(), dataSourceClassName, xaDataSourceClassName, majorVer, minorVer, compliant, profile);
        DriverService driverService = new DriverService(driverMetadata, driver);
        ServiceBuilder builder = target.addService(ServiceName.JBOSS.append(new String[]{"jdbc-driver", driverName.replaceAll("\\.", "_")}), (Service)driverService).addDependency(ConnectorServices.JDBC_DRIVER_REGISTRY_SERVICE, DriverRegistry.class, driverService.getDriverRegistryServiceInjector()).setInitialMode(ServiceController.Mode.ACTIVE);
        builder.install();
    }
}

