/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.ejb3.subsystem.EJB3Extension;
import org.jboss.as.ejb3.subsystem.MdbDeliveryGroupAdd;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class MdbDeliveryGroupResourceDefinition
extends SimpleResourceDefinition {
    private static final ServiceName DELIVERY_GROUP_SERVICE_NAME = ServiceName.of((String[])new String[]{"org", "wildfly", "ejb3", "mdb", "delivery", "group"});
    public static final SimpleAttributeDefinition ACTIVE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("active", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).build();
    public static final MdbDeliveryGroupResourceDefinition INSTANCE = new MdbDeliveryGroupResourceDefinition();

    private MdbDeliveryGroupResourceDefinition() {
        super(PathElement.pathElement((String)"mdb-delivery-group"), EJB3Extension.getResourceDescriptionResolver("mdb-delivery-group"), (OperationStepHandler)MdbDeliveryGroupAdd.INSTANCE, (OperationStepHandler)new ReloadRequiredRemoveStepHandler());
    }

    public static ServiceName getDeliveryGroupServiceName(String deliveryGroupName) {
        return DELIVERY_GROUP_SERVICE_NAME.append(new String[]{deliveryGroupName});
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)ACTIVE, null, (OperationStepHandler)new AbstractWriteAttributeHandler<Void>(new AttributeDefinition[0]){

            protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
                this.updateDeliveryGroup(context, currentValue, resolvedValue);
                return false;
            }

            protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
                this.updateDeliveryGroup(context, valueToRevert, valueToRestore);
            }

            protected void updateDeliveryGroup(OperationContext context, ModelNode currentValue, ModelNode resolvedValue) throws OperationFailedException {
                if (currentValue.equals(resolvedValue)) {
                    return;
                }
                String groupName = context.getCurrentAddress().getLastElement().getValue();
                context.getServiceRegistry(true).getRequiredService(MdbDeliveryGroupResourceDefinition.getDeliveryGroupServiceName(groupName)).setMode(resolvedValue.asBoolean() ? ServiceController.Mode.ACTIVE : ServiceController.Mode.NEVER);
            }
        });
    }
}

