/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security._private;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.InvalidObjectException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.NoSuchElementException;
import javax.naming.NamingException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import javax.security.auth.login.LoginException;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.jacc.PolicyContextException;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamReader;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import org.wildfly.client.config.XMLLocation;
import org.wildfly.security.asn1.ASN1Exception;
import org.wildfly.security.audit.EventPriority;
import org.wildfly.security.auth.realm.CacheableSecurityRealm;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.AuthorizationFailureException;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism.scram.ScramServerErrorCode;
import org.wildfly.security.mechanism.scram.ScramServerException;
import org.wildfly.security.permission.InvalidPermissionClassException;
import org.wildfly.security.permission.PermissionVerifier;
import org.wildfly.security.util.DecodeException;
import org.wildfly.security.x500.cert.acme.AcmeException;

@MessageLogger(projectCode="ELY", length=5)
public interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security");
    public static final ElytronMessages audit = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.audit");
    public static final ElytronMessages xmlLog = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.xml");
    public static final ElytronMessages tls = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.tls");
    public static final ElytronMessages sasl = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.sasl");
    public static final ElytronMessages saslAnonymous = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.sasl.anonymous");
    public static final ElytronMessages saslDigest = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.sasl.digest");
    public static final ElytronMessages saslEntity = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.sasl.entity");
    public static final ElytronMessages saslExternal = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.sasl.external");
    public static final ElytronMessages saslGs2 = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.sasl.gs2");
    public static final ElytronMessages saslGssapi = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.sasl.gssapi");
    public static final ElytronMessages saslLocal = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.sasl.local");
    public static final ElytronMessages saslOAuth2 = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.sasl.oauth2");
    public static final ElytronMessages saslOTP = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.sasl.otp");
    public static final ElytronMessages saslPlain = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.sasl.plain");
    public static final ElytronMessages saslScram = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.sasl.scram");
    public static final ElytronMessages httpSpnego = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.http.spnego");
    public static final ElytronMessages httpClientCert = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.http.cert");
    public static final ElytronMessages httpDigest = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.http.digest");
    public static final ElytronMessages httpUserPass = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.http.password");
    public static final ElytronMessages httpForm = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.http.form");
    public static final ElytronMessages httpBearer = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.http.bearer");
    public static final ElytronMessages httpBasic = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.http.basic");
    public static final ElytronMessages acme = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.x500.cert.acme");

    @LogMessage
    @Message(id=1, value="WildFly Elytron version %s")
    public void logVersion(String var1);

    @Message(id=2, value="Parameter %s is empty")
    public IllegalArgumentException emptyParameter(String var1);

    @Message(id=3, value="This builder has already been built")
    public IllegalStateException builderAlreadyBuilt();

    @Message(id=4, value="Unrecognized algorithm \"%s\"")
    public IllegalArgumentException unrecognizedAlgorithm(String var1);

    @Message(id=5, value="Cannot instantiate self-referential factory")
    public IllegalStateException cannotInstantiateSelfReferentialFactory();

    @Message(id=6, value="Unexpected trailing garbage in X.500 principal")
    public IllegalArgumentException unexpectedTrailingGarbageInX500principal();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=7, value="Credential destroying failed")
    public void credentialDestroyingFailed(@Cause Throwable var1);

    @Message(id=8, value="The given credential is not supported here")
    public IllegalArgumentException credentialNotSupported();

    @Message(id=9, value="Invalid name \"%s\"")
    public IllegalArgumentException generalInvalidName(String var1);

    @Message(id=11, value="Unable to create service for '%s.%s' ")
    public NoSuchAlgorithmException noSuchAlgorithmCreateService(String var1, String var2, @Cause Throwable var3);

    @Message(id=12, value="Unable to load OIDs database from properties file")
    public IllegalStateException unableToLoadOidsFromPropertiesFile(@Cause Throwable var1);

    @Message(id=1000, value="Authentication name was already set on this context")
    public IllegalStateException nameAlreadySet();

    @Message(id=1001, value="No module found for identifier \"%s\"")
    public ConfigXMLParseException xmlNoModuleFound(@Param XMLStreamReader var1, @Cause Exception var2, String var3);

    @Message(id=1002, value="Invalid port number \"%s\" specified for attribute \"%s\" of element \"%s\"; expected a numerical value between 1 and 65535 (inclusive)")
    public ConfigXMLParseException xmlInvalidPortNumber(@Param XMLStreamReader var1, String var2, String var3, QName var4);

    @Message(id=1003, value="No authentication is in progress")
    public IllegalStateException noAuthenticationInProgress();

    @Message(id=1005, value="Realm map does not contain mapping for default realm '%s'")
    public IllegalArgumentException realmMapDoesNotContainDefault(String var1);

    @Message(id=1006, value="No realm name found in users property file - non-plain-text users file must contain \"#$REALM_NAME=RealmName$\" line")
    public RealmUnavailableException noRealmFoundInProperties();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1007, value="JAAS authentication failed for principal %s")
    public void debugJAASAuthenticationFailure(Principal var1, @Cause Throwable var2);

    @Message(id=1008, value="Failed to create login context")
    public RealmUnavailableException failedToCreateLoginContext(@Cause Throwable var1);

    @Message(id=1009, value="Failed to instantiate custom CallbackHandler")
    public RealmUnavailableException failedToInstantiateCustomHandler(@Cause Throwable var1);

    @Message(id=1012, value="Filesystem-backed realm unexpectedly failed to open path \"%s\" for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmFailedToOpen(Path var1, String var2, @Cause IOException var3);

    @Message(id=1013, value="Filesystem-backed realm unexpectedly failed to read path \"%s\" for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmFailedToRead(Path var1, String var2, @Cause Exception var3);

    @Message(id=1015, value="Filesystem-backed realm encountered invalid file content in path \"%s\" line %d for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmInvalidContent(Path var1, int var2, String var3);

    @Message(id=1016, value="Filesystem-backed realm encountered missing required attribute \"%s\" in path \"%s\" line %d for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmMissingAttribute(String var1, Path var2, int var3, String var4);

    @Message(id=1017, value="Filesystem-backed realm encountered invalid password format \"%s\" in path \"%s\" line %d for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmInvalidPasswordFormat(String var1, Path var2, int var3, String var4);

    @Message(id=1018, value="Filesystem-backed realm encountered invalid password algorithm \"%s\" in path \"%s\" line %d for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmInvalidPasswordAlgorithm(String var1, Path var2, int var3, String var4);

    @Message(id=1019, value="Unable to obtain exclusive access to backing identity")
    public RealmUnavailableException unableToObtainExclusiveAccess();

    @Message(id=1020, value="Filesystem-backed realm failed to update identity \"%s\"")
    public RealmUnavailableException fileSystemUpdatedFailed(String var1, @Cause Throwable var2);

    @Message(id=1021, value="Filesystem-backed realm failed to delete identity \"%s\"")
    public RealmUnavailableException fileSystemRealmDeleteFailed(String var1, @Cause IOException var2);

    @Message(id=1022, value="Filesystem-backed realm failed to find identity \"%s\"")
    public RealmUnavailableException fileSystemRealmNotFound(String var1);

    @Message(id=1023, value="Filesystem-backed realm failed to write to file \"%s\" for identity \"%s\"")
    public RealmUnavailableException fileSystemRealmFailedToWrite(Path var1, String var2, @Cause Exception var3);

    @Message(id=1024, value="Filesystem-backed realm cannot create duplicate identity for identity \"%s\"")
    public RealmUnavailableException fileSystemRealmAlreadyExists(String var1, @Cause Throwable var2);

    @Message(id=1025, value="Filesystem-backed realm encountered invalid certificate format \"%s\" in path \"%s\" line %d for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmCertificateReadError(String var1, Path var2, int var3, String var4);

    @Message(id=1026, value="Filesystem-backed realm encountered invalid key format \"%s\" in path \"%s\" line %d for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmUnsupportedKeyFormat(String var1, Path var2, int var3, String var4);

    @Message(id=1027, value="Filesystem-backed realm encountered invalid key algorithm for format \"%s\" in path \"%s\" line %d for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmUnsupportedKeyAlgorithm(String var1, Path var2, int var3, String var4, @Cause Exception var5);

    @Message(id=1028, value="Invalid port number \"%d\"")
    public IllegalArgumentException invalidPortNumber(int var1);

    @Message(id=1029, value="Invalid host specification \"%s\"")
    public IllegalArgumentException invalidHostSpec(String var1);

    @Message(id=1030, value="Unable to read credential")
    public IOException unableToReadCredential(@Cause Exception var1);

    @Message(id=1033, value="User does not exist")
    public IllegalStateException userDoesNotExist();

    @Message(id=1034, value="Invalid credential type specified")
    public IllegalStateException invalidCredentialTypeSpecified();

    @Message(id=1035, value="Unable to create key manager")
    public IOException unableToCreateKeyManager(@Cause Exception var1);

    @Message(id=1036, value="Unable to create trust manager")
    public IOException unableToCreateTrustManager(@Cause Exception var1);

    @Message(id=1037, value="Certificate chain is empty")
    public IllegalArgumentException certificateChainIsEmpty();

    @Message(id=1041, value="Could not obtain credential")
    public RuntimeException couldNotObtainCredential();

    @Message(id=1042, value="Could not obtain credential")
    public RuntimeException couldNotObtainCredentialWithCause(@Cause Throwable var1);

    @Message(id=1043, value="Invalid password key specification for algorithm \"%s\"")
    public RuntimeException invalidPasswordKeySpecificationForAlgorithm(String var1, @Cause Throwable var2);

    @Message(id=1045, value="Could not obtain PasswordFactory for algorithm \"%s\"")
    public RuntimeException couldNotObtainPasswordFactoryForAlgorithm(String var1, @Cause Throwable var2);

    @Message(id=1049, value="Could not open connection")
    public RuntimeException couldNotOpenConnection(@Cause Throwable var1);

    @Message(id=1050, value="Could not execute query \"%s\"")
    public RuntimeException couldNotExecuteQuery(String var1, @Cause Throwable var2);

    @Message(id=1052, value="Unexpected error when processing authentication query \"%s\"")
    public RuntimeException unexpectedErrorWhenProcessingAuthenticationQuery(String var1, @Cause Throwable var2);

    @Message(id=1053, value="Insufficient data to form a digest and a salt")
    public InvalidKeySpecException insufficientDataToFormDigestAndSalt();

    @Message(id=1054, value="Invalid salt \"%s%s\"")
    public IllegalArgumentException invalidSalt(char var1, char var2);

    @Message(id=1055, value="Invalid rounds \"%s%s%s%s\"")
    public IllegalArgumentException invalidRounds(char var1, char var2, char var3, char var4);

    @Message(id=1056, value="Invalid salt \"%s%s%s%s\"")
    public IllegalArgumentException invalidSalt(char var1, char var2, char var3, char var4);

    @Message(id=1057, value="No DirContext supplier set")
    public IllegalStateException noDirContextSupplierSet();

    @Message(id=1058, value="No principal mapping definition")
    public IllegalStateException noPrincipalMappingDefinition();

    @Message(id=1059, value="Public and private key algorithm names are mismatched")
    public IllegalArgumentException mismatchedPublicPrivateKeyAlgorithms();

    @Message(id=1060, value="Could not obtain principal")
    public RuntimeException couldNotObtainPrincipal();

    @Message(id=1061, value="Public key is null")
    public IllegalArgumentException publicKeyIsNull();

    @Message(id=1062, value="No provider URL has been set")
    public IllegalStateException noProviderUrlSet();

    @Message(id=1063, value="Private key is null")
    public IllegalArgumentException privateKeyIsNull();

    @Message(id=1064, value="Invalid identity name")
    public IllegalArgumentException invalidName();

    @Message(id=1065, value="Pattern requires a capture group")
    public IllegalArgumentException patternRequiresCaptureGroup();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1066, value="Invalid string count for mechanism database entry \"%s\"")
    public void warnInvalidStringCountForMechanismDatabaseEntry(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1067, value="Invalid key exchange \"%s\" for mechanism database entry \"%s\"")
    public void warnInvalidKeyExchangeForMechanismDatabaseEntry(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1068, value="Invalid authentication \"%s\" for mechanism database entry \"%s\"")
    public void warnInvalidAuthenticationForMechanismDatabaseEntry(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1069, value="Invalid encryption \"%s\" for mechanism database entry \"%s\"")
    public void warnInvalidEncryptionForMechanismDatabaseEntry(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1070, value="Invalid digest \"%s\" for mechanism database entry \"%s\"")
    public void warnInvalidDigestForMechanismDatabaseEntry(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1071, value="Invalid protocol \"%s\" for mechanism database entry \"%s\"")
    public void warnInvalidProtocolForMechanismDatabaseEntry(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1072, value="Invalid level \"%s\" for mechanism database entry \"%s\"")
    public void warnInvalidLevelForMechanismDatabaseEntry(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1073, value="Invalid strength bits \"%s\" for mechanism database entry \"%s\"")
    public void warnInvalidStrengthBitsForMechanismDatabaseEntry(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1074, value="Invalid algorithm bits \"%s\" for mechanism database entry \"%s\"")
    public void warnInvalidAlgorithmBitsForMechanismDatabaseEntry(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1075, value="Invalid duplicate mechanism database entry \"%s\"")
    public void warnInvalidDuplicateMechanismDatabaseEntry(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1076, value="Invalid duplicate OpenSSL-style alias \"%s\" for mechanism database entry \"%s\" (original is \"%s\")")
    public void warnInvalidDuplicateOpenSslStyleAliasForMechanismDatabaseEntry(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1077, value="Invalid alias \"%s\" for missing mechanism database entry \"%s\"")
    public void warnInvalidAliasForMissingMechanismDatabaseEntry(String var1, String var2);

    @Message(id=1079, value="Ldap-backed realm failed to obtain attributes for entry [%s]")
    public RuntimeException ldapRealmFailedObtainAttributes(String var1, @Cause Throwable var2);

    @Message(id=1080, value="Attribute [%s] value [%s] must be in X.500 format in order to obtain RDN [%s].")
    public RuntimeException ldapRealmInvalidRdnForAttribute(String var1, String var2, String var3, @Cause Throwable var4);

    @Message(id=1081, value="Filesystem-backed realm encountered invalid OTP definition in path \"%s\" line %d for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmInvalidOtpDefinition(Path var1, int var2, String var3, @Cause Throwable var4);

    @Message(id=1082, value="Filesystem-backed realm encountered invalid OTP algorithm \"%s\" in path \"%s\" line %d for identity name \"%s\"")
    public RealmUnavailableException fileSystemRealmInvalidOtpAlgorithm(String var1, Path var2, int var3, String var4, @Cause Throwable var5);

    @Message(id=1083, value="Ldap-backed realm cannot to obtain not existing identity \"%s\"")
    public RealmUnavailableException ldapRealmIdentityNotExists(String var1);

    @Message(id=1084, value="Error while consuming results from search. SearchDn [%s], Filter [%s], Filter Args [%s].")
    public RuntimeException ldapRealmErrorWhileConsumingResultsFromSearch(String var1, String var2, String var3, @Cause Throwable var4);

    @Message(id=1085, value="LDAP realm persister does not support given credential type")
    public RealmUnavailableException ldapRealmsPersisterNotSupported();

    @Message(id=1086, value="Persisting credential %s into Ldap-backed realm failed. Identity dn: \"%s\"")
    public RealmUnavailableException ldapRealmCredentialPersistingFailed(String var1, String var2, @Cause Throwable var3);

    @Message(id=1087, value="Clearing credentials from Ldap-backed realm failed. Identity dn: \"%s\"")
    public RealmUnavailableException ldapRealmCredentialClearingFailed(String var1, @Cause Throwable var2);

    @Message(id=1088, value="Attempting to run as \"%s\" authorization operation failed")
    public AuthorizationFailureException runAsAuthorizationFailed(@Param Principal var1, Principal var2, @Cause Throwable var3);

    @Message(id=1090, value="Unknown LDAP password scheme")
    public InvalidKeySpecException unknownLdapPasswordScheme();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1091, value="Post-association peer context action failed")
    public void postAssociationFailed(@Cause Throwable var1);

    @Message(id=1092, value="Invalid mechanism realm selection \"%s\"")
    public IllegalArgumentException invalidMechRealmSelection(String var1);

    @Message(id=1093, value="Mechanism realm was already selected")
    public IllegalStateException mechRealmAlreadySelected();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1094, value="An event handler threw an exception")
    public void eventHandlerFailed(@Cause Throwable var1);

    @Message(id=1095, value="Unable to create identity")
    public RealmUnavailableException unableToCreateIdentity();

    @Message(id=1096, value="No such identity")
    public RealmUnavailableException noSuchIdentity();

    @Message(id=1097, value="Ldap-backed realm failed to delete identity from server")
    public RealmUnavailableException ldapRealmFailedDeleteIdentityFromServer(@Cause Throwable var1);

    @Message(id=1098, value="Ldap-backed realm failed to create identity on server")
    public RealmUnavailableException ldapRealmFailedCreateIdentityOnServer(@Cause Throwable var1);

    @Message(id=1099, value="Ldap-backed realm is not configured to allow create new identities (new identity parent and attributes has to be set)")
    public RealmUnavailableException ldapRealmNotConfiguredToSupportCreatingIdentities();

    @Message(id=1100, value="Ldap-backed realm does not contain mapping to set Elytron attribute \"%s\" of identity \"%s\"")
    public RealmUnavailableException ldapRealmCannotSetAttributeWithoutMapping(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1101, value="Ldap-backed realm does not support setting of filtered attribute \"%s\" (identity \"%s\")")
    public void ldapRealmDoesNotSupportSettingFilteredAttribute(String var1, String var2);

    @Message(id=1102, value="Ldap-backed realm requires exactly one value of attribute \"%s\" mapped to RDN (identity \"%s\")")
    public RealmUnavailableException ldapRealmRequiresExactlyOneRdnAttribute(String var1, String var2);

    @Message(id=1103, value="Ldap-backed realm failed to set attributes of identity \"%s\"")
    public RealmUnavailableException ldapRealmAttributesSettingFailed(String var1, @Cause Throwable var2);

    @Message(id=1104, value="OAuth2-based realm failed to obtain principal")
    public RuntimeException tokenRealmFailedToObtainPrincipal(@Cause Throwable var1);

    @Message(id=1105, value="OAuth2-based realm failed to introspect token")
    public RealmUnavailableException tokenRealmOAuth2TokenIntrospectionFailed(@Cause Throwable var1);

    @Message(id=1106, value="Could not obtain SSLContext")
    public IllegalStateException failedToObtainSSLContext(@Cause Throwable var1);

    @Message(id=1108, value="Ldap-backed realm identity search failed")
    public RealmUnavailableException ldapRealmIdentitySearchFailed(@Cause Throwable var1);

    @Message(id=1109, value="Ldap-backed realm is not configured to allow iterate over identities (iterator filter has to be set)")
    public RealmUnavailableException ldapRealmNotConfiguredToSupportIteratingOverIdentities();

    @Message(id=1112, value="Authentication cannot succeed; not authorized")
    public IllegalStateException cannotSucceedNotAuthorized();

    @Message(id=1113, value="Token-based realm failed to obtain principal from token using claim [%s]")
    public IllegalStateException tokenRealmFailedToObtainPrincipalWithClaim(String var1);

    @Message(id=1114, value="Invalid token format. Tokens must have a signature part accordingly with JWS specification")
    public IllegalArgumentException tokenRealmJwtInvalidFormat();

    @Message(id=1115, value="Failed to parse token")
    public IllegalStateException tokenRealmJwtParseFailed(@Cause Throwable var1);

    @Message(id=1116, value="Signature verification failed")
    public IllegalStateException tokenRealmJwtSignatureCheckFailed(@Cause Throwable var1);

    @Message(id=1117, value="Invalid signature algorithm [%s]")
    public IllegalArgumentException tokenRealmJwtSignatureInvalidAlgorithm(String var1);

    @Message(id=1118, value="Public key could not be obtained. Probably due to an invalid PEM format.")
    public IllegalArgumentException tokenRealmJwtInvalidPublicKeyPem();

    @Message(id=1119, value="Unable to resolve MechanismConfiguration for mechanismType='%s', mechanismName='%s', hostName='%s', protocol='%s'.")
    public IllegalStateException unableToSelectMechanismConfiguration(String var1, String var2, String var3, String var4);

    @Message(id=1120, value="Too late to set mechanism information as authentication has already begun.")
    public IllegalStateException tooLateToSetMechanismInformation();

    @Message(id=1121, value="Unable to perform initial JAAS login.")
    public GeneralSecurityException unableToPerformInitialLogin(@Cause LoginException var1);

    @Message(id=1122, value="No Kerberos principals found.")
    public GeneralSecurityException noKerberosPrincipalsFound();

    @Message(id=1123, value="Too many Kerberos principals found.")
    public GeneralSecurityException tooManyKerberosPrincipalsFound();

    @Message(id=1124, value="The security realm does not support updating a credential")
    public UnsupportedOperationException credentialUpdateNotSupportedByRealm();

    @Message(id=1125, value="Ldap-backed realm failed to obtain context")
    public RealmUnavailableException ldapRealmFailedToObtainContext(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1126, value="Jwt-based token realm not configured with a list of valid issuers. Ignoring issuer verification.")
    public void tokenRealmJwtWarnNoIssuerIgnoringIssuerCheck();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1127, value="Jwt-based token not configured with a list of valid audiences. Ignoring audience verification.")
    public void tokenRealmJwtWarnNoAudienceIgnoringAudienceCheck();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1128, value="Jwt-based token not configured with a public key. Ignoring signature verification.")
    public void tokenRealmJwtWarnNoPublicKeyIgnoringSignatureCheck();

    @Message(id=1129, value="Unknown SSL context \"%s\" specified")
    public ConfigXMLParseException xmlUnknownSslContextSpecified(@Param Location var1, String var2);

    @Message(id=1130, value="Duplicate SSL context name \"%s\"")
    public ConfigXMLParseException xmlDuplicateSslContextName(String var1, @Param ConfigurationXMLStreamReader var2);

    @Message(id=1132, value="Unknown authentication configuration \"%s\" specified")
    public ConfigXMLParseException xmlUnknownAuthenticationConfigurationSpecified(@Param Location var1, String var2);

    @Message(id=1133, value="Failed to create credential")
    public ConfigXMLParseException xmlFailedToCreateCredential(@Param Location var1, @Cause Throwable var2);

    @Message(id=1134, value="Duplicate authentication configuration name \"%s\"")
    public ConfigXMLParseException xmlDuplicateAuthenticationConfigurationName(String var1, @Param ConfigurationXMLStreamReader var2);

    @Message(id=1135, value="Failed to load keystore data")
    public ConfigXMLParseException xmlFailedToLoadKeyStoreData(@Param Location var1, @Cause Throwable var2);

    @Message(id=1136, value="Failed to create keystore")
    public ConfigXMLParseException xmlFailedToCreateKeyStore(@Param Location var1, @Cause Throwable var2);

    @Message(id=1137, value="Invalid key store entry type for alias \"%s\" (expected %s, got %s)")
    public ConfigXMLParseException xmlInvalidKeyStoreEntryType(@Param Location var1, String var2, Class<?> var3, Class<?> var4);

    @Message(id=1138, value="Decoding hashed password from users property file failed - should not be set as plain-text property file?")
    public RealmUnavailableException decodingHashedPasswordFromPropertiesRealmFailed(@Cause Exception var1);

    @Message(id=1139, value="Failed to create credential store")
    public ConfigXMLParseException xmlFailedToCreateCredentialStore(@Param Location var1, @Cause Throwable var2);

    @Message(id=1140, value="Wrong PEM content type; expected %s, actually was %s")
    public ConfigXMLParseException xmlWrongPemType(@Param ConfigurationXMLStreamReader var1, Class<?> var2, Class<?> var3);

    @Message(id=1141, value="No PEM content found")
    public ConfigXMLParseException xmlNoPemContent(@Param ConfigurationXMLStreamReader var1);

    @Message(id=1143, value="Invalid URL [%s]")
    public ConfigXMLParseException xmlInvalidUrl(String var1);

    @Message(id=1145, value="Security realm [%s] must implement [%s]")
    public IllegalArgumentException realmCacheUnexpectedType(SecurityRealm var1, Class<? extends CacheableSecurityRealm> var2);

    @LogMessage
    @Message(id=1146, value="LDAP Realm unable to register listener, defering action.")
    public void ldapRealmDeferRegistration();

    @Message(id=1147, value="Invalid LDAP name [%s]")
    public RuntimeException ldapInvalidLdapName(String var1, @Cause Throwable var2);

    @Message(id=1148, value="A SecurityDomain has already been associated with the specified ClassLoader")
    public IllegalStateException classLoaderSecurityDomainExists();

    @Message(id=1149, value="Can not use SecurityIdentity with SecurityIdentity from same SecurityDomain")
    public IllegalArgumentException cantWithSameSecurityDomainDomain();

    @Message(id=1150, value="Obtaining DirContext credentials from AuthenticationContext failed.")
    public NamingException obtainingDirContextCredentialFromAuthenticationContextFailed(@Cause Throwable var1);

    @Message(id=1151, value="Evidence Verification Failed.")
    public SecurityException authenticationFailedEvidenceVerification();

    @Message(id=1152, value="Authorization Check Failed.")
    public SecurityException authenticationFailedAuthorization();

    @Message(id=1153, value="Direct LDAP verification failed with DN [%s] and absolute DN [%s]")
    public RealmUnavailableException directLdapVerificationFailed(String var1, String var2, @Cause Exception var3);

    @Message(id=1154, value="Failed to read key store")
    public RealmUnavailableException failedToReadKeyStore(@Cause KeyStoreException var1);

    @Message(id=1155, value="Security domain mismatch")
    public IllegalArgumentException securityDomainMismatch();

    @Message(id=1156, value="Cannot obtain a credential from a security factory")
    public IOException cannotObtainCredentialFromFactory(@Cause GeneralSecurityException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1157, value="Unable to resolve MechanismConfiguration for MechanismInformation")
    public void unableToResolveMechanismConfiguration(@Cause Throwable var1);

    @Message(id=1158, value="Unable to create kerberos GSS credential")
    public SecurityException unableToCreateKerberosCredential(@Cause Exception var1);

    @Message(id=1159, value="Key store entry for alias \"%s\" is missing.")
    public ConfigXMLParseException keyStoreEntryMissing(@Param Location var1, String var2);

    @Message(id=1160, value="KeyTab [%s] does not exists.")
    public IOException keyTabDoesNotExists(String var1);

    @Message(id=1161, value="No keys for Kerberos principal [%s] was found in KeyTab [%s].")
    public IOException noKeysForPrincipalInKeyTab(String var1, String var2);

    @Message(id=1162, value="Invalid GSS mechanism name \"%s\" - unable to convert to mechanism OID")
    public ConfigXMLParseException xmlInvalidGssMechanismName(@Param XMLStreamReader var1, String var2);

    @Message(id=1163, value="Mechanism OID conversion from string \"%s\" failed")
    public ConfigXMLParseException xmlGssMechanismOidConversionFailed(@Param XMLStreamReader var1, String var2, @Cause Throwable var3);

    @Message(id=1164, value="Unable to identify provider name=%s, for service type=%s, algorithm=%s")
    public ConfigXMLParseException xmlUnableToIdentifyProvider(@Param Location var1, String var2, String var3, String var4);

    @Message(id=1165, value="Initial JAAS login skipped as it has failed in last %d seconds")
    public GeneralSecurityException initialLoginSkipped(long var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1166, value="%2$s: Element \"%1$s\" is deprecated")
    public void xmlDeprecatedElement(String var1, XMLLocation var2);

    @Message(id=1167, value="Unable to construct provider '%s'.")
    public SecurityException unableToConstructProvider(String var1, @Cause Throwable var2);

    @Message(id=1168, value="JASPIC Configuration for messageLayer=%s, and applicationContext=%s already registered.")
    public IllegalStateException configAlreadyRegistered(String var1, String var2);

    @Message(id=1169, value="Message type '%s' is not supported by authentication module '%s'")
    public IllegalArgumentException unsupportedMessageType(String var1, String var2);

    @Message(id=1170, value="Unrecognised authContextId '%s'")
    public AuthException unrecognisedAuthContextId(String var1);

    @Message(id=1171, value="Invalid message type '%s', expected '%s'.")
    public IllegalArgumentException invalidMessageType(String var1, String var2);

    @Message(id=1172, value="Message does not wrap existing message of type '%s'")
    public IllegalArgumentException messageDoesNotWrapExistingMessage(String var1);

    @Message(id=1173, value="Message does not un-wrap existing message of type '%s'")
    public IllegalArgumentException messageDoesNotUnWrapExistingMessage(String var1);

    @Message(id=1174, value="Setting message of type '%s' not allowed at this time.")
    public IllegalStateException messageSettingNotAllowed(String var1);

    @Message(id=1175, value="The wrapping or request / response messages is only allowed where AuthStatus==SUCCESS ServerAuthenticationModule=%s")
    public IllegalStateException messageWrappedWithoutSuccess(String var1);

    @Message(id=1176, value="Invalid AuthStatus %s returned from ServerAuthModule %s.")
    public IllegalStateException invalidAuthStatus(AuthStatus var1, String var2);

    @Message(id=1177, value="Authorization failed.")
    public IOException authorizationFailed();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1178, value="Unable to update jwk set from \"%1$s\".")
    public void unableToFetchJwks(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1179, value="SSL not configured. jku claim will not be supported.")
    public void tokenRealmJwtNoSSLIgnoringJku();

    @LogMessage
    @Message(id=1180, value="Fetched jwk does not contain \"%1$s\" claim, ignoring...")
    public void tokenRealmJwkMissingClaim(String var1);

    @Message(id=2001, value="Invalid key store entry password for alias \"%s\"")
    public UnrecoverableKeyException invalidKeyStoreEntryPassword(String var1);

    @Message(id=2002, value="Invalid key store entry type for alias \"%s\" (expected %s, got %s)")
    public KeyStoreException invalidKeyStoreEntryType(String var1, Class<?> var2, Class<?> var3);

    @Message(id=2003, value="Key store key for alias \"%s\" cannot be protected")
    public KeyStoreException keyCannotBeProtected(String var1);

    @Message(id=2004, value="Key store failed to translate password for alias \"%s\"")
    public IOException keyStoreFailedToTranslate(String var1, @Cause Throwable var2);

    @Message(id=2005, value="Key store failed to identify a suitable algorithm for alias \"%s\"")
    public NoSuchAlgorithmException noAlgorithmForPassword(String var1);

    @Message(id=2006, value="Unexpected whitespace in password file")
    public IOException unexpectedWhitespaceInPasswordFile();

    @Message(id=2007, value="Unexpected end of file")
    public EOFException unexpectedEof();

    @Message(id=2008, value="A reversible load is not possible until the KeyStore has first been initialized")
    public IllegalStateException reversibleLoadNotPossible();

    @Message(id=2009, value="Unable to create a new KeyStore instance")
    public IOException unableToCreateKeyStore(@Cause Exception var1);

    @Message(id=2010, value="Unknown key store specified")
    public ConfigXMLParseException xmlUnknownKeyStoreSpecified(@Param Location var1);

    @Message(id=2012, value="An empty alias filter was supplied")
    public IllegalArgumentException emptyFilter();

    @Message(id=2013, value="Filter is missing '+' or '-' at offset %d")
    public IllegalArgumentException missingPlusMinusAt(long var1);

    @Message(id=2014, value="Invalid first word '%s', must be one of ALL/NONE")
    public IllegalArgumentException invalidFirstWord(String var1);

    @Message(id=2015, value="Failed to obtain DirContext")
    public IllegalStateException failedToObtainDirContext(@Cause Throwable var1);

    @Message(id=2016, value="Failed to return DirContext")
    public IllegalStateException failedToReturnDirContext(@Cause Throwable var1);

    @Message(id=2017, value="LdapKeyStore failed to obtain alias [%s]")
    public IllegalStateException ldapKeyStoreFailedToObtainAlias(String var1, @Cause Throwable var2);

    @Message(id=2018, value="LdapKeyStore failed to obtain certificate [%s]")
    public IllegalStateException ldapKeyStoreFailedToObtainCertificate(String var1, @Cause Throwable var2);

    @Message(id=2019, value="LdapKeyStore failed to obtain certificate chain [%s]")
    public IllegalStateException ldapKeyStoreFailedToObtainCertificateChain(String var1, @Cause Throwable var2);

    @Message(id=2020, value="LdapKeyStore failed to recover key of alias [%s]")
    public IllegalStateException ldapKeyStoreFailedToObtainKey(String var1, @Cause Throwable var2);

    @Message(id=2021, value="LdapKeyStore failed to obtain alias by certificate")
    public IllegalStateException ldapKeyStoreFailedToObtainAliasByCertificate(@Cause Throwable var1);

    @Message(id=2022, value="LdapKeyStore failed to recover key of alias [%s]")
    public UnrecoverableKeyException ldapKeyStoreFailedToRecoverKey(String var1, @Cause Throwable var2);

    @Message(id=2023, value="LdapKeyStore failed to obtain creation date of alias [%s]")
    public IllegalStateException ldapKeyStoreFailedToObtainCreationDate(String var1, @Cause Throwable var2);

    @Message(id=2024, value="Alias [%s] does not exist in LdapKeyStore and not configured for creation")
    public KeyStoreException creationNotConfigured(String var1);

    @Message(id=2025, value="LdapKeyStore failed store alias [%s]")
    public KeyStoreException ldapKeyStoreFailedToStore(String var1, @Cause Throwable var2);

    @Message(id=2026, value="LdapKeyStore failed to serialize certificate of alias [%s]")
    public KeyStoreException ldapKeyStoreFailedToSerializeCertificate(String var1, @Cause Throwable var2);

    @Message(id=2027, value="LdapKeyStore failed to protect (pack into keystore) key of alias [%s]")
    public KeyStoreException ldapKeyStoreFailedToSerializeKey(String var1, @Cause Throwable var2);

    @Message(id=2028, value="LdapKeyStore failed to delete alias [%s]")
    public KeyStoreException ldapKeyStoreFailedToDelete(String var1, @Cause Throwable var2);

    @Message(id=2029, value="LdapKeyStore failed to delete alias [%s] - alias not found")
    public KeyStoreException ldapKeyStoreFailedToDeleteNonExisting(String var1);

    @Message(id=2030, value="LdapKeyStore failed to test alias [%s] existence")
    public IllegalStateException ldapKeyStoreFailedToTestAliasExistence(String var1, @Cause Throwable var2);

    @Message(id=2031, value="LdapKeyStore failed to iterate aliases")
    public IllegalStateException ldapKeyStoreFailedToIterateAliases(@Cause Throwable var1);

    @Message(id=2032, value="keySpec must be SecretKeySpect, given: [%s]")
    public InvalidKeySpecException keySpecMustBeSecretKeySpec(String var1);

    @Message(id=2033, value="key must implement SecretKeySpec and keySpec must be SecretKeySpec, given key, keySpec: [%s]")
    public InvalidKeySpecException keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec(String var1);

    @Message(id=2034, value="Alias must be specified if more than one entry exist in keystore")
    public ConfigXMLParseException missingAlias(@Param Location var1);

    @Message(id=3001, value="Unexpected padding")
    public DecodeException unexpectedPadding();

    @Message(id=3002, value="Expected padding")
    public DecodeException expectedPadding();

    @Message(id=3003, value="Incomplete decode")
    public DecodeException incompleteDecode();

    @Message(id=3004, value="Expected %d padding characters")
    public DecodeException expectedPaddingCharacters(int var1);

    @Message(id=3005, value="Invalid base 32 character")
    public DecodeException invalidBase32Character();

    @Message(id=3006, value="Expected an even number of hex characters")
    public DecodeException expectedEvenNumberOfHexCharacters();

    @Message(id=3007, value="Invalid hex character")
    public DecodeException invalidHexCharacter();

    @Message(id=3008, value="Expected two padding characters")
    public DecodeException expectedTwoPaddingCharacters();

    @Message(id=3009, value="Invalid base 64 character")
    public DecodeException invalidBase64Character();

    @Message(id=3010, value="Malformed PEM content at offset %d")
    public IllegalArgumentException malformedPemContent(long var1);

    @Message(id=3011, value="Invalid PEM type (expected \"%s\", got \"%s\"")
    public IllegalArgumentException invalidPemType(String var1, String var2);

    @Message(id=3012, value="Certificate parse error")
    public IllegalArgumentException certificateParseError(@Cause CertificateException var1);

    @Message(id=3013, value="Permission collection must be read-only")
    public SecurityException permissionCollectionMustBeReadOnly();

    @Message(id=3015, value="Could not load permission class \"%s\"")
    public InvalidPermissionClassException permissionClassMissing(String var1, @Cause ClassNotFoundException var2);

    @Message(id=3016, value="Could not instantiate permission class \"%s\"")
    public InvalidPermissionClassException permissionInstantiation(String var1, @Cause Throwable var2);

    @Message(id=3017, value="No valid permission constructor found on class \"%s\"")
    public InvalidPermissionClassException noPermissionConstructor(String var1);

    @Message(id=3018, value="Cannot add permissions to a read-only permission collection")
    public SecurityException readOnlyPermissionCollection();

    @Message(id=3019, value="Failure to deserialize object: field \"%s\" is null")
    public InvalidObjectException invalidObjectNull(String var1);

    @Message(id=3020, value="Expected empty actions string, got \"%s\"")
    public IllegalArgumentException expectedEmptyActions(String var1);

    @Message(id=3021, value="Invalid permission type; expected %s, got %s")
    public IllegalArgumentException invalidPermissionType(Class<? extends Permission> var1, Permission var2);

    @Message(id=3022, value="Permission check failed: %s is not implied by %s")
    public SecurityException permissionCheckFailed(Permission var1, PermissionVerifier var2);

    @Message(id=3023, value="PublicKey parse error")
    public IllegalArgumentException publicKeyParseError(@Cause Throwable var1);

    @Message(id=3025, value="Iteration count not specified for password based encryption")
    public IllegalArgumentException iterationCountNotSpecified();

    @Message(id=3026, value="Salt not specified for password based encryption")
    public IllegalArgumentException saltNotSpecified();

    @Message(id=3027, value="Initial key not specified for password based encryption")
    public IllegalArgumentException initialKeyNotSpecified();

    @Message(id=3028, value="Security provider \"%s\" doesn't exist")
    public IllegalArgumentException securityProviderDoesnExist(String var1);

    @Message(id=3029, value="No such key algorithm \"%s\"")
    public IllegalArgumentException noSuchKeyAlgorithm(String var1, @Cause GeneralSecurityException var2);

    @Message(id=3030, value="I/O operation failed: closed")
    public IOException closed();

    @Message(id=3031, value="Too many KerberosTicket instances in private credentials")
    public GeneralSecurityException tooManyKerberosTicketsFound();

    @Message(id=3032, value="Base64 string created with unsupported PicketBox version \"%s\"")
    public IllegalArgumentException wrongBase64InPBCompatibleMode(String var1);

    @Message(id=3033, value="PrivateKey parse error")
    public IllegalArgumentException privateKeyParseError(@Cause Throwable var1);

    @Message(id=4001, value="No algorithm found matching TLS/SSL protocol selection criteria")
    public NoSuchAlgorithmException noAlgorithmForSslProtocol();

    @Message(id=4002, value="Empty certificate chain is not trusted")
    public CertificateException emptyChainNotTrusted();

    @Message(id=4003, value="Certificate not trusted due to realm failure for principal [%s]")
    public CertificateException notTrustedRealmProblem(@Cause RealmUnavailableException var1, Principal var2);

    @Message(id=4004, value="Credential validation failed: certificate is not trusted for principal [%s]")
    public CertificateException notTrusted(Principal var1);

    @Message(id=4005, value="No default trust manager available")
    public NoSuchAlgorithmException noDefaultTrustManager();

    @Message(id=4006, value="No context for SSL connection")
    public SSLHandshakeException noContextForSslConnection();

    @Message(id=4007, value="SSL channel is closed")
    public SSLException sslClosed();

    @Message(id=4008, value="Initial SSL/TLS data is not a handshake record")
    public SSLHandshakeException notHandshakeRecord();

    @Message(id=4009, value="Initial SSL/TLS handshake record is invalid")
    public SSLHandshakeException invalidHandshakeRecord();

    @Message(id=4010, value="Initial SSL/TLS handshake spans multiple records")
    public SSLHandshakeException multiRecordSSLHandshake();

    @Message(id=4011, value="Expected \"client hello\" record")
    public SSLHandshakeException expectedClientHello();

    @Message(id=4012, value="Unsupported SSL/TLS record")
    public SSLHandshakeException unsupportedSslRecord();

    @Message(id=4013, value="Invalid TLS extension data")
    public SSLProtocolException invalidTlsExt();

    @Message(id=4014, value="Not enough data in record to fill declared item size")
    public SSLProtocolException notEnoughData();

    @Message(id=4015, value="Empty host name in SNI record data")
    public SSLProtocolException emptyHostNameSni();

    @Message(id=4016, value="Duplicated SNI server name of type %d")
    public SSLProtocolException duplicatedSniServerName(int var1);

    @Message(id=4017, value="Unknown authentication name \"%s\"")
    public IllegalArgumentException unknownAuthenticationName(String var1);

    @Message(id=4018, value="Unknown encryption name \"%s\"")
    public IllegalArgumentException unknownEncryptionName(String var1);

    @Message(id=4019, value="Unknown key exchange name \"%s\"")
    public IllegalArgumentException unknownKeyExchangeName(String var1);

    @Message(id=4020, value="Mechanism \"%s\" not supported by transformation mapper")
    public IllegalArgumentException mechanismNotSupported(String var1);

    @Message(id=4021, value="Invalid index %d")
    public IndexOutOfBoundsException invalidIndex(int var1);

    @Message(id=4022, value="Invalid socket address type for URI")
    public IllegalArgumentException invalidSocketAddressTypeForUri();

    @Message(id=4023, value="Too large")
    public IllegalStateException tooLarge();

    @Message(id=4024, value="Invalid client mode, expected %s, got %s")
    public IllegalArgumentException invalidClientMode(boolean var1, boolean var2);

    @Message(id=4025, value="DirContext tries to connect without ThreadLocalSSLSocketFactory thread local setting")
    public IllegalStateException threadLocalSslSocketFactoryThreadLocalNotSet();

    @Message(id=4026, value="Could not create trust manager [%s]")
    public IllegalStateException sslErrorCreatingTrustManager(String var1, @Cause Throwable var2);

    @Message(id=4027, value="SecurityDomain of SSLContext does not support X509PeerCertificateChainEvidence verification")
    public IllegalArgumentException securityDomainOfSSLContextDoesNotSupportX509();

    @Message(id=4028, value="No default key manager available")
    public NoSuchAlgorithmException noDefaultKeyManager();

    @Message(id=4029, value="Default context cannot be null")
    public IllegalStateException defaultContextCannotBeNull();

    @Message(id=4030, value="No context for SSL connection")
    public SSLException noSNIContextForSslConnection();

    @Message(id=5001, value="Authentication mechanism exchange received a message after authentication was already complete")
    public AuthenticationMechanismException mechMessageAfterComplete();

    @Message(id=5002, value="Authentication mechanism user name contains an invalid or disallowed character")
    public AuthenticationMechanismException mechUserNameContainsInvalidCharacter();

    @Message(id=5004, value="Authentication mechanism authorization failed")
    public AuthenticationMechanismException mechAuthorizationFailed(@Cause Throwable var1);

    @Message(id=5005, value="Authentication mechanism authentication is not yet complete")
    public IllegalStateException mechAuthenticationNotComplete();

    @Message(id=5006, value="Authentication mechanism does not support security layer (wrapping/unwrapping)")
    public IllegalStateException mechNoSecurityLayer();

    @Message(id=5007, value="Invalid authentication mechanism negotiation message received")
    public AuthenticationMechanismException mechInvalidMessageReceived();

    @Message(id=5008, value="No authentication mechanism login name was given")
    public AuthenticationMechanismException mechNoLoginNameGiven();

    @Message(id=5009, value="No authentication mechanism password was given")
    public AuthenticationMechanismException mechNoPasswordGiven();

    @Message(id=5010, value="Authentication mechanism authentication failed due to one or more malformed fields")
    public AuthenticationMechanismException mechMalformedFields(@Cause IllegalArgumentException var1);

    @Message(id=5011, value="Authentication mechanism message is too long")
    public AuthenticationMechanismException mechMessageTooLong();

    @Message(id=5012, value="Authentication mechanism server-side authentication failed")
    public AuthenticationMechanismException mechServerSideAuthenticationFailed(@Cause Exception var1);

    @Message(id=5013, value="Authentication mechanism password not verified")
    public AuthenticationMechanismException mechPasswordNotVerified();

    @Message(id=5014, value="Authentication mechanism authorization failed: \"%s\" running as \"%s\"")
    public AuthenticationMechanismException mechAuthorizationFailed(String var1, String var2);

    @Message(id=5015, value="Unexpected character U+%04x at offset %d of mechanism selection string \"%s\"")
    public IllegalArgumentException mechSelectorUnexpectedChar(int var1, long var2, String var4);

    @Message(id=5016, value="Unrecognized token \"%s\" in mechanism selection string \"%s\"")
    public IllegalArgumentException mechSelectorUnknownToken(String var1, String var2);

    @Message(id=5017, value="Token \"%s\" not allowed at offset %d of mechanism selection string \"%s\"")
    public IllegalArgumentException mechSelectorTokenNotAllowed(String var1, long var2, String var4);

    @Message(id=5018, value="Channel binding data changed")
    public AuthenticationMechanismException mechChannelBindingChanged();

    @Message(id=5019, value="No token was given")
    public AuthenticationMechanismException mechNoTokenGiven();

    @Message(id=5020, value="Unexpected end of mechanism selection string \"%s\"")
    public IllegalArgumentException mechSelectorUnexpectedEnd(String var1);

    @Message(id=5022, value="Initial challenge must be empty")
    public AuthenticationMechanismException mechInitialChallengeMustBeEmpty();

    @Message(id=5023, value="Unable to set channel binding")
    public AuthenticationMechanismException mechUnableToSetChannelBinding(@Cause Exception var1);

    @Message(id=5024, value="Failed to determine channel binding status")
    public AuthenticationMechanismException mechFailedToDetermineChannelBindingStatus(@Cause Exception var1);

    @Message(id=5025, value="Mutual authentication not enabled")
    public AuthenticationMechanismException mechMutualAuthenticationNotEnabled();

    @Message(id=5026, value="Unable to map SASL mechanism name to a GSS-API OID")
    public AuthenticationMechanismException mechMechanismToOidMappingFailed(@Cause Exception var1);

    @Message(id=5027, value="Unable to dispose of GSSContext")
    public AuthenticationMechanismException mechUnableToDisposeGssContext(@Cause Exception var1);

    @Message(id=5028, value="Unable to create name for acceptor")
    public AuthenticationMechanismException mechUnableToCreateNameForAcceptor(@Cause Exception var1);

    @Message(id=5029, value="Unable to create GSSContext")
    public AuthenticationMechanismException mechUnableToCreateGssContext(@Cause Exception var1);

    @Message(id=5030, value="Unable to set GSSContext request flags")
    public AuthenticationMechanismException mechUnableToSetGssContextRequestFlags(@Cause Exception var1);

    @Message(id=5031, value="Unable to accept SASL client message")
    public AuthenticationMechanismException mechUnableToAcceptClientMessage(@Cause Exception var1);

    @Message(id=5032, value="GSS-API mechanism mismatch between SASL client and server")
    public AuthenticationMechanismException mechGssApiMechanismMismatch();

    @Message(id=5033, value="Channel binding not supported for this SASL mechanism")
    public AuthenticationMechanismException mechChannelBindingNotSupported();

    @Message(id=5034, value="Channel binding type mismatch between SASL client and server")
    public AuthenticationMechanismException mechChannelBindingTypeMismatch();

    @Message(id=5035, value="Channel binding not provided by client")
    public AuthenticationMechanismException mechChannelBindingNotProvided();

    @Message(id=5036, value="Unable to determine peer name")
    public AuthenticationMechanismException mechUnableToDeterminePeerName(@Cause Exception var1);

    @Message(id=5037, value="Authentication mechanism client refuses to initiate authentication")
    public AuthenticationMechanismException mechClientRefusesToInitiateAuthentication();

    @Message(id=5038, value="Nonces do not match")
    public AuthenticationMechanismException mechNoncesDoNotMatch();

    @Message(id=5039, value="Invalid length of nonce received")
    public AuthenticationMechanismException invalidNonceLength();

    @Message(id=5040, value="Iteration count %d is below the minimum of %d")
    public AuthenticationMechanismException mechIterationCountIsTooLow(int var1, int var2);

    @Message(id=5041, value="Iteration count %d is above the maximum of %d")
    public AuthenticationMechanismException mechIterationCountIsTooHigh(int var1, int var2);

    @Message(id=5043, value="Invalid server message")
    public AuthenticationMechanismException mechInvalidServerMessage();

    @Message(id=5044, value="Invalid server message")
    public AuthenticationMechanismException mechInvalidServerMessageWithCause(@Cause Throwable var1);

    @Message(id=5045, value="Invalid client message")
    public AuthenticationMechanismException mechInvalidClientMessage();

    @Message(id=5046, value="Invalid client message")
    public AuthenticationMechanismException mechInvalidClientMessageWithCause(@Cause Throwable var1);

    @Message(id=5047, value="[%s] Authentication mechanism message is for mismatched mechanism \"%s\"")
    public AuthenticationMechanismException mechUnmatchedMechanism(String var1, String var2);

    @Message(id=5049, value="Server authenticity cannot be verified")
    public AuthenticationMechanismException mechServerAuthenticityCannotBeVerified();

    @Message(id=5050, value="Callback handler does not support user name")
    public AuthenticationMechanismException mechCallbackHandlerDoesNotSupportUserName(@Cause Throwable var1);

    @Message(id=5051, value="Callback handler does not support credential acquisition")
    public AuthenticationMechanismException mechCallbackHandlerDoesNotSupportCredentialAcquisition(@Cause Throwable var1);

    @Message(id=5052, value="Callback handler does not support authorization")
    public AuthenticationMechanismException mechAuthorizationUnsupported(@Cause Throwable var1);

    @Message(id=5053, value="Callback handler failed for unknown reason")
    public AuthenticationMechanismException mechCallbackHandlerFailedForUnknownReason(@Cause Throwable var1);

    @Message(id=5055, value="Authentication rejected (invalid proof)")
    public AuthenticationMechanismException mechAuthenticationRejectedInvalidProof();

    @Message(id=5056, value="Client sent extra message")
    public AuthenticationMechanismException mechClientSentExtraMessage();

    @Message(id=5057, value="Server sent extra message")
    public AuthenticationMechanismException mechServerSentExtraMessage();

    @Message(id=5058, value="Authentication failed")
    public AuthenticationMechanismException mechAuthenticationFailed();

    @Message(id=5060, value="Empty number")
    public NumberFormatException emptyNumber();

    @Message(id=5061, value="Invalid numeric character")
    public NumberFormatException invalidNumericCharacter();

    @Message(id=5062, value="Too big number")
    public NumberFormatException tooBigNumber();

    @Message(id=5063, value="Cannot get clear password from two way password")
    public AuthenticationMechanismException mechCannotGetTwoWayPasswordChars(@Cause Throwable var1);

    @Message(id=5064, value="Hashing algorithm not supported")
    public AuthenticationMechanismException mechMacAlgorithmNotSupported(@Cause Throwable var1);

    @Message(id=5065, value="keyword cannot be empty")
    public AuthenticationMechanismException mechKeywordCannotBeEmpty();

    @Message(id=5066, value="No value found for keyword: %s")
    public AuthenticationMechanismException mechNoValueFoundForKeyword(String var1);

    @Message(id=5067, value="'=' expected after keyword: %s")
    public AuthenticationMechanismException mechKeywordNotFollowedByEqual(String var1);

    @Message(id=5068, value="Unmatched quote found for value: %s")
    public AuthenticationMechanismException mechUnmatchedQuoteFoundForValue(String var1);

    @Message(id=5069, value="Expecting comma or linear whitespace after quoted string: %s")
    public AuthenticationMechanismException mechExpectingCommaOrLinearWhitespaceAfterQuoted(String var1);

    @Message(id=5070, value="MessageType must equal to %d, but it is %d")
    public AuthenticationMechanismException mechMessageTypeMustEqual(int var1, int var2);

    @Message(id=5071, value="Bad sequence number while unwrapping: expected %d, but %d received")
    public AuthenticationMechanismException mechBadSequenceNumberWhileUnwrapping(int var1, int var2);

    @Message(id=5072, value="Problem during crypt")
    public AuthenticationMechanismException mechProblemDuringCrypt(@Cause Throwable var1);

    @Message(id=5073, value="Problem during decrypt")
    public AuthenticationMechanismException mechProblemDuringDecrypt(@Cause Throwable var1);

    @Message(id=5074, value="Unknown cipher \"%s\"")
    public AuthenticationMechanismException mechUnknownCipher(String var1);

    @Message(id=5075, value="Authorization ID changed unexpectedly")
    public AuthenticationMechanismException mechAuthorizationIdChanged();

    @Message(id=5076, value="Problem getting required cipher. Check your transformation mapper settings.")
    public AuthenticationMechanismException mechProblemGettingRequiredCipher(@Cause Throwable var1);

    @Message(id=5077, value="No common protection layer between client and server")
    public AuthenticationMechanismException mechNoCommonProtectionLayer();

    @Message(id=5078, value="No common cipher between client and server")
    public AuthenticationMechanismException mechNoCommonCipher();

    @Message(id=5079, value="No ciphers offered by server")
    public AuthenticationMechanismException mechNoCiphersOfferedByServer();

    @Message(id=5080, value="Callback handler not provided user name")
    public AuthenticationMechanismException mechNotProvidedUserName();

    @Message(id=5083, value="Missing \"%s\" directive")
    public AuthenticationMechanismException mechMissingDirective(String var1);

    @Message(id=5084, value="nonce-count must equal to %d, but it is %d")
    public AuthenticationMechanismException mechNonceCountMustEqual(int var1, int var2);

    @Message(id=5085, value="Server is set to not support %s charset")
    public AuthenticationMechanismException mechUnsupportedCharset(String var1);

    @Message(id=5086, value="Charset can be only \"utf-8\" or unspecified (to use ISO 8859-1)")
    public AuthenticationMechanismException mechUnknownCharset();

    @Message(id=5087, value="Client selected realm not offered by server (%s)")
    public AuthenticationMechanismException mechDisallowedClientRealm(String var1);

    @Message(id=5088, value="digest-uri \"%s\" not accepted")
    public AuthenticationMechanismException mechMismatchedWrongDigestUri(String var1);

    @Message(id=5089, value="Unexpected qop value: \"%s\"")
    public AuthenticationMechanismException mechUnexpectedQop(String var1);

    @Message(id=5090, value="Wrapping is not configured")
    public IllegalStateException wrappingNotConfigured();

    @Message(id=5091, value="Authentication name string is too long")
    public AuthenticationMechanismException mechAuthenticationNameTooLong();

    @Message(id=5092, value="Authentication name is empty")
    public AuthenticationMechanismException mechAuthenticationNameIsEmpty();

    @Message(id=5093, value="Authorization for anonymous access is denied")
    public AuthenticationMechanismException mechAnonymousAuthorizationDenied();

    @Message(id=5094, value="Required padded length (%d) is less than length of conversion result (%d)")
    public IllegalArgumentException requiredNegativePadding(int var1, int var2);

    @Message(id=5095, value="Invalid key provided for Digest HMAC computing")
    public AuthenticationMechanismException mechInvalidKeyForDigestHMAC();

    @Message(id=5096, value="Unable to read certificate from URL \"%s\"")
    public IOException asnUnableToReadCertificateFromUrl(String var1, @Cause Throwable var2);

    @Message(id=5097, value="Unable to determine subject name from X.509 certificate")
    public IllegalStateException unableToDetermineSubjectName(@Cause Throwable var1);

    @Message(id=5098, value="Unable to verify client signature")
    public AuthenticationMechanismException mechUnableToVerifyClientSignature(@Cause Throwable var1);

    @Message(id=5099, value="Unable to verify server signature")
    public AuthenticationMechanismException mechUnableToVerifyServerSignature(@Cause Throwable var1);

    @Message(id=5101, value="Callback handler not provided server certificate")
    public AuthenticationMechanismException mechCallbackHandlerNotProvidedServerCertificate();

    @Message(id=5102, value="Callback handler not provided client certificate")
    public AuthenticationMechanismException mechCallbackHandlerNotProvidedClientCertificate();

    @Message(id=5103, value="Server identifier mismatch")
    public AuthenticationMechanismException mechServerIdentifierMismatch();

    @Message(id=5104, value="Client identifier mismatch")
    public AuthenticationMechanismException mechClientIdentifierMismatch();

    @Message(id=5105, value="Unable to determine client name")
    public AuthenticationMechanismException mechUnableToDetermineClientName(@Cause Throwable var1);

    @Message(id=5106, value="Callback handler not provided private key")
    public AuthenticationMechanismException mechCallbackHandlerNotProvidedPrivateKey();

    @Message(id=5107, value="Unable to create signature")
    public AuthenticationMechanismException mechUnableToCreateSignature(@Cause Throwable var1);

    @Message(id=5108, value="Unable to create response token")
    public AuthenticationMechanismException mechUnableToCreateResponseToken(@Cause Throwable var1);

    @Message(id=5109, value="Unable to create response token")
    public AuthenticationMechanismException mechUnableToCreateResponseTokenWithCause(@Cause Throwable var1);

    @Message(id=5110, value="Invalid value for trusted authority type; expected a value between 0 and 4 (inclusive)")
    public IllegalArgumentException invalidValueForTrustedAuthorityType();

    @Message(id=5111, value="Invalid value for a general name type; expected a value between 0 and 8 (inclusive)")
    public IllegalArgumentException invalidValueForGeneralNameType();

    @Message(id=5112, value="Getting authentication mechanisms supported by GSS-API failed")
    public AuthenticationMechanismException mechGettingSupportedMechanismsFailed(@Cause Throwable var1);

    @Message(id=5113, value="Unable to initialize OID of Kerberos V5")
    public RuntimeException unableToInitialiseOid(@Cause Throwable var1);

    @Message(id=5114, value="Receive buffer requested '%d' is greater than supported maximum '%d'")
    public AuthenticationMechanismException mechReceiveBufferIsGreaterThanMaximum(int var1, int var2);

    @Message(id=5115, value="Unable to wrap message")
    public AuthenticationMechanismException mechUnableToWrapMessage(@Cause Throwable var1);

    @Message(id=5116, value="Unable to unwrap message")
    public AuthenticationMechanismException mechUnableToUnwrapMessage(@Cause Throwable var1);

    @Message(id=5117, value="Unable to unwrap security layer negotiation message")
    public AuthenticationMechanismException mechUnableToUnwrapSecurityLayerNegotiationMessage(@Cause Throwable var1);

    @Message(id=5118, value="Invalid message of length %d on unwrapping")
    public AuthenticationMechanismException mechInvalidMessageOnUnwrapping(int var1);

    @Message(id=5119, value="Negotiated mechanism was not Kerberos V5")
    public AuthenticationMechanismException mechNegotiatedMechanismWasNotKerberosV5();

    @Message(id=5120, value="Insufficient levels of protection available for supported security layers")
    public AuthenticationMechanismException mechInsufficientQopsAvailable();

    @Message(id=5121, value="Unable to generate security layer challenge")
    public AuthenticationMechanismException mechUnableToGenerateChallenge(@Cause Throwable var1);

    @Message(id=5122, value="Client selected a security layer that was not offered by server")
    public AuthenticationMechanismException mechSelectedUnofferedQop();

    @Message(id=5123, value="No security layer selected but message length received")
    public AuthenticationMechanismException mechNoSecurityLayerButLengthReceived();

    @Message(id=5124, value="Unable to get maximum size of message before wrap")
    public AuthenticationMechanismException mechUnableToGetMaximumSizeOfMessage(@Cause Throwable var1);

    @Message(id=5125, value="Unable to handle response from server")
    public AuthenticationMechanismException mechUnableToHandleResponseFromServer(@Cause Throwable var1);

    @Message(id=5126, value="Bad length of message for negotiating security layer")
    public AuthenticationMechanismException mechBadLengthOfMessageForNegotiatingSecurityLayer();

    @Message(id=5127, value="No security layer supported by server but maximum message size received: \"%d\"")
    public AuthenticationMechanismException mechReceivedMaxMessageSizeWhenNoSecurityLayer(int var1);

    @Message(id=5128, value="Failed to read challenge file")
    public AuthenticationMechanismException mechFailedToReadChallengeFile(@Cause Throwable var1);

    @Message(id=5129, value="Failed to create challenge file")
    public AuthenticationMechanismException mechFailedToCreateChallengeFile(@Cause Throwable var1);

    @Message(id=5130, value="Invalid non-ASCII space \"0x%X\"")
    public IllegalArgumentException invalidNonAsciiSpace(int var1);

    @Message(id=5131, value="Invalid ASCII control \"0x%X\"")
    public IllegalArgumentException invalidAsciiControl(int var1);

    @Message(id=5132, value="Invalid non-ASCII control \"0x%X\"")
    public IllegalArgumentException invalidNonAsciiControl(int var1);

    @Message(id=5133, value="Invalid private use character \"0x%X\"")
    public IllegalArgumentException invalidPrivateUseCharacter(int var1);

    @Message(id=5134, value="Invalid non-character code point \"0x%X\"")
    public IllegalArgumentException invalidNonCharacterCodePoint(int var1);

    @Message(id=5135, value="Invalid surrogate code point \"0x%X\"")
    public IllegalArgumentException invalidSurrogateCodePoint(int var1);

    @Message(id=5136, value="Invalid plain text code point \"0x%X\"")
    public IllegalArgumentException invalidPlainTextCodePoint(int var1);

    @Message(id=5137, value="Invalid non-canonical code point \"0x%X\"")
    public IllegalArgumentException invalidNonCanonicalCodePoint(int var1);

    @Message(id=5138, value="Invalid control character \"0x%X\"")
    public IllegalArgumentException invalidControlCharacter(int var1);

    @Message(id=5139, value="Invalid tagging character \"0x%X\"")
    public IllegalArgumentException invalidTaggingCharacter(int var1);

    @Message(id=5140, value="Unassigned code point \"0x%X\"")
    public IllegalArgumentException unassignedCodePoint(int var1);

    @Message(id=5141, value="Invalid surrogate pair (high at end of string) \"0x%X\"")
    public IllegalArgumentException invalidSurrogatePairHightAtEnd(char var1);

    @Message(id=5142, value="Invalid surrogate pair (second is not low) \"0x%X 0x%X\"")
    public IllegalArgumentException invalidSurrogatePairSecondIsNotLow(char var1, char var2);

    @Message(id=5143, value="Invalid surrogate pair (low without high) \"0x%X\"")
    public IllegalArgumentException invalidSurrogatePairLowWithoutHigh(char var1);

    @Message(id=5144, value="Invalid code point \"0x%X\"")
    public IllegalArgumentException invalidCodePoint(int var1);

    @Message(id=5145, value="Disallowed R/AL directionality character in L string")
    public IllegalArgumentException disallowedRalDirectionalityInL();

    @Message(id=5146, value="Disallowed L directionality character in R/AL string")
    public IllegalArgumentException disallowedLDirectionalityInRal();

    @Message(id=5147, value="Missing trailing R/AL directionality character")
    public IllegalArgumentException missingTrailingRal();

    @Message(id=5148, value="Invalid escape sequence")
    public IllegalArgumentException invalidEscapeSequence();

    @Message(id=5150, value="Authentication mechanism authorization ID is too long")
    public AuthenticationMechanismException mechAuthorizationIdTooLong();

    @Message(id=5151, value="Invalid OTP algorithm \"%s\"")
    public AuthenticationMechanismException mechInvalidOTPAlgorithm(String var1);

    @Message(id=5152, value="Invalid OTP response type")
    public AuthenticationMechanismException mechInvalidOTPResponseType();

    @Message(id=5153, value="Incorrect parity in SASL client message")
    public AuthenticationMechanismException mechIncorrectParity();

    @Message(id=5154, value="Invalid character in seed")
    public AuthenticationMechanismException mechInvalidCharacterInSeed();

    @Message(id=5155, value="Invalid OTP seed, must be between 1 and 16 characters long")
    public AuthenticationMechanismException mechInvalidOTPSeed();

    @Message(id=5156, value="Invalid OTP pass phrase, must be between 10 and 63 characters long")
    public AuthenticationMechanismException mechInvalidOTPPassPhrase();

    @Message(id=5157, value="Invalid OTP sequence number")
    public AuthenticationMechanismException mechInvalidOTPSequenceNumber();

    @Message(id=5158, value="Invalid OTP")
    public AuthenticationMechanismException mechInvalidOTP();

    @Message(id=5159, value="OTP pass phrase and seed must not match")
    public AuthenticationMechanismException mechOTPPassPhraseAndSeedMustNotMatch();

    @Message(id=5160, value="Invalid OTP alternate dictionary")
    public AuthenticationMechanismException mechInvalidOTPAlternateDictionary();

    @Message(id=5161, value="Unable to retrieve password for \"%s\"")
    public AuthenticationMechanismException mechUnableToRetrievePassword(String var1);

    @Message(id=5162, value="Unable to update password for \"%s\"")
    public AuthenticationMechanismException mechUnableToUpdatePassword(String var1);

    @Message(id=5163, value="Authentication mechanism server timed out")
    public AuthenticationMechanismException mechServerTimedOut();

    @Message(id=5164, value="Unable to obtain exclusive access for \"%s\"")
    public AuthenticationMechanismException mechUnableToObtainExclusiveAccess(String var1);

    @Message(id=5165, value="OTP re-initialization failed")
    public AuthenticationMechanismException mechOTPReinitializationFailed(@Cause Throwable var1);

    @Message(id=5166, value="Server rejected authentication")
    public ScramServerException scramServerRejectedAuthentication(@Param ScramServerErrorCode var1);

    @Message(id=5167, value="Invalid OTP password format type")
    public AuthenticationMechanismException mechInvalidOTPPasswordFormatType();

    @Message(id=5168, value="Unsupported algorithm selected \"%s\"")
    public AuthenticationMechanismException mechUnsupportedAlgorithm(String var1);

    @Message(id=5169, value="[%s] Clients response token does not match expected token")
    public String mechResponseTokenMismatch(String var1);

    @Message(id=5170, value="Problem during crypt: The encrypted result is null. The input data has a length of zero or too short to result in a new block.")
    public AuthenticationMechanismException mechProblemDuringCryptResultIsNull();

    @Message(id=5171, value="Problem during decrypt: The decrypted result is null. The input data has a length of zero or too short to result in a new block.")
    public AuthenticationMechanismException mechProblemDuringDecryptResultIsNull();

    @Message(id=5172, value="Unable to locate MechanismConfiguration for mechanism.")
    public AuthenticationMechanismException unableToLocateMechanismConfiguration(@Cause Throwable var1);

    @Message(id=5173, value="Unable to obtain server credential.")
    public AuthenticationMechanismException unableToObtainServerCredential();

    @Message(id=5174, value="Callback handler has not chosen realm")
    public AuthenticationMechanismException mechNotChosenRealm();

    @Message(id=5175, value="Unable to determine bound server name")
    public AuthenticationMechanismException mechUnableToDetermineBoundServerName(@Cause Exception var1);

    @Message(id=5176, value="Unsupported callback")
    public AuthenticationMechanismException mechCallbackHandlerUnsupportedCallback(@Cause Throwable var1);

    @Message(id=5177, value="One of \"%s\" and \"%s\" directives has to be defined")
    public AuthenticationMechanismException mechOneOfDirectivesHasToBeDefined(String var1, String var2);

    @Message(id=6000, value="Status code can not be set at this time.")
    public IllegalStateException statusCodeNotNow();

    @Message(id=6001, value="An incorrectly formatted '%s'header was encountered.")
    public String incorrectlyFormattedHeader(String var1);

    @Message(id=6002, value="An authentication attempt for user '%s' failed validation using mechanism '%s'.")
    public String authenticationFailed(String var1, String var2);

    @Message(id=6003, value="An authentication attempt failed validation.")
    public String authenticationFailed();

    @Message(id=6005, value="Attachments are not supported on this scope.")
    public UnsupportedOperationException noAttachmentSupport();

    @Message(id=6006, value="An authorization check for user '%s' failed.")
    public String authorizationFailed(String var1);

    @Message(id=6007, value="Username or password missing from authentication attempt.")
    public String usernameOrPasswordMissing();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=6008, value="Failed to logout participant [%s]. Participant will be removed from list of participants but its local session may still be active.")
    public void warnHttpMechSsoFailedLogoutParticipant(String var1, @Cause Throwable var2);

    @Message(id=6012, value="Invalid logout message received for local session [%s]")
    public IllegalStateException httpMechSsoInvalidLogoutMessage(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=6013, value="Failed to invalidate local session")
    public void errorHttpMechSsoFailedInvalidateLocalSession(@Cause Throwable var1);

    @Message(id=6014, value="Authentication mechanism '%s' cannot be found")
    public HttpAuthenticationException httpServerAuthenticationMechanismNotFound(String var1);

    @Message(id=6015, value="Unable to authenticate using DIGEST mechanism - realm name needs to be specified")
    public HttpAuthenticationException digestMechanismRequireRealm();

    @Message(id=6016, value="HTTP authentication failed validating request, no mechanisms remain to continue authentication.")
    public HttpAuthenticationException httpAuthenticationFailedEvaluatingRequest();

    @Message(id=6017, value="HTTP authentication is required but no authentication mechansims are available.")
    public HttpAuthenticationException httpAuthenticationNoMechanisms();

    @Message(id=6018, value="HTTP authentication none of the responders successfuly sent a response.")
    public HttpAuthenticationException httpAuthenticationNoSuccessfulResponder();

    @Message(id=6019, value="Unable to authenticate using DIGEST mechanism - mechanism realm name (%s) is not valid")
    public HttpAuthenticationException digestMechanismInvalidRealm(String var1);

    @Message(id=6020, value="Scope unsuitable for use with authentication state '%s'")
    public IllegalArgumentException unsuitableScope(String var1);

    @Message(id=6021, value="Unable to identify suitable HttpScope for mechanism state storage")
    public IllegalArgumentException unableToIdentifyHttpScope();

    @Message(id=6022, value="Invalid nonce count %s")
    public HttpAuthenticationException invalidNonceCount(int var1);

    @Message(id=7001, value="Unrecognized encoding algorithm [%s]")
    public ASN1Exception asnUnrecognisedAlgorithm(String var1);

    @Message(id=7002, value="Invalid general name type")
    public ASN1Exception asnInvalidGeneralNameType();

    @Message(id=7004, value="Unexpected ASN.1 tag encountered")
    public ASN1Exception asnUnexpectedTag();

    @Message(id=7005, value="Unable to read X.509 certificate data")
    public ASN1Exception asnUnableToReadCertificateData(@Cause Throwable var1);

    @Message(id=7006, value="Invalid general name for URI type")
    public ASN1Exception asnInvalidGeneralNameForUriType(@Cause Throwable var1);

    @Message(id=7007, value="Invalid general name for IP address type")
    public ASN1Exception asnInvalidGeneralNameForIpAddressType();

    @Message(id=7008, value="IP address general name cannot be resolved")
    public ASN1Exception asnIpAddressGeneralNameCannotBeResolved(@Cause Throwable var1);

    @Message(id=7009, value="No sequence to end")
    public IllegalStateException noSequenceToEnd();

    @Message(id=7010, value="No set to end")
    public IllegalStateException noSetToEnd();

    @Message(id=7011, value="No explicitly tagged element to end")
    public IllegalStateException noExplicitlyTaggedElementToEnd();

    @Message(id=7012, value="Unexpected end of input")
    public ASN1Exception asnUnexpectedEndOfInput();

    @Message(id=7013, value="Invalid number of unused bits")
    public ASN1Exception asnInvalidNumberOfUnusedBits();

    @Message(id=7014, value="Non-zero length encountered for null type tag")
    public ASN1Exception asnNonZeroLengthForNullTypeTag();

    @Message(id=7015, value="Invalid high-tag-number form")
    public ASN1Exception asnInvalidHighTagNumberForm();

    @Message(id=7016, value="Length encoding exceeds 4 bytes")
    public ASN1Exception asnLengthEncodingExceeds4bytes();

    @Message(id=7017, value="Invalid OID character")
    public ASN1Exception asnInvalidOidCharacter();

    @Message(id=7018, value="OID must have at least 2 components")
    public ASN1Exception asnOidMustHaveAtLeast2Components();

    @Message(id=7019, value="Invalid value for first OID component; expected 0, 1, or 2")
    public ASN1Exception asnInvalidValueForFirstOidComponent();

    @Message(id=7020, value="Invalid value for second OID component; expected a value between 0 and 39 (inclusive)")
    public ASN1Exception asnInvalidValueForSecondOidComponent();

    @Message(id=7021, value="Invalid length")
    public ASN1Exception asnInvalidLength();

    @Message(id=7022, value="Unknown tag type: %d")
    public ASN1Exception asnUnknownTagType(int var1);

    @Message(id=7023, value="Unexpected character byte for printable string")
    public ASN1Exception asnUnexpectedCharacterByteForPrintableString();

    @Message(id=7024, value="Invalid length encountered for boolean type tag")
    public ASN1Exception asnInvalidLengthForBooleanTypeTag();

    @Message(id=7025, value="Invalid general name for URI type: missing scheme")
    public ASN1Exception asnInvalidGeneralNameForUriTypeMissingScheme();

    @Message(id=8001, value="Unrecognized key spec algorithm")
    public InvalidKeySpecException invalidKeySpecUnrecognizedKeySpecAlgorithm();

    @Message(id=8002, value="Password spec cannot be rendered as a string")
    public InvalidKeySpecException invalidKeySpecPasswordSpecCannotBeRenderedAsString();

    @Message(id=8003, value="Unknown crypt string algorithm")
    public InvalidKeySpecException invalidKeySpecUnknownCryptStringAlgorithm();

    @Message(id=8004, value="Invalid character encountered")
    public InvalidKeySpecException invalidKeySpecInvalidCharacterEncountered();

    @Message(id=8005, value="No iteration count terminator given")
    public InvalidKeySpecException invalidKeySpecNoIterationCountTerminatorGiven();

    @Message(id=8006, value="Unexpected end of input string")
    public InvalidKeySpecException invalidKeySpecUnexpectedEndOfInputString();

    @Message(id=8007, value="No salt terminator given")
    public InvalidKeySpecException invalidKeySpecNoSaltTerminatorGiven();

    @Message(id=8008, value="Invalid hash length")
    public IllegalArgumentException invalidHashLength();

    @Message(id=8009, value="Unexpected end of password string")
    public InvalidKeySpecException invalidKeySpecUnexpectedEndOfPasswordString();

    @Message(id=8010, value="Unexpected end of password string")
    public InvalidKeySpecException invalidKeySpecUnexpectedEndOfPasswordStringWithCause(@Cause Throwable var1);

    @Message(id=8011, value="Invalid minor version")
    public InvalidKeySpecException invalidKeySpecInvalidMinorVersion();

    @Message(id=8012, value="Invalid cost: must be a two digit integer")
    public InvalidKeySpecException invalidKeySpecCostMustBeTwoDigitInteger();

    @Message(id=8013, value="No such MessageDigest algorithm for \"%s\"")
    public InvalidKeySpecException invalidKeySpecNoSuchMessageDigestAlgorithm(String var1);

    @Message(id=8014, value="No such MessageDigest algorithm for \"%s\"")
    public InvalidKeyException invalidKeyNoSuchMessageDigestAlgorithm(String var1);

    @Message(id=8015, value="Cannot verify password")
    public InvalidKeyException invalidKeyCannotVerifyPassword(@Cause Throwable var1);

    @Message(id=8017, value="DES crypt password hash must be %d bytes")
    public InvalidKeyException invalidKeyDesCryptPasswordHashMustBeBytes(int var1);

    @Message(id=8018, value="Salt must be %d bytes (%d bits)")
    public InvalidParameterSpecException invalidParameterSpecSaltMustBeBytesBits(int var1, int var2);

    @Message(id=8020, value="Invalid number of rounds. Must be an integer between %d and %d, inclusive")
    public IllegalArgumentException invalidNumberOfRoundsMustBeIntBetween(int var1, int var2);

    @Message(id=8021, value="Invalid salt: must be %d bytes long")
    public IllegalArgumentException invalidSaltMustBeBytesLong(int var1);

    @Message(id=8022, value="BSD DES crypt password hash must be %d bytes")
    public InvalidKeySpecException invalidKeySpecBsdDesCryptPasswordHashMustBeBytes(int var1);

    @Message(id=8023, value="Salt must be %d bytes")
    public InvalidParameterSpecException invalidParameterSpecSaltMustBeBytes(int var1);

    @Message(id=8024, value="BSD DES crypt password hash must be %d bytes")
    public InvalidKeyException invalidKeyBsdDesCryptPasswordHashMustBeBytes(int var1);

    @Message(id=8025, value="Expected to get a \"%s\" as spec, got \"%s\"")
    public InvalidKeySpecException invalidKeySpecExpectedSpecGotSpec(String var1, String var2);

    @Message(id=8026, value="Unknown algorithm or incompatible PasswordSpec")
    public InvalidKeySpecException invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec();

    @Message(id=8027, value="Unknown password type or algorithm")
    public InvalidKeyException invalidKeyUnknownUnknownPasswordTypeOrAlgorithm();

    @Message(id=8028, value="Invalid algorithm \"%s\"")
    public NoSuchAlgorithmException noSuchAlgorithmInvalidAlgorithm(String var1);

    @Message(id=8029, value="Could not obtain key spec encoding identifier.")
    public IllegalArgumentException couldNotObtainKeySpecEncodingIdentifier();

    @Message(id=8030, value="Failed to encode parameter specification")
    public InvalidParameterSpecException failedToEncode(@Cause Throwable var1);

    @Message(id=8031, value="Failed to decode parameter specification")
    public IOException failedToDecode(@Cause Throwable var1);

    @Message(id=8032, value="Invalid parameter specification type (expected %s, got %s)")
    public InvalidParameterSpecException invalidParameterSpec(Class<?> var1, Class<?> var2);

    @Message(id=8033, value="Invalid format given (expected %s, got %s)")
    public IOException invalidFormat(String var1, String var2);

    @Message(id=8034, value="Algorithm parameters instance not initialized")
    public IllegalStateException algorithmParametersNotInitialized();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=8500, value="Failed to check permissions for protection domain [%s] and permission [%s].")
    public void authzFailedToCheckPermission(ProtectionDomain var1, Permission var2, @Cause Throwable var3);

    @Message(id=8501, value="Invalid state [%s] for operation.")
    public UnsupportedOperationException authzInvalidStateForOperation(String var1);

    @Message(id=8502, value="Can't link policy configuration [%s] to itself.")
    public IllegalArgumentException authzLinkSamePolicyConfiguration(String var1);

    @Message(id=8503, value="ContextID not set. Check if the context id was set using PolicyContext.setContextID.")
    public IllegalStateException authzContextIdentifierNotSet();

    @Message(id=8504, value="Invalid policy context identifier [%s].")
    public IllegalArgumentException authzInvalidPolicyContextIdentifier(String var1);

    @Message(id=8505, value="Could not obtain PolicyConfiguration for contextID [%s].")
    public PolicyContextException authzUnableToObtainPolicyConfiguration(String var1, @Cause Throwable var2);

    @Message(id=8506, value="Policy configuration with contextID [%s] is not in service state.")
    public IllegalStateException authzPolicyConfigurationNotInService(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8508, value="Could not obtain authorized identity.")
    public void authzCouldNotObtainSecurityIdentity(@Cause Throwable var1);

    @Message(id=8510, value="Role mapper has already been initialized.")
    public IllegalStateException roleMappedAlreadyInitialized();

    @Message(id=8511, value="Role mapper hasn't been initialized yet.")
    public IllegalStateException roleMappedNotInitialized();

    @Message(id=9000, value="Public and private key parameters are mismatched")
    public IllegalArgumentException mismatchedPublicPrivateKeyParameters();

    @Message(id=9001, value="Client credentials not provided")
    public IllegalStateException oauth2ClientCredentialsNotProvided();

    @Message(id=9500, value="External storage key under alias \"%s\" has to be a SecretKey")
    public CredentialStoreException wrongTypeOfExternalStorageKey(String var1);

    @Message(id=9501, value="Duplicate attribute (\"%s\") found in configuration.")
    public ConfigXMLParseException duplicateAttributeFound(@Param XMLStreamReader var1, String var2);

    @Message(id=9502, value="Duplicate credential store name found in configuration \"%s\"")
    public ConfigXMLParseException duplicateCredentialStoreName(@Param XMLStreamReader var1, String var2);

    @Message(id=9503, value="Credential store name \"%s\" not defined")
    public ConfigXMLParseException xmlCredentialStoreNameNotDefined(@Param Location var1, String var2);

    @Message(id=9504, value="Cannot acquire a credential from the credential store")
    public CredentialStoreException cannotAcquireCredentialFromStore(@Cause Throwable var1);

    @Message(id=9505, value="Cannot perform operation '%s': Credential store is set non modifiable")
    public CredentialStoreException nonModifiableCredentialStore(String var1);

    @Message(id=9506, value="Credential store command interrupted")
    public InterruptedIOException credentialCommandInterrupted();

    @Message(id=9507, value="Invalid protection parameter given: %s")
    public CredentialStoreException invalidProtectionParameter(CredentialStore.ProtectionParameter var1);

    @Message(id=9508, value="Cannot write credential to store")
    public CredentialStoreException cannotWriteCredentialToStore(@Cause Throwable var1);

    @Message(id=9509, value="Unsupported credential type %s")
    public UnsupportedCredentialTypeException unsupportedCredentialType(Class<?> var1);

    @Message(id=9510, value="Invalid credential store keystore entry %s: expected %s")
    public CredentialStoreException invalidCredentialStoreEntryType(Class<? extends KeyStore.Entry> var1, Class<? extends KeyStore.Entry> var2);

    @Message(id=9511, value="Unable to read credential %s from store")
    public CredentialStoreException unableToReadCredentialTypeFromStore(Class<? extends Credential> var1);

    @Message(id=9512, value="Unable to remove credential from store")
    public CredentialStoreException cannotRemoveCredentialFromStore(@Cause Throwable var1);

    @Message(id=9513, value="Unable to flush credential store to storage")
    public CredentialStoreException cannotFlushCredentialStore(@Cause Throwable var1);

    @Message(id=9514, value="Unable to initialize credential store")
    public CredentialStoreException cannotInitializeCredentialStore(@Cause Throwable var1);

    @Message(id=9515, value="Ignored unrecognized key store entry \"%s\"")
    @LogMessage(level=Logger.Level.DEBUG)
    public void logIgnoredUnrecognizedKeyStoreEntry(String var1);

    @Message(id=9516, value="Failed to read a credential entry from the key store")
    @LogMessage(level=Logger.Level.WARN)
    public void logFailedToReadKeyFromKeyStore(@Cause Throwable var1);

    @Message(id=9517, value="This credential store type requires a store-wide protection parameter")
    public CredentialStoreException protectionParameterRequired();

    @Message(id=9518, value="Automatic storage creation for the Credential Store is disabled \"%s\"")
    public CredentialStoreException automaticStorageCreationDisabled(String var1);

    @Message(id=9519, value="Unexpected credential store external storage file version \"%s\"")
    public IOException unexpectedFileVersion(String var1);

    @Message(id=9520, value="Unrecognized entry type \"%s\"")
    public IOException unrecognizedEntryType(String var1);

    @Message(id=9521, value="Internal encryption problem while reading \"%s\"")
    public IOException internalEncryptionProblem(@Cause Exception var1, String var2);

    @Message(id=9522, value="\"%s\" is not a block based algorithm")
    public CredentialStoreException algorithmNotBlockBased(String var1);

    @Message(id=9523, value="Algorithm \"%s\" does not use an initialization vector (IV)")
    public CredentialStoreException algorithmNotIV(String var1);

    @Message(id=9524, value="The actual number of bytes read %d is different from the expected number of bytes %d to be read")
    public IOException readBytesMismatch(int var1, int var2);

    @Message(id=9525, value="location and externalPath initial attributes are the same. [location=%s, externalPath=%s]")
    public CredentialStoreException locationAndExternalPathAreIdentical(String var1, String var2);

    @Message(id=9526, value="Unable to initialize credential store as attribute %s is unsupported in %s")
    public CredentialStoreException unsupportedAttribute(String var1, List<String> var2);

    @Message(id=9527, value="Invalid credential store reference")
    public ConfigXMLParseException xmlInvalidCredentialStoreRef(@Param Location var1);

    @Message(id=9528, value="The externalPath attribute for key store type %s is missing.")
    public CredentialStoreException externalPathMissing(String var1);

    @Message(id=10000, value="X.509 certificate extension with OID %s already exists")
    public IllegalArgumentException extensionAlreadyExists(String var1);

    @Message(id=10001, value="No signature algorithm name given")
    public IllegalArgumentException noSignatureAlgorithmNameGiven();

    @Message(id=10002, value="Signature algorithm name \"%s\" is not recognized")
    public IllegalArgumentException unknownSignatureAlgorithmName(String var1);

    @Message(id=10003, value="No signing key given")
    public IllegalArgumentException noSigningKeyGiven();

    @Message(id=10004, value="Signing key algorithm name \"%s\" is not compatible with signature algorithm name \"%s\"")
    public IllegalArgumentException signingKeyNotCompatWithSig(String var1, String var2);

    @Message(id=10005, value="Not-valid-before date of %s is after not-valid-after date of %s")
    public IllegalArgumentException validAfterBeforeValidBefore(ZonedDateTime var1, ZonedDateTime var2);

    @Message(id=10006, value="No issuer DN given")
    public IllegalArgumentException noIssuerDnGiven();

    @Message(id=10007, value="No public key given")
    public IllegalArgumentException noPublicKeyGiven();

    @Message(id=10008, value="Issuer and subject unique ID are only allowed in certificates with version 2 or higher")
    public IllegalArgumentException uniqueIdNotAllowed();

    @Message(id=10009, value="Extensions are only allowed in certificates with version 3 or higher")
    public IllegalArgumentException extensionsNotAllowed();

    @Message(id=10010, value="X.509 encoding of public key with algorithm \"%s\" failed")
    public IllegalArgumentException invalidKeyForCert(String var1, @Cause Exception var2);

    @Message(id=10011, value="Failed to sign certificate")
    public IllegalArgumentException certSigningFailed(@Cause Exception var1);

    @Message(id=10012, value="Certificate serial number must be positive")
    public IllegalArgumentException serialNumberTooSmall();

    @Message(id=10013, value="Certificate serial number too large (cannot exceed 20 octets)")
    public IllegalArgumentException serialNumberTooLarge();

    @Message(id=10014, value="Failed to sign certification request info")
    public IllegalArgumentException certRequestInfoSigningFailed(@Cause Exception var1);

    @Message(id=10015, value="No certificate given")
    public IllegalArgumentException noCertificateGiven();

    @Message(id=10016, value="Unable to determine key size")
    public IllegalArgumentException unableToDetermineKeySize();

    @Message(id=10017, value="No DN given")
    public IllegalArgumentException noDnGiven();

    @Message(id=10018, value="Failed to generate self-signed X.509 certificate")
    public IllegalArgumentException selfSignedCertificateGenerationFailed(@Cause Exception var1);

    @Message(id=10019, value="Unable to determine default compatible signature algorithm name for key algorithm name \"%s\"")
    public IllegalArgumentException unableToDetermineDefaultCompatibleSignatureAlgorithmName(String var1);

    @Message(id=10020, value="Creating an X.509 certificate extension from a string value is not supported for extension name \"%s\"")
    public IllegalArgumentException certificateExtensionCreationFromStringNotSupported(String var1);

    @Message(id=10021, value="Invalid X.509 certificate extension string value \"%s\"")
    public IllegalArgumentException invalidCertificateExtensionStringValue(String var1);

    @Message(id=10022, value="Failed to create X.509 certificate extension from string value")
    public IllegalArgumentException certificateExtensionCreationFromStringFailed(@Cause Exception var1);

    @Message(id=10023, value="X.509 certificate extension \"%s\" must be non-critical")
    public IllegalArgumentException certificateExtensionMustBeNonCritical(String var1);

    @Message(id=10024, value="Invalid X.509 certificate extension string value")
    public IllegalArgumentException invalidCertificateExtensionStringValue();

    @Message(id=10025, value="Non-X.509 certificate found in certificate array")
    public IllegalArgumentException nonX509CertificateInCertificateArray();

    @Message(id=10026, value="Starting public key not found in certificate array")
    public IllegalArgumentException startingPublicKeyNotFoundInCertificateArray();

    @Message(id=10027, value="Incomplete certificate array")
    public IllegalArgumentException incompleteCertificateArray();

    @Message(id=10028, value="Unable to create X.509 certificate chain from map of certificates")
    public IllegalArgumentException unableToCreateCertificateChainFromCertificateMap();

    @Message(id=10029, value="Failed to generate ACME account key pair")
    public IllegalArgumentException acmeAccountKeyPairGenerationFailed(@Cause Exception var1);

    @Message(id=10030, value="No ACME server URL given")
    public IllegalArgumentException noAcmeServerUrlGiven();

    @Message(id=10031, value="Unsupported ACME account signature algorithm \"%s\"")
    public IllegalArgumentException unsupportedAcmeAccountSignatureAlgorithm(String var1);

    @Message(id=10032, value="Unable to create ACME signature")
    public IllegalArgumentException unableToCreateAcmeSignature(@Cause Exception var1);

    @Message(id=10033, value="Unable to retrieve ACME server directory URLs")
    public AcmeException unableToRetrieveAcmeServerDirectoryUrls(@Cause Exception var1);

    @Message(id=10034, value="No nonce provided by ACME server")
    public AcmeException noNonceProvidedByAcmeServer();

    @Message(id=10035, value="No account location URL provided by ACME server")
    public AcmeException noAccountLocationUrlProvidedByAcmeServer();

    @Message(id=10036, value="Unable to obtain new nonce from ACME server")
    public AcmeException unableToObtainNewNonceFromAcmeServer();

    @Message(id=10037, value="Unable to obtain JSON response from ACME server")
    public AcmeException unableToObtainJsonResponseFromAcmeServer(@Cause Exception var1);

    @Message(id=10038, value="Unexpected HTTP status code in response from ACME server \"%d\": \"%s\"")
    public AcmeException unexpectedResponseCodeFromAcmeServer(int var1, String var2);

    @Message(id=10039, value="Bad ACME replay nonce, maximum retries attempted")
    public AcmeException badAcmeNonce();

    @Message(id=10040, value="Unexpected content type in response from ACME server \"%s\"")
    public AcmeException unexpectedContentTypeFromAcmeServer(String var1);

    @Message(id=10041, value="Invalid content type in response from ACME server")
    public AcmeException invalidContentTypeFromAcmeServer();

    @Message(id=10042, value="Domain name is null")
    public AcmeException domainNameIsNull();

    @Message(id=10043, value="Domain names is empty")
    public AcmeException domainNamesIsEmpty();

    @Message(id=10044, value="No certificate URL provided by ACME server")
    public AcmeException noCertificateUrlProvidedByAcmeServer();

    @Message(id=10045, value="No certificate will be issued by the ACME server")
    public AcmeException noCertificateWillBeIssuedByAcmeServer();

    @Message(id=10046, value="Unable to get encoded form of certificate to be revoked")
    public AcmeException unableToGetEncodedFormOfCertificateToBeRevoked(@Cause Exception var1);

    @Message(id=10047, value="Unable to determine key authorization string")
    public AcmeException unableToDetermineKeyAuthorizationString(@Cause Exception var1);

    @Message(id=10048, value="Challenge response failed validation by the ACME server")
    public AcmeException challengeResponseFailedValidationByAcmeServer();

    @Message(id=10049, value="Unable to download certificate chain from ACME server")
    public AcmeException unableToDownloadCertificateChainFromAcmeServer(@Cause Exception var1);

    @Message(id=10050, value="ACME account does not exist")
    public AcmeException acmeAccountDoesNotExist();

    @Message(id=10051, value="User action required since the ACME server's terms of service have changed, visit \"%s\" for details")
    public AcmeException userActionRequired(String var1);

    @Message(id=10052, value="Rate limit has been exceeded, try again after \"%s\"")
    public AcmeException rateLimitExceededTryAgainLater(Instant var1);

    @Message(id=10053, value="Rate limit has been exceeded")
    public AcmeException rateLimitExceeded();

    @Message(id=10054, value="Resource not supported by the ACME server \"%s\"")
    public AcmeException resourceNotSupportedByAcmeServer(String var1);

    @Message(id=10055, value="Unsupported ACME account public key type \"%s\"")
    public IllegalArgumentException unsupportedAcmeAccountPublicKeyType(String var1);

    @Message(id=10056, value="Unable to determine curve parameter from alg header \"%s\"")
    public IllegalArgumentException unableToDetermineCurveParameterFromAlgHeader(String var1);

    @LogMessage(level=Logger.Level.FATAL)
    @Message(id=11001, value="Endpoint unable to handle SecurityEvent priority=%s, message=%s")
    public void endpointUnavaiable(String var1, String var2, @Cause Throwable var3);

    @Message(id=11002, value="Invalid EventPriority '%s' passed to AuditEndpoint.")
    public IllegalArgumentException invalidEventPriority(EventPriority var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11003, value="Unable to rotate log file")
    public void unableToRotateLogFile(@Cause Throwable var1);

    @Message(id=11004, value="Invalid suffix \"%s\" - rotating by second or millisecond is not supported")
    public IllegalArgumentException rotatingBySecondUnsupported(String var1);

    @Message(id=11005, value="Invalid unicode endoding, offending sequence: %s.")
    public IOException invalidUnicodeSequence(String var1, @Cause NoSuchElementException var2);

    @Message(id=11006, value="External storage key under alias \"%s\" does not exist")
    public CredentialStoreException externalStorageKeyDoesNotExist(String var1);

    @LogMessage(level=Logger.Level.FATAL)
    @Message(id=11007, value="Endpoint unable to accept SecurityEvent.")
    public void unableToAcceptEvent(@Cause Throwable var1);
}

