/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.embedded;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Handler;
import org.jboss.as.cli.CommandContext;
import org.jboss.logmanager.Configurator;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.PropertyConfigurator;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.wildfly.security.manager.WildFlySecurityManager;

class EmbeddedLogContext {
    EmbeddedLogContext() {
    }

    static synchronized LogContext configureLogContext(File logDir, File configDir, String defaultLogFileName, CommandContext ctx) {
        LogContext embeddedLogContext = Holder.LOG_CONTEXT;
        Path bootLog = logDir.toPath().resolve(Paths.get(defaultLogFileName, new String[0]));
        Path loggingProperties = configDir.toPath().resolve(Paths.get("logging.properties", new String[0]));
        if (Files.exists(loggingProperties, new LinkOption[0])) {
            WildFlySecurityManager.setPropertyPrivileged((String)"org.jboss.boot.log.file", (String)bootLog.toAbsolutePath().toString());
            try (InputStream in = Files.newInputStream(loggingProperties, new OpenOption[0]);){
                Configurator configurator = (Configurator)embeddedLogContext.getAttachment("", Configurator.ATTACHMENT_KEY);
                if (configurator == null) {
                    configurator = new PropertyConfigurator(embeddedLogContext);
                    Configurator existing = (Configurator)embeddedLogContext.getLogger("").attachIfAbsent(Configurator.ATTACHMENT_KEY, (Object)configurator);
                    if (existing != null) {
                        configurator = existing;
                    }
                }
                configurator.configure(in);
            }
            catch (IOException e) {
                ctx.printLine(String.format("Unable to configure logging from configuration file %s. Reason: %s", loggingProperties, e.getLocalizedMessage()));
            }
        }
        return embeddedLogContext;
    }

    static synchronized void clearLogContext() {
        LogContext embeddedLogContext = Holder.LOG_CONTEXT;
        Configurator configurator = (Configurator)embeddedLogContext.getLogger("").detach(Configurator.ATTACHMENT_KEY);
        if (configurator instanceof PropertyConfigurator) {
            LogContextConfiguration logContextConfiguration = ((PropertyConfigurator)configurator).getLogContextConfiguration();
            EmbeddedLogContext.clearLogContext(logContextConfiguration);
        } else if (configurator instanceof LogContextConfiguration) {
            EmbeddedLogContext.clearLogContext((LogContextConfiguration)configurator);
        } else {
            ArrayList<String> loggerNames = Collections.list(embeddedLogContext.getLoggerNames());
            for (String name : loggerNames) {
                Logger logger = embeddedLogContext.getLoggerIfExists(name);
                if (logger == null) continue;
                Handler[] handlers = logger.clearHandlers();
                if (handlers != null) {
                    for (Handler handler : handlers) {
                        handler.close();
                    }
                }
                logger.setFilter(null);
                logger.setUseParentFilters(false);
                logger.setUseParentHandlers(true);
                logger.setLevel((java.util.logging.Level)Level.INFO);
            }
        }
    }

    private static void clearLogContext(LogContextConfiguration logContextConfiguration) {
        try {
            for (String s5 : logContextConfiguration.getHandlerNames()) {
                logContextConfiguration.removeHandlerConfiguration(s5);
            }
            for (String s4 : logContextConfiguration.getFormatterNames()) {
                logContextConfiguration.removeFormatterConfiguration(s4);
            }
            for (String s3 : logContextConfiguration.getErrorManagerNames()) {
                logContextConfiguration.removeErrorManagerConfiguration(s3);
            }
            for (String s2 : logContextConfiguration.getPojoNames()) {
                logContextConfiguration.removePojoConfiguration(s2);
            }
            for (String s1 : logContextConfiguration.getLoggerNames()) {
                logContextConfiguration.removeLoggerConfiguration(s1);
            }
            for (String s : logContextConfiguration.getFilterNames()) {
                logContextConfiguration.removeFilterConfiguration(s);
            }
            logContextConfiguration.commit();
        }
        finally {
            logContextConfiguration.forget();
        }
    }

    private static class Holder {
        static final LogContext LOG_CONTEXT = LogContext.create();

        private Holder() {
        }
    }
}

