/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.BaseStream;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.cache.impl.Caches;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.read.AbstractCloseableIteratorCollection;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.commons.util.IteratorMapper;
import org.infinispan.commons.util.RemovableCloseableIterator;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.stream.StreamMarshalling;
import org.infinispan.stream.impl.ClusterStreamManager;
import org.infinispan.stream.impl.DistributedCacheStream;
import org.infinispan.stream.impl.tx.TxClusterStreamManager;
import org.infinispan.stream.impl.tx.TxDistributedCacheStream;
import org.infinispan.util.EntryWrapper;

public class DistributionBulkInterceptor<K, V>
extends DDAsyncInterceptor {
    @Inject
    private ComponentRef<Cache<K, V>> cache;

    @Override
    public Object visitEntrySetCommand(InvocationContext ctx, EntrySetCommand command) throws Throwable {
        if (command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL)) {
            return super.visitEntrySetCommand(ctx, command);
        }
        command.addFlags(FlagBitSets.REMOTE_ITERATION);
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            EntrySetCommand entrySetCommand = (EntrySetCommand)rCommand;
            BackingEntrySet entrySet = (BackingEntrySet)rv;
            entrySet = rCtx.isInTxScope() ? new TxBackingEntrySet(Caches.getCacheWithFlags(this.cache.wired(), entrySetCommand), entrySet, entrySetCommand, (LocalTxInvocationContext)rCtx) : new BackingEntrySet(Caches.getCacheWithFlags(this.cache.wired(), entrySetCommand), entrySet, entrySetCommand);
            return entrySet;
        });
    }

    private static <C> CacheStream<C> applyTimeOut(CacheStream<C> stream, Cache<?, ?> cache) {
        return stream.timeout(cache.getCacheConfiguration().clustering().remoteTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public Object visitKeySetCommand(InvocationContext ctx, KeySetCommand command) throws Throwable {
        if (command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL)) {
            return super.visitKeySetCommand(ctx, command);
        }
        command.addFlags(FlagBitSets.REMOTE_ITERATION);
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            BackingKeySet keySet = (BackingKeySet)rv;
            keySet = ctx.isInTxScope() ? new TxBackingKeySet<K, V>(Caches.getCacheWithFlags(this.cache.wired(), command), keySet, command, (LocalTxInvocationContext)ctx) : new BackingKeySet(Caches.getCacheWithFlags(this.cache.wired(), command), keySet, command);
            return keySet;
        });
    }

    private static class TxBackingKeySet<K, V>
    extends BackingKeySet<K, V> {
        private final LocalTxInvocationContext ctx;

        public TxBackingKeySet(Cache<K, V> cache, CacheSet<K> keySet, FlagAffectedCommand command, LocalTxInvocationContext ctx) {
            super(cache, keySet, command);
            this.ctx = ctx;
        }

        @Override
        public CacheStream<K> stream() {
            AdvancedCache advancedCache = this.cache.getAdvancedCache();
            DistributionManager dm = advancedCache.getDistributionManager();
            ComponentRegistry registry = advancedCache.getComponentRegistry();
            ClusterStreamManager realManager = registry.getComponent(ClusterStreamManager.class);
            LocalizedCacheTopology cacheTopology = dm.getCacheTopology();
            TxClusterStreamManager txManager = new TxClusterStreamManager(realManager, this.ctx, cacheTopology.getCurrentCH().getNumSegments(), cacheTopology::getSegment);
            return new TxDistributedCacheStream(this.cache.getCacheManager().getAddress(), false, dm, this.keySet::stream, txManager, !this.command.hasAnyFlag(FlagBitSets.SKIP_CACHE_LOAD), this.cache.getCacheConfiguration().clustering().stateTransfer().chunkSize(), registry.getComponent(Executor.class, "org.infinispan.executors.async"), registry, this.ctx, null, CacheEntry::getKey);
        }

        @Override
        public CacheStream<K> parallelStream() {
            AdvancedCache advancedCache = this.cache.getAdvancedCache();
            DistributionManager dm = advancedCache.getDistributionManager();
            ComponentRegistry registry = advancedCache.getComponentRegistry();
            ClusterStreamManager realManager = registry.getComponent(ClusterStreamManager.class);
            LocalizedCacheTopology cacheTopology = dm.getCacheTopology();
            TxClusterStreamManager txManager = new TxClusterStreamManager(realManager, this.ctx, cacheTopology.getCurrentCH().getNumSegments(), cacheTopology::getSegment);
            return new TxDistributedCacheStream(this.cache.getCacheManager().getAddress(), true, dm, this.keySet::parallelStream, txManager, !this.command.hasAnyFlag(FlagBitSets.SKIP_CACHE_LOAD), this.cache.getCacheConfiguration().clustering().stateTransfer().chunkSize(), registry.getComponent(Executor.class, "org.infinispan.executors.async"), registry, this.ctx, null, CacheEntry::getKey);
        }
    }

    protected static class BackingKeySet<K, V>
    extends AbstractCloseableIteratorCollection<K, K, V>
    implements CacheSet<K> {
        protected final CacheSet<K> keySet;
        protected final FlagAffectedCommand command;

        public BackingKeySet(Cache<K, V> cache, CacheSet<K> keySet, FlagAffectedCommand command) {
            super(cache);
            this.keySet = keySet;
            this.command = command;
        }

        @Override
        public CloseableIterator<K> iterator() {
            return new RemovableCloseableIterator(Closeables.iterator((BaseStream)this.stream()), arg_0 -> ((Cache)this.cache).remove(arg_0));
        }

        @Override
        public boolean contains(Object o) {
            return this.cache.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.cache.remove(o) != null;
        }

        @Override
        public CloseableSpliterator<K> spliterator() {
            return Closeables.spliterator(this.iterator(), (long)Long.MAX_VALUE, (int)4353);
        }

        @Override
        public CacheStream<K> stream() {
            AdvancedCache advancedCache = this.cache.getAdvancedCache();
            ComponentRegistry registry = advancedCache.getComponentRegistry();
            return new DistributedCacheStream(this.cache.getCacheManager().getAddress(), false, advancedCache.getDistributionManager(), this.keySet::stream, registry.getComponent(ClusterStreamManager.class), !this.command.hasAnyFlag(FlagBitSets.SKIP_CACHE_LOAD), this.cache.getCacheConfiguration().clustering().stateTransfer().chunkSize(), registry.getComponent(Executor.class, "org.infinispan.executors.async"), registry, null);
        }

        @Override
        public CacheStream<K> parallelStream() {
            AdvancedCache advancedCache = this.cache.getAdvancedCache();
            ComponentRegistry registry = advancedCache.getComponentRegistry();
            return new DistributedCacheStream(this.cache.getCacheManager().getAddress(), true, advancedCache.getDistributionManager(), this.keySet::parallelStream, registry.getComponent(ClusterStreamManager.class), !this.command.hasAnyFlag(FlagBitSets.SKIP_CACHE_LOAD), this.cache.getCacheConfiguration().clustering().stateTransfer().chunkSize(), registry.getComponent(Executor.class, "org.infinispan.executors.async"), registry, null);
        }
    }

    protected static class TxBackingEntrySet<K, V>
    extends BackingEntrySet<K, V> {
        private final LocalTxInvocationContext ctx;

        private TxBackingEntrySet(Cache cache, CacheSet<CacheEntry<K, V>> entrySet, FlagAffectedCommand command, LocalTxInvocationContext ctx) {
            super(cache, entrySet, command);
            this.ctx = ctx;
        }

        @Override
        public CacheStream<CacheEntry<K, V>> stream() {
            AdvancedCache advancedCache = this.cache.getAdvancedCache();
            DistributionManager dm = advancedCache.getDistributionManager();
            ComponentRegistry registry = advancedCache.getComponentRegistry();
            ClusterStreamManager realManager = registry.getComponent(ClusterStreamManager.class);
            LocalizedCacheTopology cacheTopology = dm.getCacheTopology();
            TxClusterStreamManager txManager = new TxClusterStreamManager(realManager, this.ctx, cacheTopology.getCurrentCH().getNumSegments(), cacheTopology::getSegment);
            TxDistributedCacheStream cacheStream = new TxDistributedCacheStream(this.cache.getCacheManager().getAddress(), false, dm, this.entrySet::stream, txManager, !this.command.hasAnyFlag(FlagBitSets.SKIP_CACHE_LOAD), this.cache.getCacheConfiguration().clustering().stateTransfer().chunkSize(), registry.getComponent(Executor.class, "org.infinispan.executors.async"), registry, this.ctx, StreamMarshalling.entryToKeyFunction(), Function.identity());
            return DistributionBulkInterceptor.applyTimeOut(cacheStream, this.cache);
        }

        @Override
        public CacheStream<CacheEntry<K, V>> parallelStream() {
            AdvancedCache advancedCache = this.cache.getAdvancedCache();
            DistributionManager dm = advancedCache.getDistributionManager();
            ComponentRegistry registry = advancedCache.getComponentRegistry();
            ClusterStreamManager realManager = registry.getComponent(ClusterStreamManager.class);
            LocalizedCacheTopology cacheTopology = dm.getCacheTopology();
            TxClusterStreamManager txManager = new TxClusterStreamManager(realManager, this.ctx, cacheTopology.getCurrentCH().getNumSegments(), cacheTopology::getSegment);
            TxDistributedCacheStream cacheStream = new TxDistributedCacheStream(this.cache.getCacheManager().getAddress(), true, dm, this.entrySet::parallelStream, txManager, !this.command.hasAnyFlag(FlagBitSets.SKIP_CACHE_LOAD), this.cache.getCacheConfiguration().clustering().stateTransfer().chunkSize(), registry.getComponent(Executor.class, "org.infinispan.executors.async"), registry, this.ctx, StreamMarshalling.entryToKeyFunction(), Function.identity());
            return DistributionBulkInterceptor.applyTimeOut(cacheStream, this.cache);
        }
    }

    protected static class BackingEntrySet<K, V>
    extends AbstractCloseableIteratorCollection<CacheEntry<K, V>, K, V>
    implements CacheSet<CacheEntry<K, V>> {
        protected final CacheSet<CacheEntry<K, V>> entrySet;
        protected final FlagAffectedCommand command;

        private BackingEntrySet(Cache cache, CacheSet<CacheEntry<K, V>> entrySet, FlagAffectedCommand command) {
            super(cache);
            this.entrySet = entrySet;
            this.command = command;
        }

        @Override
        public CloseableIterator<CacheEntry<K, V>> iterator() {
            return new IteratorMapper((Iterator)new RemovableCloseableIterator(Closeables.iterator((BaseStream)this.stream()), e -> this.cache.remove(e.getKey(), e.getValue())), e -> new EntryWrapper(this.cache, e));
        }

        @Override
        public CloseableSpliterator<CacheEntry<K, V>> spliterator() {
            return Closeables.spliterator((BaseStream)this.stream());
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry<K, V> entry = this.toEntry(o);
            if (entry != null) {
                Object value = this.cache.get(entry.getKey());
                return value != null && value.equals(entry.getValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            Map.Entry<K, V> entry = this.toEntry(o);
            if (entry != null) {
                return this.cache.remove(entry.getKey(), entry.getValue());
            }
            return false;
        }

        private Map.Entry<K, V> toEntry(Object obj) {
            if (obj instanceof Map.Entry) {
                return (Map.Entry)obj;
            }
            return null;
        }

        @Override
        public CacheStream<CacheEntry<K, V>> stream() {
            AdvancedCache advancedCache = this.cache.getAdvancedCache();
            ComponentRegistry registry = advancedCache.getComponentRegistry();
            DistributedCacheStream cacheStream = new DistributedCacheStream(this.cache.getCacheManager().getAddress(), false, advancedCache.getDistributionManager(), this.entrySet::stream, registry.getComponent(ClusterStreamManager.class), !this.command.hasAnyFlag(FlagBitSets.SKIP_CACHE_LOAD), this.cache.getCacheConfiguration().clustering().stateTransfer().chunkSize(), registry.getComponent(Executor.class, "org.infinispan.executors.async"), registry, StreamMarshalling.entryToKeyFunction());
            return DistributionBulkInterceptor.applyTimeOut(cacheStream, this.cache);
        }

        @Override
        public CacheStream<CacheEntry<K, V>> parallelStream() {
            AdvancedCache advancedCache = this.cache.getAdvancedCache();
            ComponentRegistry registry = advancedCache.getComponentRegistry();
            DistributedCacheStream cacheStream = new DistributedCacheStream(this.cache.getCacheManager().getAddress(), true, advancedCache.getDistributionManager(), this.entrySet::parallelStream, registry.getComponent(ClusterStreamManager.class), !this.command.hasAnyFlag(FlagBitSets.SKIP_CACHE_LOAD), this.cache.getCacheConfiguration().clustering().stateTransfer().chunkSize(), registry.getComponent(Executor.class, "org.infinispan.executors.async"), registry, StreamMarshalling.entryToKeyFunction());
            return DistributionBulkInterceptor.applyTimeOut(cacheStream, this.cache);
        }
    }
}

