/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import io.reactivex.Flowable;
import io.reactivex.schedulers.Schedulers;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.IntSet;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.filter.KeyFilter;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.metadata.impl.InternalMetadataImpl;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.SegmentedAdvancedLoadWriteStore;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

public class PersistenceUtil {
    private static Log log = LogFactory.getLog(PersistenceUtil.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final int SEGMENT_NOT_PROVIDED = -1;

    public static KeyFilter notNull(KeyFilter filter) {
        return filter == null ? KeyFilter.ACCEPT_ALL_FILTER : filter;
    }

    @Deprecated
    public static <K, V> int count(AdvancedCacheLoader<K, V> acl, KeyFilter<? super K> filter) {
        return PersistenceUtil.count(acl, filter);
    }

    public static <K, V> int count(AdvancedCacheLoader<K, V> acl, Predicate<? super K> filter) {
        Long result = (Long)Flowable.fromPublisher(acl.publishKeys(filter)).count().blockingGet();
        if (result > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return result.intValue();
    }

    public static int count(SegmentedAdvancedLoadWriteStore<?, ?> salws, IntSet segments) {
        Long result = (Long)Flowable.fromPublisher(salws.publishKeys(segments, null)).count().blockingGet();
        if (result > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return result.intValue();
    }

    @Deprecated
    public static <K, V> Set<K> toKeySet(AdvancedCacheLoader<K, V> acl, KeyFilter<? super K> filter) {
        return PersistenceUtil.toKeySet(acl, filter);
    }

    public static <K, V> Set<K> toKeySet(AdvancedCacheLoader<K, V> acl, Predicate<? super K> filter) {
        if (acl == null) {
            return Collections.emptySet();
        }
        return (Set)Flowable.fromPublisher(acl.publishKeys(filter)).collectInto(new HashSet(), Set::add).blockingGet();
    }

    @Deprecated
    public static <K, V> Set<InternalCacheEntry> toEntrySet(AdvancedCacheLoader<K, V> acl, KeyFilter<? super K> filter, InternalEntryFactory ief) {
        Set<InternalCacheEntry> entrySet = PersistenceUtil.toEntrySet(acl, filter, ief);
        return entrySet;
    }

    public static <K, V> Set<InternalCacheEntry<K, V>> toEntrySet(AdvancedCacheLoader<K, V> acl, Predicate<? super K> filter, InternalEntryFactory ief) {
        if (acl == null) {
            return Collections.emptySet();
        }
        return (Set)Flowable.fromPublisher(acl.publishEntries(filter, true, true)).map(me -> ief.create(me.getKey(), me.getValue(), me.getMetadata())).collectInto(new HashSet(), Set::add).blockingGet();
    }

    public static long getExpiryTime(InternalMetadata internalMetadata) {
        return internalMetadata == null ? -1L : internalMetadata.expiryTime();
    }

    public static InternalMetadata internalMetadata(InternalCacheEntry ice) {
        return ice.getMetadata() == null ? null : new InternalMetadataImpl(ice);
    }

    public static InternalMetadata internalMetadata(InternalCacheValue icv) {
        return icv.getMetadata() == null ? null : new InternalMetadataImpl(icv.getMetadata(), icv.getCreated(), icv.getLastUsed());
    }

    @Deprecated
    public static <K, V> InternalCacheEntry<K, V> loadAndStoreInDataContainer(DataContainer<K, V> dataContainer, PersistenceManager persistenceManager, K key, InvocationContext ctx, TimeService timeService, AtomicReference<Boolean> isLoaded) {
        return org.infinispan.persistence.internal.PersistenceUtil.loadAndStoreInDataContainer(dataContainer, persistenceManager, key, ctx, timeService, isLoaded);
    }

    @Deprecated
    public static <K, V> InternalCacheEntry<K, V> loadAndStoreInDataContainer(DataContainer<K, V> dataContainer, int segment, PersistenceManager persistenceManager, K key, InvocationContext ctx, TimeService timeService, AtomicReference<Boolean> isLoaded) {
        return org.infinispan.persistence.internal.PersistenceUtil.loadAndStoreInDataContainer(dataContainer, segment, persistenceManager, key, ctx, timeService, isLoaded);
    }

    @Deprecated
    public static <K, V> InternalCacheEntry<K, V> loadAndComputeInDataContainer(DataContainer<K, V> dataContainer, int segment, PersistenceManager persistenceManager, K key, InvocationContext ctx, TimeService timeService, DataContainer.ComputeAction<K, V> action) {
        return org.infinispan.persistence.internal.PersistenceUtil.loadAndComputeInDataContainer(dataContainer, segment, persistenceManager, key, ctx, timeService, action);
    }

    @Deprecated
    public static <K, V> MarshalledEntry<K, V> loadAndCheckExpiration(PersistenceManager persistenceManager, Object key, InvocationContext context, TimeService timeService) {
        return org.infinispan.persistence.internal.PersistenceUtil.loadAndCheckExpiration(persistenceManager, key, -1, context);
    }

    public static <K, V> InternalCacheEntry<K, V> convert(MarshalledEntry<K, V> loaded, InternalEntryFactory factory) {
        return org.infinispan.persistence.internal.PersistenceUtil.convert(loaded, factory);
    }

    public static <R> Publisher<R> parallelizePublisher(IntSet segments, Executor executor, IntFunction<Publisher<R>> publisherFunction) {
        return org.infinispan.persistence.internal.PersistenceUtil.parallelizePublisher(segments, Schedulers.from((Executor)executor), publisherFunction);
    }
}

