/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.StateChunk;
import org.infinispan.statetransfer.StateResponseCommand;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class OutboundTransferTask
implements Runnable {
    private static final Log log = LogFactory.getLog(OutboundTransferTask.class);
    private final boolean trace = log.isTraceEnabled();
    private final Consumer<OutboundTransferTask> onCompletion;
    private final Consumer<List<StateChunk>> onChunkReplicated;
    private final BiFunction<InternalCacheEntry, InternalEntryFactory, InternalCacheEntry> mapEntryFromDataContainer;
    private final BiFunction<MarshalledEntry, InternalEntryFactory, InternalCacheEntry> mapEntryFromStore;
    private final int topologyId;
    private final Address destination;
    private final IntSet segments;
    private final int chunkSize;
    private final KeyPartitioner keyPartitioner;
    private final InternalDataContainer<Object, Object> dataContainer;
    private final PersistenceManager persistenceManager;
    private final RpcManager rpcManager;
    private final CommandsFactory commandsFactory;
    private final long timeout;
    private final String cacheName;
    private final boolean applyState;
    private final boolean pushTransfer;
    private final Map<Integer, List<InternalCacheEntry>> entriesBySegment = CollectionFactory.makeConcurrentMap();
    private int accumulatedEntries;
    private FutureTask<Void> runnableFuture;
    private final RpcOptions rpcOptions;
    private InternalEntryFactory entryFactory;

    public OutboundTransferTask(Address destination, IntSet segments, int segmentCount, int chunkSize, int topologyId, KeyPartitioner keyPartitioner, Consumer<OutboundTransferTask> onCompletion, Consumer<List<StateChunk>> onChunkReplicated, BiFunction<InternalCacheEntry, InternalEntryFactory, InternalCacheEntry> mapEntryFromDataContainer, BiFunction<MarshalledEntry, InternalEntryFactory, InternalCacheEntry> mapEntryFromStore, InternalDataContainer dataContainer, PersistenceManager persistenceManager, RpcManager rpcManager, CommandsFactory commandsFactory, InternalEntryFactory ef, long timeout, String cacheName, boolean applyState, boolean pushTransfer) {
        if (segments == null || segments.isEmpty()) {
            throw new IllegalArgumentException("Segments must not be null or empty");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Destination address cannot be null");
        }
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize must be greater than 0");
        }
        this.onCompletion = onCompletion;
        this.onChunkReplicated = onChunkReplicated;
        this.mapEntryFromDataContainer = mapEntryFromDataContainer;
        this.mapEntryFromStore = mapEntryFromStore;
        this.destination = destination;
        this.segments = IntSets.concurrentCopyFrom((IntSet)segments, (int)segmentCount);
        this.chunkSize = chunkSize;
        this.topologyId = topologyId;
        this.keyPartitioner = keyPartitioner;
        this.dataContainer = dataContainer;
        this.persistenceManager = persistenceManager;
        this.entryFactory = ef;
        this.rpcManager = rpcManager;
        this.commandsFactory = commandsFactory;
        this.timeout = timeout;
        this.cacheName = cacheName;
        this.applyState = applyState;
        this.pushTransfer = pushTransfer;
        this.rpcOptions = rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS).timeout(timeout, TimeUnit.MILLISECONDS).build();
    }

    public void execute(ExecutorService executorService) {
        if (this.runnableFuture != null) {
            throw new IllegalStateException("This task was already submitted");
        }
        this.runnableFuture = new FutureTask<Void>((Runnable)this, null){

            @Override
            protected void done() {
                OutboundTransferTask.this.onCompletion.accept(OutboundTransferTask.this);
            }
        };
        executorService.submit(this.runnableFuture);
    }

    public Address getDestination() {
        return this.destination;
    }

    public IntSet getSegments() {
        return this.segments;
    }

    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void run() {
        try {
            for (InternalCacheEntry ice : this.dataContainer) {
                InternalCacheEntry entry;
                Object key = ice.getKey();
                int segmentId = this.keyPartitioner.getSegment(key);
                if (!this.segments.contains(segmentId) || ice.isL1Entry() || (entry = this.mapEntryFromDataContainer.apply(ice, this.entryFactory)) == null) continue;
                this.sendEntry(entry, segmentId);
            }
            AdvancedCacheLoader stProvider = this.persistenceManager.getStateTransferProvider();
            if (stProvider != null) {
                try {
                    AdvancedCacheLoader.CacheLoaderTask task = (me, taskContext) -> {
                        int segmentId = this.keyPartitioner.getSegment(me.getKey());
                        if (this.segments.contains(segmentId)) {
                            try {
                                InternalCacheEntry entry = this.mapEntryFromStore.apply(me, this.entryFactory);
                                if (entry != null) {
                                    this.sendEntry(entry, segmentId);
                                }
                            }
                            catch (CacheException e) {
                                log.failedLoadingValueFromCacheStore(me.getKey(), (Exception)((Object)e));
                            }
                        }
                    };
                    Flowable.fromPublisher(stProvider.publishEntries(k -> !this.dataContainer.containsKey(k), true, true)).blockingForEach(me -> task.processEntry(me, (AdvancedCacheLoader.TaskContext)null));
                }
                catch (CacheException e) {
                    log.failedLoadingKeysFromCacheStore((Exception)((Object)e));
                }
            }
            this.sendEntries(true);
        }
        catch (Throwable t) {
            if (this.isCancelled()) {
                if (this.trace) {
                    log.tracef("Ignoring error in already cancelled transfer to node %s, segments %s", this.destination, this.segments);
                }
            }
            log.failedOutBoundTransferExecution(t);
        }
        if (this.trace) {
            log.tracef("Completed outbound transfer to node %s, segments %s", this.destination, this.segments);
        }
    }

    private void sendEntry(InternalCacheEntry ice, int segmentId) {
        if (this.accumulatedEntries >= this.chunkSize) {
            this.sendEntries(false);
            this.accumulatedEntries = 0;
        }
        List entries = this.entriesBySegment.computeIfAbsent(segmentId, k -> new ArrayList());
        entries.add(ice);
        ++this.accumulatedEntries;
    }

    private void sendEntries(boolean isLast) {
        List<InternalCacheEntry> entries;
        ArrayList<StateChunk> chunks = new ArrayList<StateChunk>();
        for (Map.Entry<Integer, List<InternalCacheEntry>> e : this.entriesBySegment.entrySet()) {
            entries = e.getValue();
            if (entries.isEmpty() && !isLast) continue;
            chunks.add(new StateChunk(e.getKey(), new ArrayList<InternalCacheEntry>(entries), isLast));
            entries.clear();
        }
        if (isLast) {
            PrimitiveIterator.OfInt iter = this.segments.iterator();
            while (iter.hasNext()) {
                int segmentId = iter.nextInt();
                entries = this.entriesBySegment.get(segmentId);
                if (entries != null) continue;
                chunks.add(new StateChunk(segmentId, Collections.emptyList(), true));
            }
        }
        if (!chunks.isEmpty()) {
            if (this.trace) {
                if (isLast) {
                    log.tracef("Sending last chunk to node %s containing %d cache entries from segments %s", this.destination, this.accumulatedEntries, this.segments);
                } else {
                    log.tracef("Sending to node %s %d cache entries from segments %s", this.destination, this.accumulatedEntries, this.entriesBySegment.keySet());
                }
            }
            StateResponseCommand cmd = this.commandsFactory.buildStateResponseCommand(this.rpcManager.getAddress(), this.topologyId, chunks, this.applyState, this.pushTransfer);
            try {
                this.rpcManager.invokeRemotely(Collections.singleton(this.destination), cmd, this.rpcOptions);
                this.onChunkReplicated.accept(chunks);
            }
            catch (SuspectException e) {
                log.debugf("Node %s left cache %s while we were sending state to it, cancelling transfer.", this.destination, this.cacheName);
                this.cancel();
            }
            catch (Exception e) {
                if (this.isCancelled()) {
                    log.debugf("Stopping cancelled transfer to node %s, segments %s", this.destination, this.segments);
                }
                log.errorf(e, "Failed to send entries to node %s: %s", this.destination, e.getMessage());
            }
        }
    }

    public void cancelSegments(IntSet cancelledSegments) {
        if (this.segments.removeAll(cancelledSegments)) {
            if (this.trace) {
                log.tracef("Cancelling outbound transfer to node %s, segments %s (remaining segments %s)", this.destination, cancelledSegments, this.segments);
            }
            this.entriesBySegment.keySet().removeAll((Collection<?>)cancelledSegments);
            if (this.segments.isEmpty()) {
                this.cancel();
            }
        }
    }

    public void cancel() {
        if (this.runnableFuture != null && !this.runnableFuture.isCancelled()) {
            log.debugf("Cancelling outbound transfer to node %s, segments %s", this.destination, this.segments);
            this.runnableFuture.cancel(true);
        }
    }

    public boolean isCancelled() {
        return this.runnableFuture != null && this.runnableFuture.isCancelled();
    }

    public String toString() {
        return "OutboundTransferTask{topologyId=" + this.topologyId + ", destination=" + this.destination + ", segments=" + this.segments + ", chunkSize=" + this.chunkSize + ", timeout=" + this.timeout + ", cacheName='" + this.cacheName + '\'' + '}';
    }

    public static InternalCacheEntry defaultMapEntryFromDataContainer(InternalCacheEntry ice, InternalEntryFactory entryFactory) {
        return ice;
    }

    public static InternalCacheEntry defaultMapEntryFromStore(MarshalledEntry me, InternalEntryFactory entryFactory) {
        return entryFactory.create(me.getKey(), me.getValue(), me.getMetadata());
    }
}

