/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages;

import io.airlift.airline.Option;
import java.nio.ByteBuffer;
import javax.jms.Destination;
import javax.jms.Session;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientRequestor;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.messages.ConnectionAbstract;
import org.apache.activemq.artemis.cli.factory.serialize.MessageSerializer;
import org.apache.activemq.artemis.cli.factory.serialize.XMLMessageSerializer;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;

public class DestAbstract
extends ConnectionAbstract {
    public static final String DEFAULT_MESSAGE_SERIALIZER = "org.apache.activemq.artemis.cli.factory.serialize.XMLMessageSerializer";
    private static final String FQQN_PREFIX = "fqqn://";
    private static final String FQQN_SEPERATOR = "::";
    @Option(name={"--destination"}, description="Destination to be used. It can be prefixed with queue:// or topic:// or fqqn:// (Default: queue://TEST)")
    String destination = "queue://TEST";
    @Option(name={"--message-count"}, description="Number of messages to act on (Default: 1000)")
    int messageCount = 1000;
    @Option(name={"--sleep"}, description="Time wait between each message")
    int sleep = 0;
    @Option(name={"--txt-size"}, description="TX Batch Size")
    int txBatchSize;
    @Option(name={"--threads"}, description="Number of Threads to be used (Default: 1)")
    int threads = 1;
    @Option(name={"--serializer"}, description="Override the default serializer with a custom implementation")
    String serializer;

    protected boolean isFQQN() throws ActiveMQException {
        boolean fqqn = this.destination.contains(FQQN_SEPERATOR);
        if (fqqn) {
            if (!this.destination.startsWith(FQQN_PREFIX)) {
                throw new ActiveMQException("FQQN destinations must start with the fqqn:// prefix");
            }
            if (this.protocol.equalsIgnoreCase("AMQP")) {
                throw new ActiveMQException("Sending to FQQN destinations is not support via AMQP protocol");
            }
            return true;
        }
        return false;
    }

    protected Destination lookupDestination(Session session) throws Exception {
        if (this.protocol.equals("AMQP")) {
            return session.createQueue(this.destination);
        }
        return ActiveMQDestination.createDestination((String)this.destination, (ActiveMQDestination.TYPE)ActiveMQDestination.TYPE.QUEUE);
    }

    protected MessageSerializer getMessageSerializer() {
        if (this.serializer == null) {
            return new XMLMessageSerializer();
        }
        try {
            return (MessageSerializer)Class.forName(this.serializer).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            System.out.println("Error: unable to instantiate serializer class: " + this.serializer);
            System.out.println("Defaulting to: org.apache.activemq.artemis.cli.factory.serialize.XMLMessageSerializer");
            return new XMLMessageSerializer();
        }
    }

    private ClientSession getManagementSession() throws Exception {
        ServerLocator serverLocator = ActiveMQClient.createServerLocator((String)this.brokerURL);
        ClientSessionFactory sf = serverLocator.createSessionFactory();
        ClientSession managementSession = this.user != null || this.password != null ? sf.createSession(this.user, this.password, false, true, true, false, 0) : sf.createSession(false, true, true);
        return managementSession;
    }

    public byte[] getQueueIdFromName(String queueName) throws Exception {
        try {
            ClientMessage message = this.getQueueAttribute(queueName, "ID");
            Number idObject = (Number)ManagementHelper.getResult((ICoreMessage)message);
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            byteBuffer.putLong(idObject.longValue());
            return byteBuffer.array();
        }
        catch (Exception e) {
            throw new ActiveMQException("Error occured when looking up FQQN.  Please ensure the FQQN exists.", (Throwable)e, ActiveMQExceptionType.ILLEGAL_STATE);
        }
    }

    /*
     * Loose catch block
     */
    protected ClientMessage getQueueAttribute(String queueName, String attribute) throws Exception {
        ClientSession managementSession = this.getManagementSession();
        managementSession.start();
        try {
            try (ClientRequestor requestor = new ClientRequestor(managementSession, "activemq.management");){
                ClientMessage reply;
                ClientMessage managementMessage = managementSession.createMessage(false);
                ManagementHelper.putAttribute((ICoreMessage)managementMessage, (String)("queue." + queueName), (String)attribute);
                managementSession.start();
                ClientMessage clientMessage = reply = requestor.request(managementMessage);
                return clientMessage;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            managementSession.stop();
        }
    }

    protected String getQueueFromFQQN(String fqqn) {
        return fqqn.substring(fqqn.indexOf(FQQN_SEPERATOR) + FQQN_SEPERATOR.length());
    }

    protected String getAddressFromFQQN(String fqqn) {
        return fqqn.substring(fqqn.indexOf(FQQN_PREFIX) + FQQN_PREFIX.length(), fqqn.indexOf(FQQN_SEPERATOR));
    }

    protected String getFQQNFromDestination(String destination) {
        return destination.substring(destination.indexOf(FQQN_PREFIX) + FQQN_PREFIX.length());
    }
}

