/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton.transaction;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.RefsOperation;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.protocol.amqp.proton.transaction.ProtonTransactionRefsOperation;
import org.apache.qpid.proton.engine.Delivery;

public class ProtonTransactionImpl
extends TransactionImpl {
    private final Map<MessageReference, Pair<Delivery, ProtonServerSenderContext>> deliveries = new HashMap<MessageReference, Pair<Delivery, ProtonServerSenderContext>>();
    private boolean discharged;

    public ProtonTransactionImpl(Xid xid, StorageManager storageManager, int timeoutSeconds) {
        super(xid, storageManager, timeoutSeconds);
    }

    public RefsOperation createRefsOperation(Queue queue) {
        return new ProtonTransactionRefsOperation(queue, this.storageManager);
    }

    public void rollback() throws Exception {
        super.rollback();
    }

    public void addDelivery(Delivery delivery, ProtonServerSenderContext context) {
        this.deliveries.put((MessageReference)delivery.getContext(), (Pair<Delivery, ProtonServerSenderContext>)new Pair((Object)delivery, (Object)context));
    }

    public Map<MessageReference, Pair<Delivery, ProtonServerSenderContext>> getDeliveries() {
        return this.deliveries;
    }

    public void commit() throws Exception {
        super.commit();
        for (Pair<Delivery, ProtonServerSenderContext> p : this.deliveries.values()) {
            if (((Delivery)p.getA()).isSettled()) continue;
            ((ProtonServerSenderContext)p.getB()).settle((Delivery)p.getA());
        }
    }

    public boolean isDischarged() {
        return this.discharged;
    }

    public void discharge() {
        this.discharged = true;
    }
}

