/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.model;

import java.io.File;
import java.util.List;
import java.util.UUID;
import org.aesh.command.CommandException;
import org.aesh.readline.Prompt;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.impl.aesh.cmd.security.SecurityCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.model.DefaultResourceNames;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ElytronUtil;
import org.jboss.as.cli.impl.aesh.cmd.security.model.KeyStore;
import org.jboss.as.cli.impl.aesh.cmd.security.model.SSLSecurityBuilder;
import org.jboss.as.cli.impl.aesh.cmd.security.ssl.PromptFileCompleter;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;

public class InteractiveSecurityBuilder
extends SSLSecurityBuilder {
    private String dn;
    private String password;
    private String alias;
    private CLICommandInvocation commandInvocation;
    private String validity;
    private String keyStoreName;
    private String clientCertificate;
    private String trustStoreFileName;
    private String trustStorePassword;
    private boolean validateCertificate;
    public static final String PLACE_HOLDER = "<need user input>";
    private String keyStoreFile;
    private final String defaultKeyStoreFile;
    private final String defaultTrustStoreFile;
    private static final String KEY_ALG = "RSA";
    private static final int KEY_SIZE = 1024;

    public InteractiveSecurityBuilder(String defaultKeyStoreFile, String defaultTrustStoreFile) throws CommandException {
        this.defaultKeyStoreFile = defaultKeyStoreFile;
        this.defaultTrustStoreFile = defaultTrustStoreFile;
    }

    public InteractiveSecurityBuilder setCommandInvocation(CLICommandInvocation commandInvocation) {
        this.commandInvocation = commandInvocation;
        return this;
    }

    @Override
    public void buildRequest(CommandContext ctx, boolean buildRequest) throws Exception {
        if (buildRequest) {
            this.keyStoreFile = PLACE_HOLDER;
            this.dn = PLACE_HOLDER;
            this.password = PLACE_HOLDER;
            this.alias = PLACE_HOLDER;
            this.validity = PLACE_HOLDER;
            this.clientCertificate = File.separator + PLACE_HOLDER;
            this.trustStorePassword = PLACE_HOLDER;
            this.trustStoreFileName = PLACE_HOLDER;
        } else {
            ctx.printLine("Please provide required pieces of information to enable SSL:");
        }
        String relativeTo = "jboss.server.config.dir";
        boolean ok = false;
        Long v = null;
        while (this.keyStoreFile == null) {
            List<String> ksNames;
            this.keyStoreFile = this.commandInvocation.inputLine(new Prompt("Key-store file name (default " + this.defaultKeyStoreFile + "): "));
            if (this.keyStoreFile != null && this.keyStoreFile.length() == 0) {
                this.keyStoreFile = this.defaultKeyStoreFile;
            }
            if ((ksNames = ElytronUtil.findMatchingKeyStores(ctx, new File(this.keyStoreFile), relativeTo)).isEmpty()) continue;
            throw new CommandException("Error, the file " + this.keyStoreFile + " is already referenced from " + ksNames + " resources. Use " + SecurityCommand.formatOption("key-store-name") + " option or choose another file name.");
        }
        int i = this.keyStoreFile.indexOf(".");
        String certName = i > 0 ? this.keyStoreFile.substring(0, i) : this.keyStoreFile;
        String csrName = certName + ".csr";
        certName = certName + ".pem";
        while (this.password == null) {
            this.password = this.commandInvocation.inputLine(new Prompt("Password (blank generated): "));
            if (this.password == null || this.password.length() != 0) continue;
            this.password = SSLSecurityBuilder.generateRandomPassword();
        }
        if (this.dn == null) {
            this.dn = new DNWizard().buildDN();
        }
        while (this.validity == null) {
            this.validity = this.commandInvocation.inputLine(new Prompt("Validity (in days, blank default): "));
            if (this.validity == null) continue;
            if (this.validity.length() == 0) {
                v = null;
                continue;
            }
            try {
                v = Long.parseLong(this.validity);
            }
            catch (NumberFormatException e) {
                ctx.printLine("Invalid number " + this.validity);
                this.validity = null;
            }
        }
        while (this.alias == null) {
            this.alias = this.commandInvocation.inputLine(new Prompt("Alias (blank generated): "));
            if (this.alias == null || this.alias.length() != 0) continue;
            this.alias = "alias-" + UUID.randomUUID().toString();
        }
        boolean mutual = false;
        if (!buildRequest) {
            String twoWay = null;
            while (twoWay == null) {
                twoWay = this.commandInvocation.inputLine(new Prompt("Enable SSL Mutual Authentication y/n (blank n):"));
                if (twoWay != null && twoWay.equals("y")) {
                    mutual = true;
                    break;
                }
                if (twoWay != null && twoWay.equals("n")) {
                    mutual = false;
                    break;
                }
                if (twoWay != null && twoWay.length() == 0) {
                    mutual = false;
                    break;
                }
                twoWay = null;
            }
            if (mutual) {
                PromptFileCompleter completer = new PromptFileCompleter(this.commandInvocation.getConfiguration().getAeshContext());
                while (this.clientCertificate == null || this.clientCertificate.length() == 0) {
                    this.clientCertificate = this.commandInvocation.inputLine(new Prompt("Client certificate (path to pem file): "), completer);
                    if (this.clientCertificate == null || this.clientCertificate.length() <= 0 || new File(this.clientCertificate).exists()) continue;
                    this.clientCertificate = null;
                    ctx.printLine("The specified file doesn't exist");
                }
                String val = null;
                while (val == null) {
                    val = this.commandInvocation.inputLine(new Prompt("Validate certificate y/n (blank y): "));
                    if (val != null && val.equals("y")) {
                        this.validateCertificate = true;
                        break;
                    }
                    if (val != null && val.equals("n")) {
                        this.validateCertificate = false;
                        break;
                    }
                    if (val != null && val.length() == 0) {
                        this.validateCertificate = true;
                        break;
                    }
                    val = null;
                }
                while (this.trustStoreFileName == null) {
                    List<String> ksNames;
                    this.trustStoreFileName = this.commandInvocation.inputLine(new Prompt("Trust-store file name (" + this.defaultTrustStoreFile + "): "));
                    if (this.trustStoreFileName != null && this.trustStoreFileName.length() == 0) {
                        this.trustStoreFileName = this.defaultTrustStoreFile;
                    }
                    if ((ksNames = ElytronUtil.findMatchingKeyStores(ctx, new File(this.trustStoreFileName), "jboss.server.config.dir")).isEmpty()) continue;
                    throw new CommandException("Error, the file " + this.trustStoreFileName + " is already referenced from " + ksNames + " resources. Use " + SecurityCommand.formatOption("trust-store-name") + " option or choose another file name.");
                }
                while (this.trustStorePassword == null) {
                    this.trustStorePassword = this.commandInvocation.inputLine(new Prompt("Password (blank generated): "));
                    if (this.trustStorePassword == null || this.trustStorePassword.length() != 0) continue;
                    this.trustStorePassword = SSLSecurityBuilder.generateRandomPassword();
                }
            }
        }
        if (!buildRequest) {
            String reply = null;
            while (reply == null) {
                ctx.printLine("\nSSL options:");
                ctx.printLine("key store file: " + this.keyStoreFile + "\ndistinguished name: " + this.dn + "\npassword: " + this.password + "\nvalidity: " + (this.validity.length() == 0 ? "default" : this.validity) + "\nalias: " + this.alias);
                if (mutual) {
                    ctx.printLine("client certificate: " + this.clientCertificate);
                    ctx.printLine("trust store file: " + this.trustStoreFileName);
                    ctx.printLine("trust store password: " + this.trustStorePassword);
                }
                ctx.printLine("Server keystore file " + this.keyStoreFile + ", certificate file " + certName + " and " + csrName + " file will be generated in server configuration directory.");
                if (mutual) {
                    ctx.printLine("Server truststore file " + this.trustStoreFileName + " will be generated in server configuration directory.");
                }
                if ((reply = this.commandInvocation.inputLine(new Prompt("Do you confirm y/n :"))) != null && reply.equals("y")) {
                    ok = true;
                    break;
                }
                if (reply == null || reply.equals("n")) continue;
                reply = null;
            }
            if (!ok) {
                throw new CommandException("Ignoring, command not executed.");
            }
        }
        String type = DefaultResourceNames.buildDefaultKeyStoreType(null, ctx);
        String id = UUID.randomUUID().toString();
        this.setKeyManagerName("key-manager-" + id);
        this.setSSLContextName("ssl-context-" + id);
        this.keyStoreName = "key-store-" + id;
        ModelNode request = ElytronUtil.addKeyStore(ctx, this.keyStoreName, new File(this.keyStoreFile), relativeTo, this.password, type, false, null);
        try {
            if (buildRequest) {
                this.addStep(request, this.NO_DESC);
            } else {
                SecurityCommand.execute(ctx, request, SecurityCommand.DEFAULT_FAILURE_CONSUMER);
            }
            ModelNode request2 = ElytronUtil.generateKeyPair(ctx, this.keyStoreName, this.dn, this.alias, v, KEY_ALG, 1024);
            this.addStep(request2, new SSLSecurityBuilder.FailureDescProvider(){

                @Override
                public String stepFailedDescription() {
                    return "Generating key-pair from " + InteractiveSecurityBuilder.this.keyStoreName;
                }
            });
            this.needKeyStoreStore(this.keyStoreName);
            final String cName = certName;
            ModelNode request4 = ElytronUtil.exportCertificate(ctx, this.keyStoreName, new File(certName), relativeTo, this.alias, true);
            this.addFinalstep(request4, new SSLSecurityBuilder.FailureDescProvider(){

                @Override
                public String stepFailedDescription() {
                    return "Exporting certificate " + cName + " from key-store " + InteractiveSecurityBuilder.this.keyStoreName;
                }
            });
            ModelNode request5 = ElytronUtil.generateSigningRequest(ctx, this.keyStoreName, new File(csrName), relativeTo, this.alias);
            this.addFinalstep(request5, new SSLSecurityBuilder.FailureDescProvider(){

                @Override
                public String stepFailedDescription() {
                    return "Generating signing request  from key-store " + InteractiveSecurityBuilder.this.keyStoreName;
                }
            });
            if (this.clientCertificate != null) {
                this.setTrustedCertificatePath(new File(this.clientCertificate));
                this.setTrustStoreFileName(this.trustStoreFileName);
                this.setTrustStoreFilePassword(this.trustStorePassword);
                this.setValidateCertificate(this.validateCertificate);
            }
        }
        catch (Exception ex) {
            try {
                this.failureOccured(ctx, null);
            }
            catch (Exception ex2) {
                ex.addSuppressed(ex2);
            }
            throw ex;
        }
        super.buildRequest(ctx, buildRequest);
    }

    @Override
    protected KeyStore buildKeyStore(CommandContext ctx, boolean buildRequest) throws Exception {
        return new KeyStore(this.keyStoreName, this.password, this.alias, false);
    }

    @Override
    public void doFailureOccured(CommandContext ctx) throws Exception {
        if (this.keyStoreName != null) {
            ModelNode req = ElytronUtil.removeKeyStore(ctx, this.keyStoreName);
            SecurityCommand.execute(ctx, req, SecurityCommand.DEFAULT_FAILURE_CONSUMER);
        }
    }

    private class DNWizard {
        private static final String UNKNOWN = "Unknown";
        private String name = "Unknown";
        private String orgUnit = "Unknown";
        private String org = "Unknown";
        private String city = "Unknown";
        private String state = "Unknown";
        private String countryCode = "Unknown";

        private DNWizard() {
        }

        private String buildDN() throws InterruptedException {
            String dnString = null;
            boolean correct = false;
            while (!correct) {
                this.name = this.prompt("What is your first and last name?", this.name);
                this.orgUnit = this.prompt("What is the name of your organizational unit?", this.orgUnit);
                this.org = this.prompt("What is the name of your organization?", this.org);
                this.city = this.prompt("What is the name of your City or Locality?", this.city);
                this.state = this.prompt("What is the name of your State or Province?", this.state);
                this.countryCode = this.prompt("What is the two-letter country code for this unit?", this.countryCode);
                dnString = this.buildDNString();
                String res = InteractiveSecurityBuilder.this.commandInvocation.inputLine(new Prompt("Is " + dnString + " correct y/n [y]?"));
                if (res != null && res.equals("y")) {
                    correct = true;
                    break;
                }
                if (res != null && res.equals("n")) {
                    correct = false;
                    continue;
                }
                if (res != null && res.length() == 0) {
                    correct = true;
                    break;
                }
                correct = false;
            }
            return dnString;
        }

        private String buildDNString() {
            return "CN=" + this.name + ", OU=" + this.orgUnit + ", O=" + this.org + ", L=" + this.city + ", ST=" + this.state + ", C=" + this.countryCode;
        }

        private String prompt(String prompt, String value) throws InterruptedException {
            String res = InteractiveSecurityBuilder.this.commandInvocation.inputLine(new Prompt(prompt + " [" + value + "]: "));
            if (res == null || res.length() == 0) {
                res = value;
            }
            return res;
        }
    }
}

