/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.qpid.proton.codec.AMQPType;
import org.apache.qpid.proton.codec.AbstractPrimitiveType;
import org.apache.qpid.proton.codec.ArrayType;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FixedSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.LargeFloatingSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.PrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.SmallFloatingSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeConstructor;
import org.apache.qpid.proton.codec.TypeEncoding;

public class ListType
extends AbstractPrimitiveType<List> {
    private final ListEncoding _listEncoding;
    private final ListEncoding _shortListEncoding;
    private final ListEncoding _zeroListEncoding;
    private EncoderImpl _encoder;

    ListType(EncoderImpl encoder, DecoderImpl decoder) {
        this._encoder = encoder;
        this._listEncoding = new AllListEncoding(encoder, decoder);
        this._shortListEncoding = new ShortListEncoding(encoder, decoder);
        this._zeroListEncoding = new ZeroListEncoding(encoder, decoder);
        encoder.register(List.class, this);
        decoder.register(this);
    }

    @Override
    public Class<List> getTypeClass() {
        return List.class;
    }

    public ListEncoding getEncoding(List val) {
        int calculatedSize = ListType.calculateSize(val, this._encoder);
        ListEncoding encoding = val.isEmpty() ? this._zeroListEncoding : (val.size() > 255 || calculatedSize >= 254 ? this._listEncoding : this._shortListEncoding);
        encoding.setValue(val, calculatedSize);
        return encoding;
    }

    private static int calculateSize(List val, EncoderImpl encoder) {
        int len = 0;
        int count = val.size();
        for (int i = 0; i < count; ++i) {
            Object element = val.get(i);
            AMQPType type = encoder.getType(element);
            if (type == null) {
                throw new IllegalArgumentException("No encoding defined for type: " + element.getClass());
            }
            TypeEncoding elementEncoding = type.getEncoding(element);
            len += elementEncoding.getConstructorSize() + elementEncoding.getValueSize(element);
        }
        return len;
    }

    public ListEncoding getCanonicalEncoding() {
        return this._listEncoding;
    }

    @Override
    public Collection<ListEncoding> getAllEncodings() {
        return Arrays.asList(this._zeroListEncoding, this._shortListEncoding, this._listEncoding);
    }

    private class ZeroListEncoding
    extends FixedSizePrimitiveTypeEncoding<List>
    implements ListEncoding {
        public ZeroListEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        public byte getEncodingCode() {
            return 69;
        }

        @Override
        protected int getFixedSize() {
            return 0;
        }

        public ListType getType() {
            return ListType.this;
        }

        @Override
        public void setValue(List value, int length) {
        }

        @Override
        public void writeValue(List val) {
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<List> encoder) {
            return encoder == this;
        }

        @Override
        public List readValue() {
            return Collections.EMPTY_LIST;
        }
    }

    private class ShortListEncoding
    extends SmallFloatingSizePrimitiveTypeEncoding<List>
    implements ListEncoding {
        private List _value;
        private int _length;

        public ShortListEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected void writeEncodedValue(List val) {
            this.getEncoder().writeRaw((byte)val.size());
            int count = val.size();
            for (int i = 0; i < count; ++i) {
                Object element = val.get(i);
                TypeEncoding elementEncoding = this.getEncoder().getType(element).getEncoding(element);
                elementEncoding.writeConstructor();
                elementEncoding.writeValue(element);
            }
        }

        @Override
        protected int getEncodedValueSize(List val) {
            return 1 + (val == this._value ? this._length : ListType.calculateSize(val, this.getEncoder()));
        }

        @Override
        public byte getEncodingCode() {
            return -64;
        }

        public ListType getType() {
            return ListType.this;
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<List> encoder) {
            return encoder == this;
        }

        @Override
        public List readValue() {
            DecoderImpl decoder = this.getDecoder();
            ReadableBuffer buffer = decoder.getBuffer();
            int size = decoder.readRawByte() & 0xFF;
            int count = decoder.readRawByte() & 0xFF;
            TypeConstructor typeConstructor = null;
            ArrayList list = new ArrayList(count);
            for (int i = 0; i < count; ++i) {
                boolean arrayType = false;
                byte encodingCode = buffer.get(buffer.position());
                switch (encodingCode) {
                    case -32: 
                    case -16: {
                        arrayType = true;
                    }
                }
                if (typeConstructor == null) {
                    typeConstructor = this.getDecoder().readConstructor();
                } else if (encodingCode == 0 || !(typeConstructor instanceof PrimitiveTypeEncoding)) {
                    typeConstructor = this.getDecoder().readConstructor();
                } else {
                    PrimitiveTypeEncoding primitiveConstructor = (PrimitiveTypeEncoding)typeConstructor;
                    if (encodingCode != primitiveConstructor.getEncodingCode()) {
                        typeConstructor = this.getDecoder().readConstructor();
                    } else {
                        encodingCode = buffer.get();
                    }
                }
                if (typeConstructor == null) {
                    throw new DecodeException("Unknown constructor");
                }
                Object value = arrayType ? ((ArrayType.ArrayEncoding)typeConstructor).readValueArray() : typeConstructor.readValue();
                list.add(value);
            }
            return list;
        }

        @Override
        public void skipValue() {
            DecoderImpl decoder = this.getDecoder();
            ReadableBuffer buffer = decoder.getBuffer();
            int size = decoder.readRawByte() & 0xFF;
            buffer.position(buffer.position() + size);
        }

        @Override
        public void setValue(List value, int length) {
            this._value = value;
            this._length = length;
        }
    }

    private class AllListEncoding
    extends LargeFloatingSizePrimitiveTypeEncoding<List>
    implements ListEncoding {
        private List _value;
        private int _length;

        public AllListEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected void writeEncodedValue(List val) {
            this.getEncoder().writeRaw(val.size());
            int count = val.size();
            for (int i = 0; i < count; ++i) {
                Object element = val.get(i);
                TypeEncoding elementEncoding = this.getEncoder().getType(element).getEncoding(element);
                elementEncoding.writeConstructor();
                elementEncoding.writeValue(element);
            }
        }

        @Override
        protected int getEncodedValueSize(List val) {
            return 4 + (val == this._value ? this._length : ListType.calculateSize(val, this.getEncoder()));
        }

        @Override
        public byte getEncodingCode() {
            return -48;
        }

        public ListType getType() {
            return ListType.this;
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<List> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public List readValue() {
            DecoderImpl decoder = this.getDecoder();
            ReadableBuffer buffer = decoder.getBuffer();
            int size = decoder.readRawInt();
            int count = decoder.readRawInt();
            if (count > decoder.getByteBufferRemaining()) {
                throw new IllegalArgumentException("List element count " + count + " is specified to be greater than the amount of data available (" + decoder.getByteBufferRemaining() + ")");
            }
            TypeConstructor typeConstructor = null;
            ArrayList list = new ArrayList(count);
            for (int i = 0; i < count; ++i) {
                boolean arrayType = false;
                byte encodingCode = buffer.get(buffer.position());
                switch (encodingCode) {
                    case -32: 
                    case -16: {
                        arrayType = true;
                    }
                }
                if (typeConstructor == null) {
                    typeConstructor = this.getDecoder().readConstructor();
                } else if (encodingCode == 0 || !(typeConstructor instanceof PrimitiveTypeEncoding)) {
                    typeConstructor = this.getDecoder().readConstructor();
                } else {
                    PrimitiveTypeEncoding primitiveConstructor = (PrimitiveTypeEncoding)typeConstructor;
                    if (encodingCode != primitiveConstructor.getEncodingCode()) {
                        typeConstructor = this.getDecoder().readConstructor();
                    } else {
                        encodingCode = buffer.get();
                    }
                }
                if (typeConstructor == null) {
                    throw new DecodeException("Unknown constructor");
                }
                Object value = arrayType ? ((ArrayType.ArrayEncoding)typeConstructor).readValueArray() : typeConstructor.readValue();
                list.add(value);
            }
            return list;
        }

        @Override
        public void skipValue() {
            DecoderImpl decoder = this.getDecoder();
            ReadableBuffer buffer = decoder.getBuffer();
            int size = decoder.readRawInt();
            buffer.position(buffer.position() + size);
        }

        @Override
        public void setValue(List value, int length) {
            this._value = value;
            this._length = length;
        }
    }

    private static interface ListEncoding
    extends PrimitiveTypeEncoding<List> {
        public void setValue(List var1, int var2);
    }
}

