/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.BlockingTimeout;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.server.controller.resources.ServerRootResourceDefinition;
import org.jboss.dmr.ModelNode;

public class ServerSuspendHandler
implements OperationStepHandler {
    private final ServerInventory serverInventory;

    public ServerSuspendHandler(ServerInventory serverInventory) {
        this.serverInventory = serverInventory;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.getRunningMode() == RunningMode.ADMIN_ONLY) {
            throw new OperationFailedException(HostControllerLogger.ROOT_LOGGER.cannotStartServersInvalidMode(context.getRunningMode()));
        }
        final String serverName = context.getCurrentAddressValue();
        final int suspendTimeout = ServerRootResourceDefinition.TIMEOUT.resolveModelAttribute(context, operation).asInt();
        final BlockingTimeout blockingTimeout = BlockingTimeout.Factory.getProxyBlockingTimeout((OperationContext)context);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.getServiceRegistry(true);
                List<ModelNode> errorResponses = ServerSuspendHandler.this.serverInventory.suspendServers(Collections.singleton(serverName), suspendTimeout, blockingTimeout);
                if (!errorResponses.isEmpty()) {
                    context.getFailureDescription().set(errorResponses.get(0));
                }
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

