/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.api.NonceManager;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.handlers.SinglePortConfidentialityHandler;
import io.undertow.security.idm.DigestAlgorithm;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.security.impl.CachedAuthenticatedSessionMechanism;
import io.undertow.security.impl.ClientCertAuthenticationMechanism;
import io.undertow.security.impl.DigestAuthenticationMechanism;
import io.undertow.security.impl.SimpleNonceManager;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpOpenListener;
import io.undertow.server.handlers.CanonicalPathHandler;
import io.undertow.server.handlers.ChannelUpgradeHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.cache.CacheHandler;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.error.SimpleErrorPageHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ModelController;
import org.jboss.as.domain.http.server.ConsoleMode;
import org.jboss.as.domain.http.server.DomainApiCheckHandler;
import org.jboss.as.domain.http.server.ErrorContextHandler;
import org.jboss.as.domain.http.server.HttpServerLogger;
import org.jboss.as.domain.http.server.ManagementRootConsoleRedirectHandler;
import org.jboss.as.domain.http.server.ResourceHandlerDefinition;
import org.jboss.as.domain.http.server.security.AuthenticationMechanismWrapper;
import org.jboss.as.domain.http.server.security.ConnectionAuthenticationCacheHandler;
import org.jboss.as.domain.http.server.security.DmrFailureReadinessHandler;
import org.jboss.as.domain.http.server.security.LogoutHandler;
import org.jboss.as.domain.http.server.security.RealmIdentityManager;
import org.jboss.as.domain.http.server.security.RealmReadinessHandler;
import org.jboss.as.domain.http.server.security.RedirectReadinessHandler;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.SslClientAuthMode;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.SslConnection;
import org.xnio.ssl.JsseXnioSsl;

public class ManagementHttpServer {
    private final HttpOpenListener openListener;
    private final InetSocketAddress httpAddress;
    private final InetSocketAddress secureAddress;
    private volatile XnioWorker worker;
    private volatile AcceptingChannel<StreamConnection> normalServer;
    private volatile AcceptingChannel<SslConnection> secureServer;
    private final SecurityRealm securityRealm;

    private ManagementHttpServer(HttpOpenListener openListener, InetSocketAddress httpAddress, InetSocketAddress secureAddress, SecurityRealm securityRealm) {
        this.openListener = openListener;
        this.httpAddress = httpAddress;
        this.secureAddress = secureAddress;
        this.securityRealm = securityRealm;
    }

    public void start() {
        Xnio xnio;
        try {
            xnio = Xnio.getInstance(null, (ClassLoader)Module.getModuleFromCallerModuleLoader((ModuleIdentifier)ModuleIdentifier.fromString((String)"org.jboss.xnio.nio")).getClassLoader());
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getLocalizedMessage());
        }
        try {
            this.worker = xnio.createWorker(OptionMap.builder().set(Options.WORKER_IO_THREADS, 4).set(Options.CONNECTION_HIGH_WATER, 1000000).set(Options.CONNECTION_LOW_WATER, 1000000).set(Options.WORKER_TASK_CORE_THREADS, 10).set(Options.WORKER_TASK_MAX_THREADS, 12).set(Options.TCP_NODELAY, true).set(Options.CORK, true).getMap());
            OptionMap.Builder serverOptionsBuilder = OptionMap.builder().set(Options.TCP_NODELAY, true).set(Options.REUSE_ADDRESSES, true);
            ChannelListener acceptListener = ChannelListeners.openListenerAdapter((ChannelListener)this.openListener);
            if (this.httpAddress != null) {
                this.normalServer = this.worker.createStreamConnectionServer((SocketAddress)this.httpAddress, acceptListener, serverOptionsBuilder.getMap());
                this.normalServer.resumeAccepts();
            }
            if (this.secureAddress != null) {
                SSLContext sslContext = this.securityRealm.getSSLContext();
                Set supportedMechanisms = this.securityRealm.getSupportedAuthenticationMechanisms();
                if (supportedMechanisms.contains(AuthMechanism.CLIENT_CERT)) {
                    if (supportedMechanisms.contains(AuthMechanism.DIGEST) || supportedMechanisms.contains(AuthMechanism.PLAIN)) {
                        serverOptionsBuilder.set(Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.REQUESTED);
                    } else {
                        serverOptionsBuilder.set(Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.REQUIRED);
                    }
                }
                OptionMap secureOptions = serverOptionsBuilder.getMap();
                JsseXnioSsl xnioSsl = new JsseXnioSsl(this.worker.getXnio(), secureOptions, sslContext);
                this.secureServer = xnioSsl.createSslConnectionServer(this.worker, this.secureAddress, acceptListener, secureOptions);
                this.secureServer.resumeAccepts();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        IoUtils.safeClose(this.normalServer);
        IoUtils.safeClose(this.secureServer);
        this.worker.shutdown();
    }

    public static ManagementHttpServer create(InetSocketAddress bindAddress, InetSocketAddress secureBindAddress, int backlog, ModelController modelController, SecurityRealm securityRealm, ControlledProcessStateService controlledProcessStateService, ConsoleMode consoleMode, String consoleSlot, ChannelUpgradeHandler upgradeHandler) throws IOException {
        HttpOpenListener openListener = new HttpOpenListener((Pool)new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, 4096, 40960), 4096);
        int securePort = secureBindAddress != null ? secureBindAddress.getPort() : -1;
        ManagementHttpServer.setupOpenListener(openListener, modelController, consoleMode, consoleSlot, controlledProcessStateService, securePort, securityRealm, upgradeHandler);
        ManagementHttpServer server = new ManagementHttpServer(openListener, bindAddress, secureBindAddress, securityRealm);
        return server;
    }

    private static void setupOpenListener(HttpOpenListener listener, ModelController modelController, ConsoleMode consoleMode, String consoleSlot, ControlledProcessStateService controlledProcessStateService, int securePort, SecurityRealm securityRealm, ChannelUpgradeHandler upgradeHandler) {
        RealmReadinessHandler readinessHandler;
        PathHandler pathHandler;
        CanonicalPathHandler canonicalPathHandler = new CanonicalPathHandler();
        listener.setRootHandler((HttpHandler)canonicalPathHandler);
        PathHandler current = pathHandler = new PathHandler();
        if (securePort > 0) {
            current = new SinglePortConfidentialityHandler((HttpHandler)current, securePort);
        }
        current = new CacheHandler(new DirectBufferCache(1024, 10240, 1024000, BufferAllocator.BYTE_BUFFER_ALLOCATOR), (HttpHandler)current);
        current = new SimpleErrorPageHandler((HttpHandler)current);
        if (upgradeHandler != null) {
            upgradeHandler.setNonUpgradeHandler((HttpHandler)current);
            current = upgradeHandler;
        }
        canonicalPathHandler.setNext((HttpHandler)current);
        ResourceHandlerDefinition consoleHandler = null;
        try {
            consoleHandler = consoleMode.createConsoleHandler(consoleSlot);
        }
        catch (ModuleLoadException e) {
            HttpServerLogger.ROOT_LOGGER.consoleModuleNotFound(consoleSlot == null ? "main" : consoleSlot);
        }
        try {
            pathHandler.addPath("/error", ErrorContextHandler.createErrorContext(consoleSlot));
        }
        catch (ModuleLoadException e) {
            HttpServerLogger.ROOT_LOGGER.error(consoleSlot == null ? "main" : consoleSlot);
        }
        ManagementRootConsoleRedirectHandler rootConsoleRedirectHandler = new ManagementRootConsoleRedirectHandler(consoleHandler);
        DomainApiCheckHandler domainApiHandler = new DomainApiCheckHandler(modelController, controlledProcessStateService);
        pathHandler.addPath("/", (HttpHandler)rootConsoleRedirectHandler);
        if (consoleHandler != null) {
            readinessHandler = new RedirectReadinessHandler(securityRealm, consoleHandler.getHandler(), "/error");
            pathHandler.addPath(consoleHandler.getContext(), (HttpHandler)readinessHandler);
        }
        readinessHandler = new DmrFailureReadinessHandler(securityRealm, ManagementHttpServer.secureDomainAccess(domainApiHandler, securityRealm), "/error");
        pathHandler.addPath(DomainApiCheckHandler.PATH, (HttpHandler)readinessHandler);
        if (securityRealm != null) {
            pathHandler.addPath("/logout", (HttpHandler)new LogoutHandler(securityRealm.getName()));
        }
    }

    private static HttpHandler secureDomainAccess(HttpHandler domainHandler, SecurityRealm securityRealm) {
        if (securityRealm != null) {
            Set mechanisms = securityRealm.getSupportedAuthenticationMechanisms();
            ArrayList<AuthenticationMechanism> undertowMechanisms = new ArrayList<AuthenticationMechanism>(mechanisms.size());
            undertowMechanisms.add(ManagementHttpServer.wrap((AuthenticationMechanism)new CachedAuthenticatedSessionMechanism(), null));
            for (AuthMechanism current : mechanisms) {
                switch (current) {
                    case CLIENT_CERT: {
                        undertowMechanisms.add(ManagementHttpServer.wrap((AuthenticationMechanism)new ClientCertAuthenticationMechanism(), current));
                        break;
                    }
                    case DIGEST: {
                        List<DigestAlgorithm> digestAlgorithms = Collections.singletonList(DigestAlgorithm.MD5);
                        List digestQops = Collections.emptyList();
                        undertowMechanisms.add(ManagementHttpServer.wrap((AuthenticationMechanism)new DigestAuthenticationMechanism(digestAlgorithms, digestQops, securityRealm.getName(), "/management", (NonceManager)new SimpleNonceManager()), current));
                        break;
                    }
                    case PLAIN: {
                        undertowMechanisms.add(ManagementHttpServer.wrap((AuthenticationMechanism)new BasicAuthenticationMechanism(securityRealm.getName()), current));
                    }
                }
            }
            if (undertowMechanisms.size() > 1) {
                HttpHandler current = domainHandler;
                current = new AuthenticationCallHandler(current);
                current = new AuthenticationConstraintHandler(current);
                current = new AuthenticationMechanismsHandler(current, undertowMechanisms);
                current = new ConnectionAuthenticationCacheHandler(current);
                return new SecurityInitialHandler(AuthenticationMode.PRO_ACTIVE, (IdentityManager)new RealmIdentityManager(securityRealm), current);
            }
        }
        return domainHandler;
    }

    private static AuthenticationMechanism wrap(AuthenticationMechanism toWrap, AuthMechanism mechanism) {
        return new AuthenticationMechanismWrapper(toWrap, mechanism);
    }
}

