/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;
import org.wildfly.clustering.marshalling.spi.util.CollectionExternalizer;

public class SortedSetExternalizer<T extends SortedSet<Object>>
implements Externalizer<T> {
    private final Class<T> targetClass;
    private final Function<Comparator<? super Object>, T> factory;

    public SortedSetExternalizer(Class<?> targetClass, Function<Comparator<? super Object>, T> factory) {
        this.targetClass = targetClass;
        this.factory = factory;
    }

    public void writeObject(ObjectOutput output, T set) throws IOException {
        output.writeObject(set.comparator());
        CollectionExternalizer.writeCollection(output, set);
    }

    public T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Comparator comparator = (Comparator)input.readObject();
        int size = IndexSerializer.VARIABLE.readInt(input);
        return (T)((SortedSet)CollectionExternalizer.readCollection(input, (Collection)this.factory.apply(comparator), size));
    }

    public Class<T> getTargetClass() {
        return this.targetClass;
    }
}

