/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.jboss.as.controller.OperationContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.extension.messaging.activemq.SecurityRoleDefinition;

public class ManagementUtil {
    public static void reportRolesAsJSON(OperationContext context, String rolesAsJSON) {
        ModelNode camelCase = ModelNode.fromJSONString((String)rolesAsJSON);
        ModelNode converted = ManagementUtil.convertSecurityRole(camelCase);
        String json = converted.toJSONString(true);
        context.getResult().set(json);
    }

    public static void reportRoles(OperationContext context, String rolesAsJSON) {
        ModelNode camelCase = ModelNode.fromJSONString((String)rolesAsJSON);
        ModelNode converted = ManagementUtil.convertSecurityRole(camelCase);
        context.getResult().set(converted);
    }

    public static void reportListOfStrings(OperationContext context, String[] strings) {
        ModelNode result = context.getResult();
        result.setEmptyList();
        for (String str : strings) {
            result.add(str);
        }
    }

    private ManagementUtil() {
    }

    static ModelNode convertSecurityRole(ModelNode camelCase) {
        ModelNode result = new ModelNode();
        result.setEmptyList();
        if (camelCase.isDefined()) {
            for (ModelNode role : camelCase.asList()) {
                ModelNode roleNode = result.add();
                for (Property prop : role.asPropertyList()) {
                    String key = prop.getName();
                    if ("createDurableQueue".equals(key)) {
                        key = SecurityRoleDefinition.CREATE_DURABLE_QUEUE.getName();
                    } else if ("deleteDurableQueue".equals(key)) {
                        key = SecurityRoleDefinition.DELETE_DURABLE_QUEUE.getName();
                    } else if ("createNonDurableQueue".equals(key)) {
                        key = SecurityRoleDefinition.CREATE_NON_DURABLE_QUEUE.getName();
                    } else if ("deleteNonDurableQueue".equals(key)) {
                        key = SecurityRoleDefinition.DELETE_NON_DURABLE_QUEUE.getName();
                    }
                    roleNode.get(key).set(prop.getValue());
                }
            }
        }
        return result;
    }
}

